/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the dataflow endpoint <code>Config</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataflowEndpointConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DataflowEndpointConfig.Builder, DataflowEndpointConfig> {
    private static final SdkField<String> DATAFLOW_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowEndpointName").getter(getter(DataflowEndpointConfig::dataflowEndpointName))
            .setter(setter(Builder::dataflowEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointName").build())
            .build();

    private static final SdkField<String> DATAFLOW_ENDPOINT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowEndpointRegion").getter(getter(DataflowEndpointConfig::dataflowEndpointRegion))
            .setter(setter(Builder::dataflowEndpointRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAFLOW_ENDPOINT_NAME_FIELD,
            DATAFLOW_ENDPOINT_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataflowEndpointName;

    private final String dataflowEndpointRegion;

    private DataflowEndpointConfig(BuilderImpl builder) {
        this.dataflowEndpointName = builder.dataflowEndpointName;
        this.dataflowEndpointRegion = builder.dataflowEndpointRegion;
    }

    /**
     * <p>
     * Name of a dataflow endpoint.
     * </p>
     * 
     * @return Name of a dataflow endpoint.
     */
    public final String dataflowEndpointName() {
        return dataflowEndpointName;
    }

    /**
     * <p>
     * Region of a dataflow endpoint.
     * </p>
     * 
     * @return Region of a dataflow endpoint.
     */
    public final String dataflowEndpointRegion() {
        return dataflowEndpointRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataflowEndpointConfig)) {
            return false;
        }
        DataflowEndpointConfig other = (DataflowEndpointConfig) obj;
        return Objects.equals(dataflowEndpointName(), other.dataflowEndpointName())
                && Objects.equals(dataflowEndpointRegion(), other.dataflowEndpointRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataflowEndpointConfig").add("DataflowEndpointName", dataflowEndpointName())
                .add("DataflowEndpointRegion", dataflowEndpointRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataflowEndpointName":
            return Optional.ofNullable(clazz.cast(dataflowEndpointName()));
        case "dataflowEndpointRegion":
            return Optional.ofNullable(clazz.cast(dataflowEndpointRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataflowEndpointConfig, T> g) {
        return obj -> g.apply((DataflowEndpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataflowEndpointConfig> {
        /**
         * <p>
         * Name of a dataflow endpoint.
         * </p>
         * 
         * @param dataflowEndpointName
         *        Name of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointName(String dataflowEndpointName);

        /**
         * <p>
         * Region of a dataflow endpoint.
         * </p>
         * 
         * @param dataflowEndpointRegion
         *        Region of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointRegion(String dataflowEndpointRegion);
    }

    static final class BuilderImpl implements Builder {
        private String dataflowEndpointName;

        private String dataflowEndpointRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DataflowEndpointConfig model) {
            dataflowEndpointName(model.dataflowEndpointName);
            dataflowEndpointRegion(model.dataflowEndpointRegion);
        }

        public final String getDataflowEndpointName() {
            return dataflowEndpointName;
        }

        public final void setDataflowEndpointName(String dataflowEndpointName) {
            this.dataflowEndpointName = dataflowEndpointName;
        }

        @Override
        @Transient
        public final Builder dataflowEndpointName(String dataflowEndpointName) {
            this.dataflowEndpointName = dataflowEndpointName;
            return this;
        }

        public final String getDataflowEndpointRegion() {
            return dataflowEndpointRegion;
        }

        public final void setDataflowEndpointRegion(String dataflowEndpointRegion) {
            this.dataflowEndpointRegion = dataflowEndpointRegion;
        }

        @Override
        @Transient
        public final Builder dataflowEndpointRegion(String dataflowEndpointRegion) {
            this.dataflowEndpointRegion = dataflowEndpointRegion;
            return this;
        }

        @Override
        public DataflowEndpointConfig build() {
            return new DataflowEndpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
