/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataflowEndpointGroupsResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListDataflowEndpointGroupsResponse.Builder, ListDataflowEndpointGroupsResponse> {
    private static final SdkField<List<DataflowEndpointListItem>> DATAFLOW_ENDPOINT_GROUP_LIST_FIELD = SdkField
            .<List<DataflowEndpointListItem>> builder(MarshallingType.LIST)
            .memberName("dataflowEndpointGroupList")
            .getter(getter(ListDataflowEndpointGroupsResponse::dataflowEndpointGroupList))
            .setter(setter(Builder::dataflowEndpointGroupList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataflowEndpointListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataflowEndpointListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataflowEndpointGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATAFLOW_ENDPOINT_GROUP_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<DataflowEndpointListItem> dataflowEndpointGroupList;

    private final String nextToken;

    private ListDataflowEndpointGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.dataflowEndpointGroupList = builder.dataflowEndpointGroupList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataflowEndpointGroupList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataflowEndpointGroupList() {
        return dataflowEndpointGroupList != null && !(dataflowEndpointGroupList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dataflow endpoint groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataflowEndpointGroupList} method.
     * </p>
     * 
     * @return A list of dataflow endpoint groups.
     */
    public final List<DataflowEndpointListItem> dataflowEndpointGroupList() {
        return dataflowEndpointGroupList;
    }

    /**
     * <p>
     * Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the
     * next page of results.
     * </p>
     * 
     * @return Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to
     *         get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataflowEndpointGroupList() ? dataflowEndpointGroupList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataflowEndpointGroupsResponse)) {
            return false;
        }
        ListDataflowEndpointGroupsResponse other = (ListDataflowEndpointGroupsResponse) obj;
        return hasDataflowEndpointGroupList() == other.hasDataflowEndpointGroupList()
                && Objects.equals(dataflowEndpointGroupList(), other.dataflowEndpointGroupList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataflowEndpointGroupsResponse")
                .add("DataflowEndpointGroupList", hasDataflowEndpointGroupList() ? dataflowEndpointGroupList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataflowEndpointGroupList":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataflowEndpointGroupsResponse, T> g) {
        return obj -> g.apply((ListDataflowEndpointGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataflowEndpointGroupsResponse> {
        /**
         * <p>
         * A list of dataflow endpoint groups.
         * </p>
         * 
         * @param dataflowEndpointGroupList
         *        A list of dataflow endpoint groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupList(Collection<DataflowEndpointListItem> dataflowEndpointGroupList);

        /**
         * <p>
         * A list of dataflow endpoint groups.
         * </p>
         * 
         * @param dataflowEndpointGroupList
         *        A list of dataflow endpoint groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupList(DataflowEndpointListItem... dataflowEndpointGroupList);

        /**
         * <p>
         * A list of dataflow endpoint groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataflowEndpointListItem>.Builder} avoiding
         * the need to create one manually via {@link List<DataflowEndpointListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataflowEndpointListItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #dataflowEndpointGroupList(List<DataflowEndpointListItem>)}.
         * 
         * @param dataflowEndpointGroupList
         *        a consumer that will call methods on {@link List<DataflowEndpointListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataflowEndpointGroupList(List<DataflowEndpointListItem>)
         */
        Builder dataflowEndpointGroupList(Consumer<DataflowEndpointListItem.Builder>... dataflowEndpointGroupList);

        /**
         * <p>
         * Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to get
         * the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used
         *        to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private List<DataflowEndpointListItem> dataflowEndpointGroupList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataflowEndpointGroupsResponse model) {
            super(model);
            dataflowEndpointGroupList(model.dataflowEndpointGroupList);
            nextToken(model.nextToken);
        }

        public final List<DataflowEndpointListItem.Builder> getDataflowEndpointGroupList() {
            List<DataflowEndpointListItem.Builder> result = DataflowEndpointGroupListCopier
                    .copyToBuilder(this.dataflowEndpointGroupList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataflowEndpointGroupList(Collection<DataflowEndpointListItem.BuilderImpl> dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList = DataflowEndpointGroupListCopier.copyFromBuilder(dataflowEndpointGroupList);
        }

        @Override
        @Transient
        public final Builder dataflowEndpointGroupList(Collection<DataflowEndpointListItem> dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList = DataflowEndpointGroupListCopier.copy(dataflowEndpointGroupList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataflowEndpointGroupList(DataflowEndpointListItem... dataflowEndpointGroupList) {
            dataflowEndpointGroupList(Arrays.asList(dataflowEndpointGroupList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataflowEndpointGroupList(Consumer<DataflowEndpointListItem.Builder>... dataflowEndpointGroupList) {
            dataflowEndpointGroupList(Stream.of(dataflowEndpointGroupList)
                    .map(c -> DataflowEndpointListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataflowEndpointGroupsResponse build() {
            return new ListDataflowEndpointGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
