/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an S3 recording <code>Config</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3RecordingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<S3RecordingConfig.Builder, S3RecordingConfig> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketArn").getter(getter(S3RecordingConfig::bucketArn)).setter(setter(Builder::bucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(S3RecordingConfig::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(S3RecordingConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            PREFIX_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketArn;

    private final String prefix;

    private final String roleArn;

    private S3RecordingConfig(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.prefix = builder.prefix;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * ARN of the bucket to record to.
     * </p>
     * 
     * @return ARN of the bucket to record to.
     */
    public final String bucketArn() {
        return bucketArn;
    }

    /**
     * <p>
     * S3 Key prefix to prefice data files.
     * </p>
     * 
     * @return S3 Key prefix to prefice data files.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * ARN of the role Ground Station assumes to write data to the bucket.
     * </p>
     * 
     * @return ARN of the role Ground Station assumes to write data to the bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3RecordingConfig)) {
            return false;
        }
        S3RecordingConfig other = (S3RecordingConfig) obj;
        return Objects.equals(bucketArn(), other.bucketArn()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3RecordingConfig").add("BucketArn", bucketArn()).add("Prefix", prefix())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketArn":
            return Optional.ofNullable(clazz.cast(bucketArn()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3RecordingConfig, T> g) {
        return obj -> g.apply((S3RecordingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3RecordingConfig> {
        /**
         * <p>
         * ARN of the bucket to record to.
         * </p>
         * 
         * @param bucketArn
         *        ARN of the bucket to record to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketArn(String bucketArn);

        /**
         * <p>
         * S3 Key prefix to prefice data files.
         * </p>
         * 
         * @param prefix
         *        S3 Key prefix to prefice data files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * ARN of the role Ground Station assumes to write data to the bucket.
         * </p>
         * 
         * @param roleArn
         *        ARN of the role Ground Station assumes to write data to the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String bucketArn;

        private String prefix;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3RecordingConfig model) {
            bucketArn(model.bucketArn);
            prefix(model.prefix);
            roleArn(model.roleArn);
        }

        public final String getBucketArn() {
            return bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        @Transient
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public S3RecordingConfig build() {
            return new S3RecordingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
