/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dataflow details for the destination side.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<ConfigDetails> CONFIG_DETAILS_FIELD = SdkField
            .<ConfigDetails> builder(MarshallingType.SDK_POJO).memberName("configDetails")
            .getter(getter(Destination::configDetails)).setter(setter(Builder::configDetails))
            .constructor(ConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configDetails").build()).build();

    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configId").getter(getter(Destination::configId)).setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()).build();

    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configType").getter(getter(Destination::configTypeAsString)).setter(setter(Builder::configType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()).build();

    private static final SdkField<String> DATAFLOW_DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowDestinationRegion").getter(getter(Destination::dataflowDestinationRegion))
            .setter(setter(Builder::dataflowDestinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowDestinationRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_DETAILS_FIELD,
            CONFIG_ID_FIELD, CONFIG_TYPE_FIELD, DATAFLOW_DESTINATION_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConfigDetails configDetails;

    private final String configId;

    private final String configType;

    private final String dataflowDestinationRegion;

    private Destination(BuilderImpl builder) {
        this.configDetails = builder.configDetails;
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.dataflowDestinationRegion = builder.dataflowDestinationRegion;
    }

    /**
     * <p>
     * Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.
     * </p>
     * 
     * @return Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.
     */
    public final ConfigDetails configDetails() {
        return configDetails;
    }

    /**
     * <p>
     * UUID of a <code>Config</code>.
     * </p>
     * 
     * @return UUID of a <code>Config</code>.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(configType);
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final String configTypeAsString() {
        return configType;
    }

    /**
     * <p>
     * Region of a dataflow destination.
     * </p>
     * 
     * @return Region of a dataflow destination.
     */
    public final String dataflowDestinationRegion() {
        return dataflowDestinationRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configDetails());
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowDestinationRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(configDetails(), other.configDetails()) && Objects.equals(configId(), other.configId())
                && Objects.equals(configTypeAsString(), other.configTypeAsString())
                && Objects.equals(dataflowDestinationRegion(), other.dataflowDestinationRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Destination").add("ConfigDetails", configDetails()).add("ConfigId", configId())
                .add("ConfigType", configTypeAsString()).add("DataflowDestinationRegion", dataflowDestinationRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configDetails":
            return Optional.ofNullable(clazz.cast(configDetails()));
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "configType":
            return Optional.ofNullable(clazz.cast(configTypeAsString()));
        case "dataflowDestinationRegion":
            return Optional.ofNullable(clazz.cast(dataflowDestinationRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.
         * </p>
         * 
         * @param configDetails
         *        Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configDetails(ConfigDetails configDetails);

        /**
         * <p>
         * Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigDetails.Builder} avoiding the need
         * to create one manually via {@link ConfigDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #configDetails(ConfigDetails)}.
         * 
         * @param configDetails
         *        a consumer that will call methods on {@link ConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configDetails(ConfigDetails)
         */
        default Builder configDetails(Consumer<ConfigDetails.Builder> configDetails) {
            return configDetails(ConfigDetails.builder().applyMutation(configDetails).build());
        }

        /**
         * <p>
         * UUID of a <code>Config</code>.
         * </p>
         * 
         * @param configId
         *        UUID of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(String configType);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(ConfigCapabilityType configType);

        /**
         * <p>
         * Region of a dataflow destination.
         * </p>
         * 
         * @param dataflowDestinationRegion
         *        Region of a dataflow destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowDestinationRegion(String dataflowDestinationRegion);
    }

    static final class BuilderImpl implements Builder {
        private ConfigDetails configDetails;

        private String configId;

        private String configType;

        private String dataflowDestinationRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            configDetails(model.configDetails);
            configId(model.configId);
            configType(model.configType);
            dataflowDestinationRegion(model.dataflowDestinationRegion);
        }

        public final ConfigDetails.Builder getConfigDetails() {
            return configDetails != null ? configDetails.toBuilder() : null;
        }

        public final void setConfigDetails(ConfigDetails.BuilderImpl configDetails) {
            this.configDetails = configDetails != null ? configDetails.build() : null;
        }

        @Override
        public final Builder configDetails(ConfigDetails configDetails) {
            this.configDetails = configDetails;
            return this;
        }

        public final String getConfigId() {
            return configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getConfigType() {
            return configType;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final String getDataflowDestinationRegion() {
            return dataflowDestinationRegion;
        }

        public final void setDataflowDestinationRegion(String dataflowDestinationRegion) {
            this.dataflowDestinationRegion = dataflowDestinationRegion;
        }

        @Override
        public final Builder dataflowDestinationRegion(String dataflowDestinationRegion) {
            this.dataflowDestinationRegion = dataflowDestinationRegion;
            return this;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
