/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroundStationsResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListGroundStationsResponse.Builder, ListGroundStationsResponse> {
    private static final SdkField<List<GroundStationData>> GROUND_STATION_LIST_FIELD = SdkField
            .<List<GroundStationData>> builder(MarshallingType.LIST)
            .memberName("groundStationList")
            .getter(getter(ListGroundStationsResponse::groundStationList))
            .setter(setter(Builder::groundStationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroundStationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroundStationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListGroundStationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_STATION_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GroundStationData> groundStationList;

    private final String nextToken;

    private ListGroundStationsResponse(BuilderImpl builder) {
        super(builder);
        this.groundStationList = builder.groundStationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroundStationList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroundStationList() {
        return groundStationList != null && !(groundStationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ground stations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroundStationList} method.
     * </p>
     * 
     * @return List of ground stations.
     */
    public final List<GroundStationData> groundStationList() {
        return groundStationList;
    }

    /**
     * <p>
     * Next token that can be supplied in the next call to get the next page of ground stations.
     * </p>
     * 
     * @return Next token that can be supplied in the next call to get the next page of ground stations.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGroundStationList() ? groundStationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroundStationsResponse)) {
            return false;
        }
        ListGroundStationsResponse other = (ListGroundStationsResponse) obj;
        return hasGroundStationList() == other.hasGroundStationList()
                && Objects.equals(groundStationList(), other.groundStationList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroundStationsResponse")
                .add("GroundStationList", hasGroundStationList() ? groundStationList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groundStationList":
            return Optional.ofNullable(clazz.cast(groundStationList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroundStationsResponse, T> g) {
        return obj -> g.apply((ListGroundStationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGroundStationsResponse> {
        /**
         * <p>
         * List of ground stations.
         * </p>
         * 
         * @param groundStationList
         *        List of ground stations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStationList(Collection<GroundStationData> groundStationList);

        /**
         * <p>
         * List of ground stations.
         * </p>
         * 
         * @param groundStationList
         *        List of ground stations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStationList(GroundStationData... groundStationList);

        /**
         * <p>
         * List of ground stations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<GroundStationData>.Builder} avoiding
         * the need to create one manually via {@link List<GroundStationData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroundStationData>.Builder#build()} is called immediately
         * and its result is passed to {@link #groundStationList(List<GroundStationData>)}.
         * 
         * @param groundStationList
         *        a consumer that will call methods on {@link List<GroundStationData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groundStationList(List<GroundStationData>)
         */
        Builder groundStationList(Consumer<GroundStationData.Builder>... groundStationList);

        /**
         * <p>
         * Next token that can be supplied in the next call to get the next page of ground stations.
         * </p>
         * 
         * @param nextToken
         *        Next token that can be supplied in the next call to get the next page of ground stations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private List<GroundStationData> groundStationList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroundStationsResponse model) {
            super(model);
            groundStationList(model.groundStationList);
            nextToken(model.nextToken);
        }

        public final List<GroundStationData.Builder> getGroundStationList() {
            List<GroundStationData.Builder> result = GroundStationListCopier.copyToBuilder(this.groundStationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroundStationList(Collection<GroundStationData.BuilderImpl> groundStationList) {
            this.groundStationList = GroundStationListCopier.copyFromBuilder(groundStationList);
        }

        @Override
        public final Builder groundStationList(Collection<GroundStationData> groundStationList) {
            this.groundStationList = GroundStationListCopier.copy(groundStationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groundStationList(GroundStationData... groundStationList) {
            groundStationList(Arrays.asList(groundStationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groundStationList(Consumer<GroundStationData.Builder>... groundStationList) {
            groundStationList(Stream.of(groundStationList).map(c -> GroundStationData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroundStationsResponse build() {
            return new ListGroundStationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
