/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the uplink spectral <code>Config</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UplinkSpectrumConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UplinkSpectrumConfig.Builder, UplinkSpectrumConfig> {
    private static final SdkField<Frequency> CENTER_FREQUENCY_FIELD = SdkField.<Frequency> builder(MarshallingType.SDK_POJO)
            .memberName("centerFrequency").getter(getter(UplinkSpectrumConfig::centerFrequency))
            .setter(setter(Builder::centerFrequency)).constructor(Frequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("centerFrequency").build()).build();

    private static final SdkField<String> POLARIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("polarization").getter(getter(UplinkSpectrumConfig::polarizationAsString))
            .setter(setter(Builder::polarization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("polarization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CENTER_FREQUENCY_FIELD,
            POLARIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Frequency centerFrequency;

    private final String polarization;

    private UplinkSpectrumConfig(BuilderImpl builder) {
        this.centerFrequency = builder.centerFrequency;
        this.polarization = builder.polarization;
    }

    /**
     * <p>
     * Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.
     * </p>
     * 
     * @return Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.
     */
    public final Frequency centerFrequency() {
        return centerFrequency;
    }

    /**
     * <p>
     * Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
     * <code>"LEFT_HAND"</code> polarization requires two separate configs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #polarization} will
     * return {@link Polarization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #polarizationAsString}.
     * </p>
     * 
     * @return Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
     *         <code>"LEFT_HAND"</code> polarization requires two separate configs.
     * @see Polarization
     */
    public final Polarization polarization() {
        return Polarization.fromValue(polarization);
    }

    /**
     * <p>
     * Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
     * <code>"LEFT_HAND"</code> polarization requires two separate configs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #polarization} will
     * return {@link Polarization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #polarizationAsString}.
     * </p>
     * 
     * @return Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
     *         <code>"LEFT_HAND"</code> polarization requires two separate configs.
     * @see Polarization
     */
    public final String polarizationAsString() {
        return polarization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(centerFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(polarizationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UplinkSpectrumConfig)) {
            return false;
        }
        UplinkSpectrumConfig other = (UplinkSpectrumConfig) obj;
        return Objects.equals(centerFrequency(), other.centerFrequency())
                && Objects.equals(polarizationAsString(), other.polarizationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UplinkSpectrumConfig").add("CenterFrequency", centerFrequency())
                .add("Polarization", polarizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "centerFrequency":
            return Optional.ofNullable(clazz.cast(centerFrequency()));
        case "polarization":
            return Optional.ofNullable(clazz.cast(polarizationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UplinkSpectrumConfig, T> g) {
        return obj -> g.apply((UplinkSpectrumConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UplinkSpectrumConfig> {
        /**
         * <p>
         * Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.
         * </p>
         * 
         * @param centerFrequency
         *        Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder centerFrequency(Frequency centerFrequency);

        /**
         * <p>
         * Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.
         * </p>
         * This is a convenience method that creates an instance of the {@link Frequency.Builder} avoiding the need to
         * create one manually via {@link Frequency#builder()}.
         *
         * When the {@link Consumer} completes, {@link Frequency.Builder#build()} is called immediately and its result
         * is passed to {@link #centerFrequency(Frequency)}.
         * 
         * @param centerFrequency
         *        a consumer that will call methods on {@link Frequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #centerFrequency(Frequency)
         */
        default Builder centerFrequency(Consumer<Frequency.Builder> centerFrequency) {
            return centerFrequency(Frequency.builder().applyMutation(centerFrequency).build());
        }

        /**
         * <p>
         * Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
         * <code>"LEFT_HAND"</code> polarization requires two separate configs.
         * </p>
         * 
         * @param polarization
         *        Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
         *        <code>"LEFT_HAND"</code> polarization requires two separate configs.
         * @see Polarization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Polarization
         */
        Builder polarization(String polarization);

        /**
         * <p>
         * Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
         * <code>"LEFT_HAND"</code> polarization requires two separate configs.
         * </p>
         * 
         * @param polarization
         *        Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and
         *        <code>"LEFT_HAND"</code> polarization requires two separate configs.
         * @see Polarization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Polarization
         */
        Builder polarization(Polarization polarization);
    }

    static final class BuilderImpl implements Builder {
        private Frequency centerFrequency;

        private String polarization;

        private BuilderImpl() {
        }

        private BuilderImpl(UplinkSpectrumConfig model) {
            centerFrequency(model.centerFrequency);
            polarization(model.polarization);
        }

        public final Frequency.Builder getCenterFrequency() {
            return centerFrequency != null ? centerFrequency.toBuilder() : null;
        }

        public final void setCenterFrequency(Frequency.BuilderImpl centerFrequency) {
            this.centerFrequency = centerFrequency != null ? centerFrequency.build() : null;
        }

        @Override
        public final Builder centerFrequency(Frequency centerFrequency) {
            this.centerFrequency = centerFrequency;
            return this;
        }

        public final String getPolarization() {
            return polarization;
        }

        public final void setPolarization(String polarization) {
            this.polarization = polarization;
        }

        @Override
        public final Builder polarization(String polarization) {
            this.polarization = polarization;
            return this;
        }

        @Override
        public final Builder polarization(Polarization polarization) {
            this.polarization(polarization == null ? null : polarization.toString());
            return this;
        }

        @Override
        public UplinkSpectrumConfig build() {
            return new UplinkSpectrumConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
