/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the uplink <code>Config</code> of an antenna.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AntennaUplinkConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AntennaUplinkConfig.Builder, AntennaUplinkConfig> {
    private static final SdkField<UplinkSpectrumConfig> SPECTRUM_CONFIG_FIELD = SdkField
            .<UplinkSpectrumConfig> builder(MarshallingType.SDK_POJO).memberName("spectrumConfig")
            .getter(getter(AntennaUplinkConfig::spectrumConfig)).setter(setter(Builder::spectrumConfig))
            .constructor(UplinkSpectrumConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spectrumConfig").build()).build();

    private static final SdkField<Eirp> TARGET_EIRP_FIELD = SdkField.<Eirp> builder(MarshallingType.SDK_POJO)
            .memberName("targetEirp").getter(getter(AntennaUplinkConfig::targetEirp)).setter(setter(Builder::targetEirp))
            .constructor(Eirp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetEirp").build()).build();

    private static final SdkField<Boolean> TRANSMIT_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("transmitDisabled").getter(getter(AntennaUplinkConfig::transmitDisabled))
            .setter(setter(Builder::transmitDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transmitDisabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECTRUM_CONFIG_FIELD,
            TARGET_EIRP_FIELD, TRANSMIT_DISABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final UplinkSpectrumConfig spectrumConfig;

    private final Eirp targetEirp;

    private final Boolean transmitDisabled;

    private AntennaUplinkConfig(BuilderImpl builder) {
        this.spectrumConfig = builder.spectrumConfig;
        this.targetEirp = builder.targetEirp;
        this.transmitDisabled = builder.transmitDisabled;
    }

    /**
     * <p>
     * Information about the uplink spectral <code>Config</code>.
     * </p>
     * 
     * @return Information about the uplink spectral <code>Config</code>.
     */
    public final UplinkSpectrumConfig spectrumConfig() {
        return spectrumConfig;
    }

    /**
     * <p>
     * EIRP of the target.
     * </p>
     * 
     * @return EIRP of the target.
     */
    public final Eirp targetEirp() {
        return targetEirp;
    }

    /**
     * <p>
     * Whether or not uplink transmit is disabled.
     * </p>
     * 
     * @return Whether or not uplink transmit is disabled.
     */
    public final Boolean transmitDisabled() {
        return transmitDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spectrumConfig());
        hashCode = 31 * hashCode + Objects.hashCode(targetEirp());
        hashCode = 31 * hashCode + Objects.hashCode(transmitDisabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaUplinkConfig)) {
            return false;
        }
        AntennaUplinkConfig other = (AntennaUplinkConfig) obj;
        return Objects.equals(spectrumConfig(), other.spectrumConfig()) && Objects.equals(targetEirp(), other.targetEirp())
                && Objects.equals(transmitDisabled(), other.transmitDisabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AntennaUplinkConfig").add("SpectrumConfig", spectrumConfig()).add("TargetEirp", targetEirp())
                .add("TransmitDisabled", transmitDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spectrumConfig":
            return Optional.ofNullable(clazz.cast(spectrumConfig()));
        case "targetEirp":
            return Optional.ofNullable(clazz.cast(targetEirp()));
        case "transmitDisabled":
            return Optional.ofNullable(clazz.cast(transmitDisabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AntennaUplinkConfig, T> g) {
        return obj -> g.apply((AntennaUplinkConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AntennaUplinkConfig> {
        /**
         * <p>
         * Information about the uplink spectral <code>Config</code>.
         * </p>
         * 
         * @param spectrumConfig
         *        Information about the uplink spectral <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spectrumConfig(UplinkSpectrumConfig spectrumConfig);

        /**
         * <p>
         * Information about the uplink spectral <code>Config</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link UplinkSpectrumConfig.Builder} avoiding the need
         * to create one manually via {@link UplinkSpectrumConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UplinkSpectrumConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #spectrumConfig(UplinkSpectrumConfig)}.
         * 
         * @param spectrumConfig
         *        a consumer that will call methods on {@link UplinkSpectrumConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spectrumConfig(UplinkSpectrumConfig)
         */
        default Builder spectrumConfig(Consumer<UplinkSpectrumConfig.Builder> spectrumConfig) {
            return spectrumConfig(UplinkSpectrumConfig.builder().applyMutation(spectrumConfig).build());
        }

        /**
         * <p>
         * EIRP of the target.
         * </p>
         * 
         * @param targetEirp
         *        EIRP of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEirp(Eirp targetEirp);

        /**
         * <p>
         * EIRP of the target.
         * </p>
         * This is a convenience that creates an instance of the {@link Eirp.Builder} avoiding the need to create one
         * manually via {@link Eirp#builder()}.
         *
         * When the {@link Consumer} completes, {@link Eirp.Builder#build()} is called immediately and its result is
         * passed to {@link #targetEirp(Eirp)}.
         * 
         * @param targetEirp
         *        a consumer that will call methods on {@link Eirp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetEirp(Eirp)
         */
        default Builder targetEirp(Consumer<Eirp.Builder> targetEirp) {
            return targetEirp(Eirp.builder().applyMutation(targetEirp).build());
        }

        /**
         * <p>
         * Whether or not uplink transmit is disabled.
         * </p>
         * 
         * @param transmitDisabled
         *        Whether or not uplink transmit is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transmitDisabled(Boolean transmitDisabled);
    }

    static final class BuilderImpl implements Builder {
        private UplinkSpectrumConfig spectrumConfig;

        private Eirp targetEirp;

        private Boolean transmitDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaUplinkConfig model) {
            spectrumConfig(model.spectrumConfig);
            targetEirp(model.targetEirp);
            transmitDisabled(model.transmitDisabled);
        }

        public final UplinkSpectrumConfig.Builder getSpectrumConfig() {
            return spectrumConfig != null ? spectrumConfig.toBuilder() : null;
        }

        public final void setSpectrumConfig(UplinkSpectrumConfig.BuilderImpl spectrumConfig) {
            this.spectrumConfig = spectrumConfig != null ? spectrumConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder spectrumConfig(UplinkSpectrumConfig spectrumConfig) {
            this.spectrumConfig = spectrumConfig;
            return this;
        }

        public final Eirp.Builder getTargetEirp() {
            return targetEirp != null ? targetEirp.toBuilder() : null;
        }

        public final void setTargetEirp(Eirp.BuilderImpl targetEirp) {
            this.targetEirp = targetEirp != null ? targetEirp.build() : null;
        }

        @Override
        @Transient
        public final Builder targetEirp(Eirp targetEirp) {
            this.targetEirp = targetEirp;
            return this;
        }

        public final Boolean getTransmitDisabled() {
            return transmitDisabled;
        }

        public final void setTransmitDisabled(Boolean transmitDisabled) {
            this.transmitDisabled = transmitDisabled;
        }

        @Override
        @Transient
        public final Builder transmitDisabled(Boolean transmitDisabled) {
            this.transmitDisabled = transmitDisabled;
            return this;
        }

        @Override
        public AntennaUplinkConfig build() {
            return new AntennaUplinkConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
