/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing the parameters of a <code>Config</code>.
 * </p>
 * <p>
 * See the subtype definitions for what each type of <code>Config</code> contains.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigTypeData implements SdkPojo, Serializable, ToCopyableBuilder<ConfigTypeData.Builder, ConfigTypeData> {
    private static final SdkField<AntennaDownlinkConfig> ANTENNA_DOWNLINK_CONFIG_FIELD = SdkField
            .<AntennaDownlinkConfig> builder(MarshallingType.SDK_POJO).memberName("antennaDownlinkConfig")
            .getter(getter(ConfigTypeData::antennaDownlinkConfig)).setter(setter(Builder::antennaDownlinkConfig))
            .constructor(AntennaDownlinkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDownlinkConfig").build())
            .build();

    private static final SdkField<AntennaDownlinkDemodDecodeConfig> ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG_FIELD = SdkField
            .<AntennaDownlinkDemodDecodeConfig> builder(MarshallingType.SDK_POJO)
            .memberName("antennaDownlinkDemodDecodeConfig")
            .getter(getter(ConfigTypeData::antennaDownlinkDemodDecodeConfig))
            .setter(setter(Builder::antennaDownlinkDemodDecodeConfig))
            .constructor(AntennaDownlinkDemodDecodeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDownlinkDemodDecodeConfig")
                    .build()).build();

    private static final SdkField<AntennaUplinkConfig> ANTENNA_UPLINK_CONFIG_FIELD = SdkField
            .<AntennaUplinkConfig> builder(MarshallingType.SDK_POJO).memberName("antennaUplinkConfig")
            .getter(getter(ConfigTypeData::antennaUplinkConfig)).setter(setter(Builder::antennaUplinkConfig))
            .constructor(AntennaUplinkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaUplinkConfig").build())
            .build();

    private static final SdkField<DataflowEndpointConfig> DATAFLOW_ENDPOINT_CONFIG_FIELD = SdkField
            .<DataflowEndpointConfig> builder(MarshallingType.SDK_POJO).memberName("dataflowEndpointConfig")
            .getter(getter(ConfigTypeData::dataflowEndpointConfig)).setter(setter(Builder::dataflowEndpointConfig))
            .constructor(DataflowEndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointConfig").build())
            .build();

    private static final SdkField<S3RecordingConfig> S3_RECORDING_CONFIG_FIELD = SdkField
            .<S3RecordingConfig> builder(MarshallingType.SDK_POJO).memberName("s3RecordingConfig")
            .getter(getter(ConfigTypeData::s3RecordingConfig)).setter(setter(Builder::s3RecordingConfig))
            .constructor(S3RecordingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3RecordingConfig").build()).build();

    private static final SdkField<TrackingConfig> TRACKING_CONFIG_FIELD = SdkField
            .<TrackingConfig> builder(MarshallingType.SDK_POJO).memberName("trackingConfig")
            .getter(getter(ConfigTypeData::trackingConfig)).setter(setter(Builder::trackingConfig))
            .constructor(TrackingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfig").build()).build();

    private static final SdkField<UplinkEchoConfig> UPLINK_ECHO_CONFIG_FIELD = SdkField
            .<UplinkEchoConfig> builder(MarshallingType.SDK_POJO).memberName("uplinkEchoConfig")
            .getter(getter(ConfigTypeData::uplinkEchoConfig)).setter(setter(Builder::uplinkEchoConfig))
            .constructor(UplinkEchoConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkEchoConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANTENNA_DOWNLINK_CONFIG_FIELD,
            ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG_FIELD, ANTENNA_UPLINK_CONFIG_FIELD, DATAFLOW_ENDPOINT_CONFIG_FIELD,
            S3_RECORDING_CONFIG_FIELD, TRACKING_CONFIG_FIELD, UPLINK_ECHO_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final AntennaDownlinkConfig antennaDownlinkConfig;

    private final AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig;

    private final AntennaUplinkConfig antennaUplinkConfig;

    private final DataflowEndpointConfig dataflowEndpointConfig;

    private final S3RecordingConfig s3RecordingConfig;

    private final TrackingConfig trackingConfig;

    private final UplinkEchoConfig uplinkEchoConfig;

    private ConfigTypeData(BuilderImpl builder) {
        this.antennaDownlinkConfig = builder.antennaDownlinkConfig;
        this.antennaDownlinkDemodDecodeConfig = builder.antennaDownlinkDemodDecodeConfig;
        this.antennaUplinkConfig = builder.antennaUplinkConfig;
        this.dataflowEndpointConfig = builder.dataflowEndpointConfig;
        this.s3RecordingConfig = builder.s3RecordingConfig;
        this.trackingConfig = builder.trackingConfig;
        this.uplinkEchoConfig = builder.uplinkEchoConfig;
    }

    /**
     * <p>
     * Information about how AWS Ground Station should configure an antenna for downlink during a contact.
     * </p>
     * 
     * @return Information about how AWS Ground Station should configure an antenna for downlink during a contact.
     */
    public final AntennaDownlinkConfig antennaDownlinkConfig() {
        return antennaDownlinkConfig;
    }

    /**
     * <p>
     * Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a contact.
     * </p>
     * 
     * @return Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a
     *         contact.
     */
    public final AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig() {
        return antennaDownlinkDemodDecodeConfig;
    }

    /**
     * <p>
     * Information about how AWS Ground Station should conﬁgure an antenna for uplink during a contact.
     * </p>
     * 
     * @return Information about how AWS Ground Station should conﬁgure an antenna for uplink during a contact.
     */
    public final AntennaUplinkConfig antennaUplinkConfig() {
        return antennaUplinkConfig;
    }

    /**
     * <p>
     * Information about the dataflow endpoint <code>Config</code>.
     * </p>
     * 
     * @return Information about the dataflow endpoint <code>Config</code>.
     */
    public final DataflowEndpointConfig dataflowEndpointConfig() {
        return dataflowEndpointConfig;
    }

    /**
     * <p>
     * Information about an S3 recording <code>Config</code>.
     * </p>
     * 
     * @return Information about an S3 recording <code>Config</code>.
     */
    public final S3RecordingConfig s3RecordingConfig() {
        return s3RecordingConfig;
    }

    /**
     * <p>
     * Object that determines whether tracking should be used during a contact executed with this <code>Config</code> in
     * the mission profile.
     * </p>
     * 
     * @return Object that determines whether tracking should be used during a contact executed with this
     *         <code>Config</code> in the mission profile.
     */
    public final TrackingConfig trackingConfig() {
        return trackingConfig;
    }

    /**
     * <p>
     * Information about an uplink echo <code>Config</code>.
     * </p>
     * <p>
     * Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified
     * <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a contact.
     * </p>
     * 
     * @return Information about an uplink echo <code>Config</code>.</p>
     *         <p>
     *         Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified
     *         <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a
     *         contact.
     */
    public final UplinkEchoConfig uplinkEchoConfig() {
        return uplinkEchoConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(antennaDownlinkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(antennaDownlinkDemodDecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(antennaUplinkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(s3RecordingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trackingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkEchoConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigTypeData)) {
            return false;
        }
        ConfigTypeData other = (ConfigTypeData) obj;
        return Objects.equals(antennaDownlinkConfig(), other.antennaDownlinkConfig())
                && Objects.equals(antennaDownlinkDemodDecodeConfig(), other.antennaDownlinkDemodDecodeConfig())
                && Objects.equals(antennaUplinkConfig(), other.antennaUplinkConfig())
                && Objects.equals(dataflowEndpointConfig(), other.dataflowEndpointConfig())
                && Objects.equals(s3RecordingConfig(), other.s3RecordingConfig())
                && Objects.equals(trackingConfig(), other.trackingConfig())
                && Objects.equals(uplinkEchoConfig(), other.uplinkEchoConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigTypeData").add("AntennaDownlinkConfig", antennaDownlinkConfig())
                .add("AntennaDownlinkDemodDecodeConfig", antennaDownlinkDemodDecodeConfig())
                .add("AntennaUplinkConfig", antennaUplinkConfig()).add("DataflowEndpointConfig", dataflowEndpointConfig())
                .add("S3RecordingConfig", s3RecordingConfig()).add("TrackingConfig", trackingConfig())
                .add("UplinkEchoConfig", uplinkEchoConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "antennaDownlinkConfig":
            return Optional.ofNullable(clazz.cast(antennaDownlinkConfig()));
        case "antennaDownlinkDemodDecodeConfig":
            return Optional.ofNullable(clazz.cast(antennaDownlinkDemodDecodeConfig()));
        case "antennaUplinkConfig":
            return Optional.ofNullable(clazz.cast(antennaUplinkConfig()));
        case "dataflowEndpointConfig":
            return Optional.ofNullable(clazz.cast(dataflowEndpointConfig()));
        case "s3RecordingConfig":
            return Optional.ofNullable(clazz.cast(s3RecordingConfig()));
        case "trackingConfig":
            return Optional.ofNullable(clazz.cast(trackingConfig()));
        case "uplinkEchoConfig":
            return Optional.ofNullable(clazz.cast(uplinkEchoConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigTypeData, T> g) {
        return obj -> g.apply((ConfigTypeData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigTypeData> {
        /**
         * <p>
         * Information about how AWS Ground Station should configure an antenna for downlink during a contact.
         * </p>
         * 
         * @param antennaDownlinkConfig
         *        Information about how AWS Ground Station should configure an antenna for downlink during a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antennaDownlinkConfig(AntennaDownlinkConfig antennaDownlinkConfig);

        /**
         * <p>
         * Information about how AWS Ground Station should configure an antenna for downlink during a contact.
         * </p>
         * This is a convenience that creates an instance of the {@link AntennaDownlinkConfig.Builder} avoiding the need
         * to create one manually via {@link AntennaDownlinkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AntennaDownlinkConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #antennaDownlinkConfig(AntennaDownlinkConfig)}.
         * 
         * @param antennaDownlinkConfig
         *        a consumer that will call methods on {@link AntennaDownlinkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antennaDownlinkConfig(AntennaDownlinkConfig)
         */
        default Builder antennaDownlinkConfig(Consumer<AntennaDownlinkConfig.Builder> antennaDownlinkConfig) {
            return antennaDownlinkConfig(AntennaDownlinkConfig.builder().applyMutation(antennaDownlinkConfig).build());
        }

        /**
         * <p>
         * Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a
         * contact.
         * </p>
         * 
         * @param antennaDownlinkDemodDecodeConfig
         *        Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a
         *        contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig);

        /**
         * <p>
         * Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a
         * contact.
         * </p>
         * This is a convenience that creates an instance of the {@link AntennaDownlinkDemodDecodeConfig.Builder}
         * avoiding the need to create one manually via {@link AntennaDownlinkDemodDecodeConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AntennaDownlinkDemodDecodeConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig)}.
         * 
         * @param antennaDownlinkDemodDecodeConfig
         *        a consumer that will call methods on {@link AntennaDownlinkDemodDecodeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig)
         */
        default Builder antennaDownlinkDemodDecodeConfig(
                Consumer<AntennaDownlinkDemodDecodeConfig.Builder> antennaDownlinkDemodDecodeConfig) {
            return antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig.builder()
                    .applyMutation(antennaDownlinkDemodDecodeConfig).build());
        }

        /**
         * <p>
         * Information about how AWS Ground Station should conﬁgure an antenna for uplink during a contact.
         * </p>
         * 
         * @param antennaUplinkConfig
         *        Information about how AWS Ground Station should conﬁgure an antenna for uplink during a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antennaUplinkConfig(AntennaUplinkConfig antennaUplinkConfig);

        /**
         * <p>
         * Information about how AWS Ground Station should conﬁgure an antenna for uplink during a contact.
         * </p>
         * This is a convenience that creates an instance of the {@link AntennaUplinkConfig.Builder} avoiding the need
         * to create one manually via {@link AntennaUplinkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AntennaUplinkConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #antennaUplinkConfig(AntennaUplinkConfig)}.
         * 
         * @param antennaUplinkConfig
         *        a consumer that will call methods on {@link AntennaUplinkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antennaUplinkConfig(AntennaUplinkConfig)
         */
        default Builder antennaUplinkConfig(Consumer<AntennaUplinkConfig.Builder> antennaUplinkConfig) {
            return antennaUplinkConfig(AntennaUplinkConfig.builder().applyMutation(antennaUplinkConfig).build());
        }

        /**
         * <p>
         * Information about the dataflow endpoint <code>Config</code>.
         * </p>
         * 
         * @param dataflowEndpointConfig
         *        Information about the dataflow endpoint <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointConfig(DataflowEndpointConfig dataflowEndpointConfig);

        /**
         * <p>
         * Information about the dataflow endpoint <code>Config</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DataflowEndpointConfig.Builder} avoiding the
         * need to create one manually via {@link DataflowEndpointConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataflowEndpointConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dataflowEndpointConfig(DataflowEndpointConfig)}.
         * 
         * @param dataflowEndpointConfig
         *        a consumer that will call methods on {@link DataflowEndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataflowEndpointConfig(DataflowEndpointConfig)
         */
        default Builder dataflowEndpointConfig(Consumer<DataflowEndpointConfig.Builder> dataflowEndpointConfig) {
            return dataflowEndpointConfig(DataflowEndpointConfig.builder().applyMutation(dataflowEndpointConfig).build());
        }

        /**
         * <p>
         * Information about an S3 recording <code>Config</code>.
         * </p>
         * 
         * @param s3RecordingConfig
         *        Information about an S3 recording <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3RecordingConfig(S3RecordingConfig s3RecordingConfig);

        /**
         * <p>
         * Information about an S3 recording <code>Config</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link S3RecordingConfig.Builder} avoiding the need to
         * create one manually via {@link S3RecordingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3RecordingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3RecordingConfig(S3RecordingConfig)}.
         * 
         * @param s3RecordingConfig
         *        a consumer that will call methods on {@link S3RecordingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3RecordingConfig(S3RecordingConfig)
         */
        default Builder s3RecordingConfig(Consumer<S3RecordingConfig.Builder> s3RecordingConfig) {
            return s3RecordingConfig(S3RecordingConfig.builder().applyMutation(s3RecordingConfig).build());
        }

        /**
         * <p>
         * Object that determines whether tracking should be used during a contact executed with this
         * <code>Config</code> in the mission profile.
         * </p>
         * 
         * @param trackingConfig
         *        Object that determines whether tracking should be used during a contact executed with this
         *        <code>Config</code> in the mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingConfig(TrackingConfig trackingConfig);

        /**
         * <p>
         * Object that determines whether tracking should be used during a contact executed with this
         * <code>Config</code> in the mission profile.
         * </p>
         * This is a convenience that creates an instance of the {@link TrackingConfig.Builder} avoiding the need to
         * create one manually via {@link TrackingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrackingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #trackingConfig(TrackingConfig)}.
         * 
         * @param trackingConfig
         *        a consumer that will call methods on {@link TrackingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trackingConfig(TrackingConfig)
         */
        default Builder trackingConfig(Consumer<TrackingConfig.Builder> trackingConfig) {
            return trackingConfig(TrackingConfig.builder().applyMutation(trackingConfig).build());
        }

        /**
         * <p>
         * Information about an uplink echo <code>Config</code>.
         * </p>
         * <p>
         * Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified
         * <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a contact.
         * </p>
         * 
         * @param uplinkEchoConfig
         *        Information about an uplink echo <code>Config</code>.</p>
         *        <p>
         *        Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified
         *        <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a
         *        contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkEchoConfig(UplinkEchoConfig uplinkEchoConfig);

        /**
         * <p>
         * Information about an uplink echo <code>Config</code>.
         * </p>
         * <p>
         * Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified
         * <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a contact.
         * </p>
         * This is a convenience that creates an instance of the {@link UplinkEchoConfig.Builder} avoiding the need to
         * create one manually via {@link UplinkEchoConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UplinkEchoConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #uplinkEchoConfig(UplinkEchoConfig)}.
         * 
         * @param uplinkEchoConfig
         *        a consumer that will call methods on {@link UplinkEchoConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uplinkEchoConfig(UplinkEchoConfig)
         */
        default Builder uplinkEchoConfig(Consumer<UplinkEchoConfig.Builder> uplinkEchoConfig) {
            return uplinkEchoConfig(UplinkEchoConfig.builder().applyMutation(uplinkEchoConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AntennaDownlinkConfig antennaDownlinkConfig;

        private AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig;

        private AntennaUplinkConfig antennaUplinkConfig;

        private DataflowEndpointConfig dataflowEndpointConfig;

        private S3RecordingConfig s3RecordingConfig;

        private TrackingConfig trackingConfig;

        private UplinkEchoConfig uplinkEchoConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigTypeData model) {
            antennaDownlinkConfig(model.antennaDownlinkConfig);
            antennaDownlinkDemodDecodeConfig(model.antennaDownlinkDemodDecodeConfig);
            antennaUplinkConfig(model.antennaUplinkConfig);
            dataflowEndpointConfig(model.dataflowEndpointConfig);
            s3RecordingConfig(model.s3RecordingConfig);
            trackingConfig(model.trackingConfig);
            uplinkEchoConfig(model.uplinkEchoConfig);
        }

        public final AntennaDownlinkConfig.Builder getAntennaDownlinkConfig() {
            return antennaDownlinkConfig != null ? antennaDownlinkConfig.toBuilder() : null;
        }

        public final void setAntennaDownlinkConfig(AntennaDownlinkConfig.BuilderImpl antennaDownlinkConfig) {
            this.antennaDownlinkConfig = antennaDownlinkConfig != null ? antennaDownlinkConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder antennaDownlinkConfig(AntennaDownlinkConfig antennaDownlinkConfig) {
            this.antennaDownlinkConfig = antennaDownlinkConfig;
            return this;
        }

        public final AntennaDownlinkDemodDecodeConfig.Builder getAntennaDownlinkDemodDecodeConfig() {
            return antennaDownlinkDemodDecodeConfig != null ? antennaDownlinkDemodDecodeConfig.toBuilder() : null;
        }

        public final void setAntennaDownlinkDemodDecodeConfig(
                AntennaDownlinkDemodDecodeConfig.BuilderImpl antennaDownlinkDemodDecodeConfig) {
            this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig != null ? antennaDownlinkDemodDecodeConfig
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig) {
            this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig;
            return this;
        }

        public final AntennaUplinkConfig.Builder getAntennaUplinkConfig() {
            return antennaUplinkConfig != null ? antennaUplinkConfig.toBuilder() : null;
        }

        public final void setAntennaUplinkConfig(AntennaUplinkConfig.BuilderImpl antennaUplinkConfig) {
            this.antennaUplinkConfig = antennaUplinkConfig != null ? antennaUplinkConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder antennaUplinkConfig(AntennaUplinkConfig antennaUplinkConfig) {
            this.antennaUplinkConfig = antennaUplinkConfig;
            return this;
        }

        public final DataflowEndpointConfig.Builder getDataflowEndpointConfig() {
            return dataflowEndpointConfig != null ? dataflowEndpointConfig.toBuilder() : null;
        }

        public final void setDataflowEndpointConfig(DataflowEndpointConfig.BuilderImpl dataflowEndpointConfig) {
            this.dataflowEndpointConfig = dataflowEndpointConfig != null ? dataflowEndpointConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder dataflowEndpointConfig(DataflowEndpointConfig dataflowEndpointConfig) {
            this.dataflowEndpointConfig = dataflowEndpointConfig;
            return this;
        }

        public final S3RecordingConfig.Builder getS3RecordingConfig() {
            return s3RecordingConfig != null ? s3RecordingConfig.toBuilder() : null;
        }

        public final void setS3RecordingConfig(S3RecordingConfig.BuilderImpl s3RecordingConfig) {
            this.s3RecordingConfig = s3RecordingConfig != null ? s3RecordingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder s3RecordingConfig(S3RecordingConfig s3RecordingConfig) {
            this.s3RecordingConfig = s3RecordingConfig;
            return this;
        }

        public final TrackingConfig.Builder getTrackingConfig() {
            return trackingConfig != null ? trackingConfig.toBuilder() : null;
        }

        public final void setTrackingConfig(TrackingConfig.BuilderImpl trackingConfig) {
            this.trackingConfig = trackingConfig != null ? trackingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder trackingConfig(TrackingConfig trackingConfig) {
            this.trackingConfig = trackingConfig;
            return this;
        }

        public final UplinkEchoConfig.Builder getUplinkEchoConfig() {
            return uplinkEchoConfig != null ? uplinkEchoConfig.toBuilder() : null;
        }

        public final void setUplinkEchoConfig(UplinkEchoConfig.BuilderImpl uplinkEchoConfig) {
            this.uplinkEchoConfig = uplinkEchoConfig != null ? uplinkEchoConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder uplinkEchoConfig(UplinkEchoConfig uplinkEchoConfig) {
            this.uplinkEchoConfig = uplinkEchoConfig;
            return this;
        }

        @Override
        public ConfigTypeData build() {
            return new ConfigTypeData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
