/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataflowEndpointGroupResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetDataflowEndpointGroupResponse.Builder, GetDataflowEndpointGroupResponse> {
    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowEndpointGroupArn").getter(getter(GetDataflowEndpointGroupResponse::dataflowEndpointGroupArn))
            .setter(setter(Builder::dataflowEndpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupArn").build())
            .build();

    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowEndpointGroupId").getter(getter(GetDataflowEndpointGroupResponse::dataflowEndpointGroupId))
            .setter(setter(Builder::dataflowEndpointGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupId").build())
            .build();

    private static final SdkField<List<EndpointDetails>> ENDPOINTS_DETAILS_FIELD = SdkField
            .<List<EndpointDetails>> builder(MarshallingType.LIST)
            .memberName("endpointsDetails")
            .getter(getter(GetDataflowEndpointGroupResponse::endpointsDetails))
            .setter(setter(Builder::endpointsDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointsDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetDataflowEndpointGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATAFLOW_ENDPOINT_GROUP_ARN_FIELD, DATAFLOW_ENDPOINT_GROUP_ID_FIELD, ENDPOINTS_DETAILS_FIELD, TAGS_FIELD));

    private final String dataflowEndpointGroupArn;

    private final String dataflowEndpointGroupId;

    private final List<EndpointDetails> endpointsDetails;

    private final Map<String, String> tags;

    private GetDataflowEndpointGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dataflowEndpointGroupArn = builder.dataflowEndpointGroupArn;
        this.dataflowEndpointGroupId = builder.dataflowEndpointGroupId;
        this.endpointsDetails = builder.endpointsDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * ARN of a dataflow endpoint group.
     * </p>
     * 
     * @return ARN of a dataflow endpoint group.
     */
    public final String dataflowEndpointGroupArn() {
        return dataflowEndpointGroupArn;
    }

    /**
     * <p>
     * UUID of a dataflow endpoint group.
     * </p>
     * 
     * @return UUID of a dataflow endpoint group.
     */
    public final String dataflowEndpointGroupId() {
        return dataflowEndpointGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointsDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointsDetails() {
        return endpointsDetails != null && !(endpointsDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of a dataflow endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointsDetails} method.
     * </p>
     * 
     * @return Details of a dataflow endpoint.
     */
    public final List<EndpointDetails> endpointsDetails() {
        return endpointsDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a dataflow endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to a dataflow endpoint group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointsDetails() ? endpointsDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowEndpointGroupResponse)) {
            return false;
        }
        GetDataflowEndpointGroupResponse other = (GetDataflowEndpointGroupResponse) obj;
        return Objects.equals(dataflowEndpointGroupArn(), other.dataflowEndpointGroupArn())
                && Objects.equals(dataflowEndpointGroupId(), other.dataflowEndpointGroupId())
                && hasEndpointsDetails() == other.hasEndpointsDetails()
                && Objects.equals(endpointsDetails(), other.endpointsDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataflowEndpointGroupResponse").add("DataflowEndpointGroupArn", dataflowEndpointGroupArn())
                .add("DataflowEndpointGroupId", dataflowEndpointGroupId())
                .add("EndpointsDetails", hasEndpointsDetails() ? endpointsDetails() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataflowEndpointGroupArn":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupArn()));
        case "dataflowEndpointGroupId":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupId()));
        case "endpointsDetails":
            return Optional.ofNullable(clazz.cast(endpointsDetails()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataflowEndpointGroupResponse, T> g) {
        return obj -> g.apply((GetDataflowEndpointGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataflowEndpointGroupResponse> {
        /**
         * <p>
         * ARN of a dataflow endpoint group.
         * </p>
         * 
         * @param dataflowEndpointGroupArn
         *        ARN of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupArn(String dataflowEndpointGroupArn);

        /**
         * <p>
         * UUID of a dataflow endpoint group.
         * </p>
         * 
         * @param dataflowEndpointGroupId
         *        UUID of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupId(String dataflowEndpointGroupId);

        /**
         * <p>
         * Details of a dataflow endpoint.
         * </p>
         * 
         * @param endpointsDetails
         *        Details of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointsDetails(Collection<EndpointDetails> endpointsDetails);

        /**
         * <p>
         * Details of a dataflow endpoint.
         * </p>
         * 
         * @param endpointsDetails
         *        Details of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointsDetails(EndpointDetails... endpointsDetails);

        /**
         * <p>
         * Details of a dataflow endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndpointDetails>.Builder} avoiding the need
         * to create one manually via {@link List<EndpointDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointDetails>.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointsDetails(List<EndpointDetails>)}.
         * 
         * @param endpointsDetails
         *        a consumer that will call methods on {@link List<EndpointDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointsDetails(List<EndpointDetails>)
         */
        Builder endpointsDetails(Consumer<EndpointDetails.Builder>... endpointsDetails);

        /**
         * <p>
         * Tags assigned to a dataflow endpoint group.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String dataflowEndpointGroupArn;

        private String dataflowEndpointGroupId;

        private List<EndpointDetails> endpointsDetails = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowEndpointGroupResponse model) {
            super(model);
            dataflowEndpointGroupArn(model.dataflowEndpointGroupArn);
            dataflowEndpointGroupId(model.dataflowEndpointGroupId);
            endpointsDetails(model.endpointsDetails);
            tags(model.tags);
        }

        public final String getDataflowEndpointGroupArn() {
            return dataflowEndpointGroupArn;
        }

        public final void setDataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
        }

        @Override
        @Transient
        public final Builder dataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
            return this;
        }

        public final String getDataflowEndpointGroupId() {
            return dataflowEndpointGroupId;
        }

        public final void setDataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
        }

        @Override
        @Transient
        public final Builder dataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
            return this;
        }

        public final List<EndpointDetails.Builder> getEndpointsDetails() {
            List<EndpointDetails.Builder> result = EndpointDetailsListCopier.copyToBuilder(this.endpointsDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointsDetails(Collection<EndpointDetails.BuilderImpl> endpointsDetails) {
            this.endpointsDetails = EndpointDetailsListCopier.copyFromBuilder(endpointsDetails);
        }

        @Override
        @Transient
        public final Builder endpointsDetails(Collection<EndpointDetails> endpointsDetails) {
            this.endpointsDetails = EndpointDetailsListCopier.copy(endpointsDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointsDetails(EndpointDetails... endpointsDetails) {
            endpointsDetails(Arrays.asList(endpointsDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointsDetails(Consumer<EndpointDetails.Builder>... endpointsDetails) {
            endpointsDetails(Stream.of(endpointsDetails).map(c -> EndpointDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetDataflowEndpointGroupResponse build() {
            return new GetDataflowEndpointGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
