/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMissionProfilesResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListMissionProfilesResponse.Builder, ListMissionProfilesResponse> {
    private static final SdkField<List<MissionProfileListItem>> MISSION_PROFILE_LIST_FIELD = SdkField
            .<List<MissionProfileListItem>> builder(MarshallingType.LIST)
            .memberName("missionProfileList")
            .getter(getter(ListMissionProfilesResponse::missionProfileList))
            .setter(setter(Builder::missionProfileList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MissionProfileListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MissionProfileListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMissionProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MISSION_PROFILE_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MissionProfileListItem> missionProfileList;

    private final String nextToken;

    private ListMissionProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.missionProfileList = builder.missionProfileList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MissionProfileList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMissionProfileList() {
        return missionProfileList != null && !(missionProfileList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of mission profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMissionProfileList} method.
     * </p>
     * 
     * @return List of mission profiles.
     */
    public final List<MissionProfileListItem> missionProfileList() {
        return missionProfileList;
    }

    /**
     * <p>
     * Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the next
     * page of results.
     * </p>
     * 
     * @return Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the
     *         next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMissionProfileList() ? missionProfileList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMissionProfilesResponse)) {
            return false;
        }
        ListMissionProfilesResponse other = (ListMissionProfilesResponse) obj;
        return hasMissionProfileList() == other.hasMissionProfileList()
                && Objects.equals(missionProfileList(), other.missionProfileList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMissionProfilesResponse")
                .add("MissionProfileList", hasMissionProfileList() ? missionProfileList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "missionProfileList":
            return Optional.ofNullable(clazz.cast(missionProfileList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMissionProfilesResponse, T> g) {
        return obj -> g.apply((ListMissionProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMissionProfilesResponse> {
        /**
         * <p>
         * List of mission profiles.
         * </p>
         * 
         * @param missionProfileList
         *        List of mission profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileList(Collection<MissionProfileListItem> missionProfileList);

        /**
         * <p>
         * List of mission profiles.
         * </p>
         * 
         * @param missionProfileList
         *        List of mission profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileList(MissionProfileListItem... missionProfileList);

        /**
         * <p>
         * List of mission profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MissionProfileListItem>.Builder} avoiding
         * the need to create one manually via {@link List<MissionProfileListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MissionProfileListItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #missionProfileList(List<MissionProfileListItem>)}.
         * 
         * @param missionProfileList
         *        a consumer that will call methods on {@link List<MissionProfileListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missionProfileList(List<MissionProfileListItem>)
         */
        Builder missionProfileList(Consumer<MissionProfileListItem.Builder>... missionProfileList);

        /**
         * <p>
         * Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the next
         * page of results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get
         *        the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private List<MissionProfileListItem> missionProfileList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMissionProfilesResponse model) {
            super(model);
            missionProfileList(model.missionProfileList);
            nextToken(model.nextToken);
        }

        public final List<MissionProfileListItem.Builder> getMissionProfileList() {
            List<MissionProfileListItem.Builder> result = MissionProfileListCopier.copyToBuilder(this.missionProfileList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMissionProfileList(Collection<MissionProfileListItem.BuilderImpl> missionProfileList) {
            this.missionProfileList = MissionProfileListCopier.copyFromBuilder(missionProfileList);
        }

        @Override
        @Transient
        public final Builder missionProfileList(Collection<MissionProfileListItem> missionProfileList) {
            this.missionProfileList = MissionProfileListCopier.copy(missionProfileList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder missionProfileList(MissionProfileListItem... missionProfileList) {
            missionProfileList(Arrays.asList(missionProfileList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder missionProfileList(Consumer<MissionProfileListItem.Builder>... missionProfileList) {
            missionProfileList(Stream.of(missionProfileList).map(c -> MissionProfileListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMissionProfilesResponse build() {
            return new ListMissionProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
