/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an S3 recording <code>Config</code> used in a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3RecordingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<S3RecordingDetails.Builder, S3RecordingDetails> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketArn").getter(getter(S3RecordingDetails::bucketArn)).setter(setter(Builder::bucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()).build();

    private static final SdkField<String> KEY_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyTemplate").getter(getter(S3RecordingDetails::keyTemplate)).setter(setter(Builder::keyTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            KEY_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketArn;

    private final String keyTemplate;

    private S3RecordingDetails(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.keyTemplate = builder.keyTemplate;
    }

    /**
     * <p>
     * ARN of the bucket used.
     * </p>
     * 
     * @return ARN of the bucket used.
     */
    public final String bucketArn() {
        return bucketArn;
    }

    /**
     * <p>
     * Template of the S3 key used.
     * </p>
     * 
     * @return Template of the S3 key used.
     */
    public final String keyTemplate() {
        return keyTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3RecordingDetails)) {
            return false;
        }
        S3RecordingDetails other = (S3RecordingDetails) obj;
        return Objects.equals(bucketArn(), other.bucketArn()) && Objects.equals(keyTemplate(), other.keyTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3RecordingDetails").add("BucketArn", bucketArn()).add("KeyTemplate", keyTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketArn":
            return Optional.ofNullable(clazz.cast(bucketArn()));
        case "keyTemplate":
            return Optional.ofNullable(clazz.cast(keyTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3RecordingDetails, T> g) {
        return obj -> g.apply((S3RecordingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3RecordingDetails> {
        /**
         * <p>
         * ARN of the bucket used.
         * </p>
         * 
         * @param bucketArn
         *        ARN of the bucket used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketArn(String bucketArn);

        /**
         * <p>
         * Template of the S3 key used.
         * </p>
         * 
         * @param keyTemplate
         *        Template of the S3 key used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyTemplate(String keyTemplate);
    }

    static final class BuilderImpl implements Builder {
        private String bucketArn;

        private String keyTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3RecordingDetails model) {
            bucketArn(model.bucketArn);
            keyTemplate(model.keyTemplate);
        }

        public final String getBucketArn() {
            return bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        @Transient
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final String getKeyTemplate() {
            return keyTemplate;
        }

        public final void setKeyTemplate(String keyTemplate) {
            this.keyTemplate = keyTemplate;
        }

        @Override
        @Transient
        public final Builder keyTemplate(String keyTemplate) {
            this.keyTemplate = keyTemplate;
            return this;
        }

        @Override
        public S3RecordingDetails build() {
            return new S3RecordingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
