/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigCapabilityType {
    ANTENNA_DOWNLINK("antenna-downlink"),
    ANTENNA_DOWNLINK_DEMOD_DECODE("antenna-downlink-demod-decode"),
    ANTENNA_UPLINK("antenna-uplink"),
    DATAFLOW_ENDPOINT("dataflow-endpoint"),
    TRACKING("tracking"),
    UPLINK_ECHO("uplink-echo"),
    S3_RECORDING("s3-recording"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigCapabilityType> VALUE_MAP;
    private final String value;

    private ConfigCapabilityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigCapabilityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigCapabilityType> knownValues() {
        EnumSet<ConfigCapabilityType> knownValues = EnumSet.allOf(ConfigCapabilityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigCapabilityType.class, ConfigCapabilityType::toString);
    }
}

