/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Two-line element set (TLE) data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TLEData implements SdkPojo, Serializable, ToCopyableBuilder<TLEData.Builder, TLEData> {
    private static final SdkField<String> TLE_LINE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tleLine1").getter(getter(TLEData::tleLine1)).setter(setter(Builder::tleLine1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tleLine1").build()).build();

    private static final SdkField<String> TLE_LINE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tleLine2").getter(getter(TLEData::tleLine2)).setter(setter(Builder::tleLine2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tleLine2").build()).build();

    private static final SdkField<TimeRange> VALID_TIME_RANGE_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("validTimeRange").getter(getter(TLEData::validTimeRange)).setter(setter(Builder::validTimeRange))
            .constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validTimeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLE_LINE1_FIELD,
            TLE_LINE2_FIELD, VALID_TIME_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tleLine1;

    private final String tleLine2;

    private final TimeRange validTimeRange;

    private TLEData(BuilderImpl builder) {
        this.tleLine1 = builder.tleLine1;
        this.tleLine2 = builder.tleLine2;
        this.validTimeRange = builder.validTimeRange;
    }

    /**
     * <p>
     * First line of two-line element set (TLE) data.
     * </p>
     * 
     * @return First line of two-line element set (TLE) data.
     */
    public final String tleLine1() {
        return tleLine1;
    }

    /**
     * <p>
     * Second line of two-line element set (TLE) data.
     * </p>
     * 
     * @return Second line of two-line element set (TLE) data.
     */
    public final String tleLine2() {
        return tleLine2;
    }

    /**
     * <p>
     * The valid time range for the TLE. Gaps or overlap are not permitted.
     * </p>
     * 
     * @return The valid time range for the TLE. Gaps or overlap are not permitted.
     */
    public final TimeRange validTimeRange() {
        return validTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tleLine1());
        hashCode = 31 * hashCode + Objects.hashCode(tleLine2());
        hashCode = 31 * hashCode + Objects.hashCode(validTimeRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLEData)) {
            return false;
        }
        TLEData other = (TLEData) obj;
        return Objects.equals(tleLine1(), other.tleLine1()) && Objects.equals(tleLine2(), other.tleLine2())
                && Objects.equals(validTimeRange(), other.validTimeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TLEData").add("TleLine1", tleLine1()).add("TleLine2", tleLine2())
                .add("ValidTimeRange", validTimeRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tleLine1":
            return Optional.ofNullable(clazz.cast(tleLine1()));
        case "tleLine2":
            return Optional.ofNullable(clazz.cast(tleLine2()));
        case "validTimeRange":
            return Optional.ofNullable(clazz.cast(validTimeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TLEData, T> g) {
        return obj -> g.apply((TLEData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TLEData> {
        /**
         * <p>
         * First line of two-line element set (TLE) data.
         * </p>
         * 
         * @param tleLine1
         *        First line of two-line element set (TLE) data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tleLine1(String tleLine1);

        /**
         * <p>
         * Second line of two-line element set (TLE) data.
         * </p>
         * 
         * @param tleLine2
         *        Second line of two-line element set (TLE) data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tleLine2(String tleLine2);

        /**
         * <p>
         * The valid time range for the TLE. Gaps or overlap are not permitted.
         * </p>
         * 
         * @param validTimeRange
         *        The valid time range for the TLE. Gaps or overlap are not permitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validTimeRange(TimeRange validTimeRange);

        /**
         * <p>
         * The valid time range for the TLE. Gaps or overlap are not permitted.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRange.Builder} avoiding the need to
         * create one manually via {@link TimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #validTimeRange(TimeRange)}.
         * 
         * @param validTimeRange
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validTimeRange(TimeRange)
         */
        default Builder validTimeRange(Consumer<TimeRange.Builder> validTimeRange) {
            return validTimeRange(TimeRange.builder().applyMutation(validTimeRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String tleLine1;

        private String tleLine2;

        private TimeRange validTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(TLEData model) {
            tleLine1(model.tleLine1);
            tleLine2(model.tleLine2);
            validTimeRange(model.validTimeRange);
        }

        public final String getTleLine1() {
            return tleLine1;
        }

        public final void setTleLine1(String tleLine1) {
            this.tleLine1 = tleLine1;
        }

        @Override
        public final Builder tleLine1(String tleLine1) {
            this.tleLine1 = tleLine1;
            return this;
        }

        public final String getTleLine2() {
            return tleLine2;
        }

        public final void setTleLine2(String tleLine2) {
            this.tleLine2 = tleLine2;
        }

        @Override
        public final Builder tleLine2(String tleLine2) {
            this.tleLine2 = tleLine2;
            return this;
        }

        public final TimeRange.Builder getValidTimeRange() {
            return validTimeRange != null ? validTimeRange.toBuilder() : null;
        }

        public final void setValidTimeRange(TimeRange.BuilderImpl validTimeRange) {
            this.validTimeRange = validTimeRange != null ? validTimeRange.build() : null;
        }

        @Override
        public final Builder validTimeRange(TimeRange validTimeRange) {
            this.validTimeRange = validTimeRange;
            return this;
        }

        @Override
        public TLEData build() {
            return new TLEData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
