/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.GroundStationServiceClientConfiguration;
import software.amazon.awssdk.services.groundstation.internal.GroundStationServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.groundstation.model.CancelContactRequest;
import software.amazon.awssdk.services.groundstation.model.CancelContactResponse;
import software.amazon.awssdk.services.groundstation.model.CreateConfigRequest;
import software.amazon.awssdk.services.groundstation.model.CreateConfigResponse;
import software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteConfigRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.DependencyException;
import software.amazon.awssdk.services.groundstation.model.DescribeContactRequest;
import software.amazon.awssdk.services.groundstation.model.DescribeContactResponse;
import software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest;
import software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse;
import software.amazon.awssdk.services.groundstation.model.GetConfigRequest;
import software.amazon.awssdk.services.groundstation.model.GetConfigResponse;
import software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest;
import software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse;
import software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest;
import software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse;
import software.amazon.awssdk.services.groundstation.model.GroundStationException;
import software.amazon.awssdk.services.groundstation.model.InvalidParameterException;
import software.amazon.awssdk.services.groundstation.model.ListConfigsRequest;
import software.amazon.awssdk.services.groundstation.model.ListConfigsResponse;
import software.amazon.awssdk.services.groundstation.model.ListContactsRequest;
import software.amazon.awssdk.services.groundstation.model.ListContactsResponse;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse;
import software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.groundstation.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest;
import software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse;
import software.amazon.awssdk.services.groundstation.model.ReserveContactRequest;
import software.amazon.awssdk.services.groundstation.model.ReserveContactResponse;
import software.amazon.awssdk.services.groundstation.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.groundstation.model.ResourceNotFoundException;
import software.amazon.awssdk.services.groundstation.model.TagResourceRequest;
import software.amazon.awssdk.services.groundstation.model.TagResourceResponse;
import software.amazon.awssdk.services.groundstation.model.UntagResourceRequest;
import software.amazon.awssdk.services.groundstation.model.UntagResourceResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.transform.CancelContactRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.CreateConfigRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.CreateDataflowEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.CreateEphemerisRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.CreateMissionProfileRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.DeleteConfigRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.DeleteDataflowEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.DeleteEphemerisRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.DeleteMissionProfileRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.DescribeContactRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.DescribeEphemerisRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.GetAgentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.GetConfigRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.GetDataflowEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.GetMinuteUsageRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.GetMissionProfileRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.GetSatelliteRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListConfigsRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListContactsRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListDataflowEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListEphemeridesRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListGroundStationsRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListMissionProfilesRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListSatellitesRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.RegisterAgentRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.ReserveContactRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.UpdateAgentStatusRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.UpdateConfigRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.UpdateEphemerisRequestMarshaller;
import software.amazon.awssdk.services.groundstation.transform.UpdateMissionProfileRequestMarshaller;
import software.amazon.awssdk.services.groundstation.waiters.GroundStationWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultGroundStationClient
implements GroundStationClient {
    private static final Logger log = Logger.loggerFor(DefaultGroundStationClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final GroundStationServiceClientConfiguration serviceClientConfiguration;

    protected DefaultGroundStationClient(GroundStationServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelContactResponse cancelContact(CancelContactRequest cancelContactRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelContactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, cancelContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelContact");
            CancelContactResponse cancelContactResponse = (CancelContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$cancelContact$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigResponse createConfig(CreateConfigRequest createConfigRequest) throws InvalidParameterException, DependencyException, ResourceLimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, createConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfig");
            CreateConfigResponse createConfigResponse = (CreateConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$createConfig$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataflowEndpointGroupResponse createDataflowEndpointGroup(CreateDataflowEndpointGroupRequest createDataflowEndpointGroupRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataflowEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataflowEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, createDataflowEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataflowEndpointGroup");
            CreateDataflowEndpointGroupResponse createDataflowEndpointGroupResponse = (CreateDataflowEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataflowEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataflowEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataflowEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataflowEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$createDataflowEndpointGroup$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEphemerisResponse createEphemeris(CreateEphemerisRequest createEphemerisRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEphemerisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEphemerisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, createEphemerisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEphemeris");
            CreateEphemerisResponse createEphemerisResponse = (CreateEphemerisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEphemeris").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEphemerisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEphemerisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEphemerisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$createEphemeris$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMissionProfileResponse createMissionProfile(CreateMissionProfileRequest createMissionProfileRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMissionProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMissionProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, createMissionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMissionProfile");
            CreateMissionProfileResponse createMissionProfileResponse = (CreateMissionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMissionProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMissionProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMissionProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMissionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$createMissionProfile$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigResponse deleteConfig(DeleteConfigRequest deleteConfigRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, deleteConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfig");
            DeleteConfigResponse deleteConfigResponse = (DeleteConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$deleteConfig$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataflowEndpointGroupResponse deleteDataflowEndpointGroup(DeleteDataflowEndpointGroupRequest deleteDataflowEndpointGroupRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataflowEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataflowEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, deleteDataflowEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataflowEndpointGroup");
            DeleteDataflowEndpointGroupResponse deleteDataflowEndpointGroupResponse = (DeleteDataflowEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataflowEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDataflowEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataflowEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataflowEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$deleteDataflowEndpointGroup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEphemerisResponse deleteEphemeris(DeleteEphemerisRequest deleteEphemerisRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEphemerisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEphemerisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, deleteEphemerisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEphemeris");
            DeleteEphemerisResponse deleteEphemerisResponse = (DeleteEphemerisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEphemeris").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEphemerisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEphemerisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEphemerisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$deleteEphemeris$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMissionProfileResponse deleteMissionProfile(DeleteMissionProfileRequest deleteMissionProfileRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMissionProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMissionProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, deleteMissionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMissionProfile");
            DeleteMissionProfileResponse deleteMissionProfileResponse = (DeleteMissionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMissionProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMissionProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMissionProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMissionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$deleteMissionProfile$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContactResponse describeContact(DescribeContactRequest describeContactRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, describeContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContact");
            DescribeContactResponse describeContactResponse = (DescribeContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$describeContact$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEphemerisResponse describeEphemeris(DescribeEphemerisRequest describeEphemerisRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEphemerisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEphemerisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, describeEphemerisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEphemeris");
            DescribeEphemerisResponse describeEphemerisResponse = (DescribeEphemerisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEphemeris").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEphemerisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEphemerisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEphemerisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$describeEphemeris$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAgentConfigurationResponse getAgentConfiguration(GetAgentConfigurationRequest getAgentConfigurationRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAgentConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAgentConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, getAgentConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAgentConfiguration");
            GetAgentConfigurationResponse getAgentConfigurationResponse = (GetAgentConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAgentConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAgentConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAgentConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAgentConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$getAgentConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigResponse getConfig(GetConfigRequest getConfigRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, getConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfig");
            GetConfigResponse getConfigResponse = (GetConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$getConfig$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataflowEndpointGroupResponse getDataflowEndpointGroup(GetDataflowEndpointGroupRequest getDataflowEndpointGroupRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataflowEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataflowEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, getDataflowEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataflowEndpointGroup");
            GetDataflowEndpointGroupResponse getDataflowEndpointGroupResponse = (GetDataflowEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataflowEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDataflowEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataflowEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataflowEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$getDataflowEndpointGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMinuteUsageResponse getMinuteUsage(GetMinuteUsageRequest getMinuteUsageRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMinuteUsageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMinuteUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, getMinuteUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMinuteUsage");
            GetMinuteUsageResponse getMinuteUsageResponse = (GetMinuteUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMinuteUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMinuteUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMinuteUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMinuteUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$getMinuteUsage$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMissionProfileResponse getMissionProfile(GetMissionProfileRequest getMissionProfileRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMissionProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMissionProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, getMissionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMissionProfile");
            GetMissionProfileResponse getMissionProfileResponse = (GetMissionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMissionProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMissionProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMissionProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMissionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$getMissionProfile$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSatelliteResponse getSatellite(GetSatelliteRequest getSatelliteRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSatelliteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSatelliteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, getSatelliteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSatellite");
            GetSatelliteResponse getSatelliteResponse = (GetSatelliteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSatellite").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSatelliteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSatelliteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSatelliteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$getSatellite$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigsResponse listConfigs(ListConfigsRequest listConfigsRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConfigsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigs");
            ListConfigsResponse listConfigsResponse = (ListConfigsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConfigsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConfigsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConfigsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listConfigs$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContactsResponse listContacts(ListContactsRequest listContactsRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContactsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listContactsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listContactsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContacts");
            ListContactsResponse listContactsResponse = (ListContactsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContacts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listContactsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListContactsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listContactsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listContacts$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataflowEndpointGroupsResponse listDataflowEndpointGroups(ListDataflowEndpointGroupsRequest listDataflowEndpointGroupsRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataflowEndpointGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDataflowEndpointGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listDataflowEndpointGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataflowEndpointGroups");
            ListDataflowEndpointGroupsResponse listDataflowEndpointGroupsResponse = (ListDataflowEndpointGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataflowEndpointGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDataflowEndpointGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataflowEndpointGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataflowEndpointGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listDataflowEndpointGroups$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEphemeridesResponse listEphemerides(ListEphemeridesRequest listEphemeridesRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEphemeridesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEphemeridesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listEphemeridesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEphemerides");
            ListEphemeridesResponse listEphemeridesResponse = (ListEphemeridesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEphemerides").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEphemeridesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEphemeridesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEphemeridesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listEphemerides$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGroundStationsResponse listGroundStations(ListGroundStationsRequest listGroundStationsRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGroundStationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGroundStationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listGroundStationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGroundStations");
            ListGroundStationsResponse listGroundStationsResponse = (ListGroundStationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGroundStations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGroundStationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGroundStationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGroundStationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listGroundStations$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMissionProfilesResponse listMissionProfiles(ListMissionProfilesRequest listMissionProfilesRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMissionProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMissionProfilesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listMissionProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMissionProfiles");
            ListMissionProfilesResponse listMissionProfilesResponse = (ListMissionProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMissionProfiles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMissionProfilesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMissionProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMissionProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listMissionProfiles$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSatellitesResponse listSatellites(ListSatellitesRequest listSatellitesRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSatellitesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSatellitesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listSatellitesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSatellites");
            ListSatellitesResponse listSatellitesResponse = (ListSatellitesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSatellites").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSatellitesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSatellitesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSatellitesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listSatellites$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$listTagsForResource$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterAgentResponse registerAgent(RegisterAgentRequest registerAgentRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterAgentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, registerAgentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterAgent");
            RegisterAgentResponse registerAgentResponse = (RegisterAgentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterAgent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerAgentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerAgentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$registerAgent$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReserveContactResponse reserveContact(ReserveContactRequest reserveContactRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReserveContactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)reserveContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, reserveContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReserveContact");
            ReserveContactResponse reserveContactResponse = (ReserveContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReserveContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)reserveContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReserveContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return reserveContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$reserveContact$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$tagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAgentStatusResponse updateAgentStatus(UpdateAgentStatusRequest updateAgentStatusRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAgentStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAgentStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, updateAgentStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAgentStatus");
            UpdateAgentStatusResponse updateAgentStatusResponse = (UpdateAgentStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAgentStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAgentStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAgentStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAgentStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$updateAgentStatus$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigResponse updateConfig(UpdateConfigRequest updateConfigRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, updateConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfig");
            UpdateConfigResponse updateConfigResponse = (UpdateConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$updateConfig$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEphemerisResponse updateEphemeris(UpdateEphemerisRequest updateEphemerisRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEphemerisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEphemerisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, updateEphemerisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEphemeris");
            UpdateEphemerisResponse updateEphemerisResponse = (UpdateEphemerisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEphemeris").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateEphemerisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEphemerisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEphemerisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$updateEphemeris$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMissionProfileResponse updateMissionProfile(UpdateMissionProfileRequest updateMissionProfileRequest) throws InvalidParameterException, DependencyException, ResourceNotFoundException, AwsServiceException, SdkClientException, GroundStationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMissionProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMissionProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGroundStationClient.resolveMetricPublishers(clientConfiguration, updateMissionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"GroundStation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMissionProfile");
            UpdateMissionProfileResponse updateMissionProfileResponse = (UpdateMissionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMissionProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateMissionProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMissionProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMissionProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGroundStationClient.lambda$updateMissionProfile$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GroundStationWaiter waiter() {
        return GroundStationWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "groundstation";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        GroundStationServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = GroundStationServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GroundStationException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(431)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(434)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyException").exceptionBuilderSupplier(DependencyException::builder).httpStatusCode(Integer.valueOf(531)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    @Override
    public final GroundStationServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateMissionProfile$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEphemeris$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfig$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAgentStatus$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$reserveContact$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerAgent$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSatellites$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMissionProfiles$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGroundStations$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEphemerides$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataflowEndpointGroups$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContacts$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfigs$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSatellite$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMissionProfile$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMinuteUsage$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataflowEndpointGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfig$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAgentConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEphemeris$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContact$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMissionProfile$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEphemeris$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataflowEndpointGroup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfig$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMissionProfile$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEphemeris$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataflowEndpointGroup$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfig$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelContact$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

