/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EphemerisTypeDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<EphemerisTypeDescription.Builder, EphemerisTypeDescription> {
    private static final SdkField<EphemerisDescription> OEM_FIELD = SdkField
            .<EphemerisDescription> builder(MarshallingType.SDK_POJO).memberName("oem")
            .getter(getter(EphemerisTypeDescription::oem)).setter(setter(Builder::oem))
            .constructor(EphemerisDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oem").build()).build();

    private static final SdkField<EphemerisDescription> TLE_FIELD = SdkField
            .<EphemerisDescription> builder(MarshallingType.SDK_POJO).memberName("tle")
            .getter(getter(EphemerisTypeDescription::tle)).setter(setter(Builder::tle))
            .constructor(EphemerisDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OEM_FIELD, TLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final EphemerisDescription oem;

    private final EphemerisDescription tle;

    private final Type type;

    private EphemerisTypeDescription(BuilderImpl builder) {
        this.oem = builder.oem;
        this.tle = builder.tle;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Oem property for this object.
     * 
     * @return The value of the Oem property for this object.
     */
    public final EphemerisDescription oem() {
        return oem;
    }

    /**
     * Returns the value of the Tle property for this object.
     * 
     * @return The value of the Tle property for this object.
     */
    public final EphemerisDescription tle() {
        return tle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oem());
        hashCode = 31 * hashCode + Objects.hashCode(tle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisTypeDescription)) {
            return false;
        }
        EphemerisTypeDescription other = (EphemerisTypeDescription) obj;
        return Objects.equals(oem(), other.oem()) && Objects.equals(tle(), other.tle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EphemerisTypeDescription").add("Oem", oem()).add("Tle", tle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oem":
            return Optional.ofNullable(clazz.cast(oem()));
        case "tle":
            return Optional.ofNullable(clazz.cast(tle()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #oem()} initialized to the given value.
     *
     * Sets the value of the Oem property for this object.
     *
     * @param oem
     *        The new value for the Oem property for this object.
     */
    public static EphemerisTypeDescription fromOem(EphemerisDescription oem) {
        return builder().oem(oem).build();
    }

    /**
     * Create an instance of this class with {@link #oem()} initialized to the given value.
     *
     * Sets the value of the Oem property for this object.
     *
     * @param oem
     *        The new value for the Oem property for this object.
     */
    public static EphemerisTypeDescription fromOem(Consumer<EphemerisDescription.Builder> oem) {
        EphemerisDescription.Builder builder = EphemerisDescription.builder();
        oem.accept(builder);
        return fromOem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tle()} initialized to the given value.
     *
     * Sets the value of the Tle property for this object.
     *
     * @param tle
     *        The new value for the Tle property for this object.
     */
    public static EphemerisTypeDescription fromTle(EphemerisDescription tle) {
        return builder().tle(tle).build();
    }

    /**
     * Create an instance of this class with {@link #tle()} initialized to the given value.
     *
     * Sets the value of the Tle property for this object.
     *
     * @param tle
     *        The new value for the Tle property for this object.
     */
    public static EphemerisTypeDescription fromTle(Consumer<EphemerisDescription.Builder> tle) {
        EphemerisDescription.Builder builder = EphemerisDescription.builder();
        tle.accept(builder);
        return fromTle(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EphemerisTypeDescription, T> g) {
        return obj -> g.apply((EphemerisTypeDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EphemerisTypeDescription> {
        /**
         * Sets the value of the Oem property for this object.
         *
         * @param oem
         *        The new value for the Oem property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oem(EphemerisDescription oem);

        /**
         * Sets the value of the Oem property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EphemerisDescription.Builder} avoiding
         * the need to create one manually via {@link EphemerisDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EphemerisDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #oem(EphemerisDescription)}.
         * 
         * @param oem
         *        a consumer that will call methods on {@link EphemerisDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oem(EphemerisDescription)
         */
        default Builder oem(Consumer<EphemerisDescription.Builder> oem) {
            return oem(EphemerisDescription.builder().applyMutation(oem).build());
        }

        /**
         * Sets the value of the Tle property for this object.
         *
         * @param tle
         *        The new value for the Tle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tle(EphemerisDescription tle);

        /**
         * Sets the value of the Tle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EphemerisDescription.Builder} avoiding
         * the need to create one manually via {@link EphemerisDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EphemerisDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #tle(EphemerisDescription)}.
         * 
         * @param tle
         *        a consumer that will call methods on {@link EphemerisDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tle(EphemerisDescription)
         */
        default Builder tle(Consumer<EphemerisDescription.Builder> tle) {
            return tle(EphemerisDescription.builder().applyMutation(tle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EphemerisDescription oem;

        private EphemerisDescription tle;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisTypeDescription model) {
            oem(model.oem);
            tle(model.tle);
        }

        public final EphemerisDescription.Builder getOem() {
            return oem != null ? oem.toBuilder() : null;
        }

        public final void setOem(EphemerisDescription.BuilderImpl oem) {
            Object oldValue = this.oem;
            this.oem = oem != null ? oem.build() : null;
            handleUnionValueChange(Type.OEM, oldValue, this.oem);
        }

        @Override
        public final Builder oem(EphemerisDescription oem) {
            Object oldValue = this.oem;
            this.oem = oem;
            handleUnionValueChange(Type.OEM, oldValue, this.oem);
            return this;
        }

        public final EphemerisDescription.Builder getTle() {
            return tle != null ? tle.toBuilder() : null;
        }

        public final void setTle(EphemerisDescription.BuilderImpl tle) {
            Object oldValue = this.tle;
            this.tle = tle != null ? tle.build() : null;
            handleUnionValueChange(Type.TLE, oldValue, this.tle);
        }

        @Override
        public final Builder tle(EphemerisDescription tle) {
            Object oldValue = this.tle;
            this.tle = tle;
            handleUnionValueChange(Type.TLE, oldValue, this.tle);
            return this;
        }

        @Override
        public EphemerisTypeDescription build() {
            return new EphemerisTypeDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EphemerisTypeDescription#type()
     */
    public enum Type {
        OEM,

        TLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
