/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an antenna demod decode <code>Config</code> used in a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AntennaDemodDecodeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AntennaDemodDecodeDetails.Builder, AntennaDemodDecodeDetails> {
    private static final SdkField<String> OUTPUT_NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputNode").getter(getter(AntennaDemodDecodeDetails::outputNode)).setter(setter(Builder::outputNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputNode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_NODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputNode;

    private AntennaDemodDecodeDetails(BuilderImpl builder) {
        this.outputNode = builder.outputNode;
    }

    /**
     * <p>
     * Name of an antenna demod decode output node used in a contact.
     * </p>
     * 
     * @return Name of an antenna demod decode output node used in a contact.
     */
    public final String outputNode() {
        return outputNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputNode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaDemodDecodeDetails)) {
            return false;
        }
        AntennaDemodDecodeDetails other = (AntennaDemodDecodeDetails) obj;
        return Objects.equals(outputNode(), other.outputNode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AntennaDemodDecodeDetails").add("OutputNode", outputNode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputNode":
            return Optional.ofNullable(clazz.cast(outputNode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AntennaDemodDecodeDetails, T> g) {
        return obj -> g.apply((AntennaDemodDecodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AntennaDemodDecodeDetails> {
        /**
         * <p>
         * Name of an antenna demod decode output node used in a contact.
         * </p>
         * 
         * @param outputNode
         *        Name of an antenna demod decode output node used in a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputNode(String outputNode);
    }

    static final class BuilderImpl implements Builder {
        private String outputNode;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaDemodDecodeDetails model) {
            outputNode(model.outputNode);
        }

        public final String getOutputNode() {
            return outputNode;
        }

        public final void setOutputNode(String outputNode) {
            this.outputNode = outputNode;
        }

        @Override
        public final Builder outputNode(String outputNode) {
            this.outputNode = outputNode;
            return this;
        }

        @Override
        public AntennaDemodDecodeDetails build() {
            return new AntennaDemodDecodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
