/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigRequest extends GroundStationRequest implements
        ToCopyableBuilder<UpdateConfigRequest.Builder, UpdateConfigRequest> {
    private static final SdkField<ConfigTypeData> CONFIG_DATA_FIELD = SdkField.<ConfigTypeData> builder(MarshallingType.SDK_POJO)
            .memberName("configData").getter(getter(UpdateConfigRequest::configData)).setter(setter(Builder::configData))
            .constructor(ConfigTypeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configData").build()).build();

    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configId").getter(getter(UpdateConfigRequest::configId)).setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configId").build()).build();

    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configType").getter(getter(UpdateConfigRequest::configTypeAsString)).setter(setter(Builder::configType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateConfigRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_DATA_FIELD,
            CONFIG_ID_FIELD, CONFIG_TYPE_FIELD, NAME_FIELD));

    private final ConfigTypeData configData;

    private final String configId;

    private final String configType;

    private final String name;

    private UpdateConfigRequest(BuilderImpl builder) {
        super(builder);
        this.configData = builder.configData;
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.name = builder.name;
    }

    /**
     * <p>
     * Parameters of a <code>Config</code>.
     * </p>
     * 
     * @return Parameters of a <code>Config</code>.
     */
    public final ConfigTypeData configData() {
        return configData;
    }

    /**
     * <p>
     * UUID of a <code>Config</code>.
     * </p>
     * 
     * @return UUID of a <code>Config</code>.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(configType);
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final String configTypeAsString() {
        return configType;
    }

    /**
     * <p>
     * Name of a <code>Config</code>.
     * </p>
     * 
     * @return Name of a <code>Config</code>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configData());
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigRequest)) {
            return false;
        }
        UpdateConfigRequest other = (UpdateConfigRequest) obj;
        return Objects.equals(configData(), other.configData()) && Objects.equals(configId(), other.configId())
                && Objects.equals(configTypeAsString(), other.configTypeAsString()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigRequest").add("ConfigData", configData()).add("ConfigId", configId())
                .add("ConfigType", configTypeAsString()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configData":
            return Optional.ofNullable(clazz.cast(configData()));
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "configType":
            return Optional.ofNullable(clazz.cast(configTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigRequest, T> g) {
        return obj -> g.apply((UpdateConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConfigRequest> {
        /**
         * <p>
         * Parameters of a <code>Config</code>.
         * </p>
         * 
         * @param configData
         *        Parameters of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configData(ConfigTypeData configData);

        /**
         * <p>
         * Parameters of a <code>Config</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigTypeData.Builder} avoiding the need
         * to create one manually via {@link ConfigTypeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigTypeData.Builder#build()} is called immediately and its
         * result is passed to {@link #configData(ConfigTypeData)}.
         * 
         * @param configData
         *        a consumer that will call methods on {@link ConfigTypeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configData(ConfigTypeData)
         */
        default Builder configData(Consumer<ConfigTypeData.Builder> configData) {
            return configData(ConfigTypeData.builder().applyMutation(configData).build());
        }

        /**
         * <p>
         * UUID of a <code>Config</code>.
         * </p>
         * 
         * @param configId
         *        UUID of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(String configType);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(ConfigCapabilityType configType);

        /**
         * <p>
         * Name of a <code>Config</code>.
         * </p>
         * 
         * @param name
         *        Name of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private ConfigTypeData configData;

        private String configId;

        private String configType;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigRequest model) {
            super(model);
            configData(model.configData);
            configId(model.configId);
            configType(model.configType);
            name(model.name);
        }

        public final ConfigTypeData.Builder getConfigData() {
            return configData != null ? configData.toBuilder() : null;
        }

        public final void setConfigData(ConfigTypeData.BuilderImpl configData) {
            this.configData = configData != null ? configData.build() : null;
        }

        @Override
        public final Builder configData(ConfigTypeData configData) {
            this.configData = configData;
            return this;
        }

        public final String getConfigId() {
            return configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getConfigType() {
            return configType;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigRequest build() {
            return new UpdateConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
