/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.groundstation.model.CancelContactRequest;
import software.amazon.awssdk.services.groundstation.model.CancelContactResponse;
import software.amazon.awssdk.services.groundstation.model.CreateConfigRequest;
import software.amazon.awssdk.services.groundstation.model.CreateConfigResponse;
import software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteConfigRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteConfigResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.DescribeContactRequest;
import software.amazon.awssdk.services.groundstation.model.DescribeContactResponse;
import software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.DescribeEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest;
import software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse;
import software.amazon.awssdk.services.groundstation.model.GetConfigRequest;
import software.amazon.awssdk.services.groundstation.model.GetConfigResponse;
import software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest;
import software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse;
import software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest;
import software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse;
import software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest;
import software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse;
import software.amazon.awssdk.services.groundstation.model.ListConfigsRequest;
import software.amazon.awssdk.services.groundstation.model.ListConfigsResponse;
import software.amazon.awssdk.services.groundstation.model.ListContactsRequest;
import software.amazon.awssdk.services.groundstation.model.ListContactsResponse;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse;
import software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.groundstation.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest;
import software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse;
import software.amazon.awssdk.services.groundstation.model.ReserveContactRequest;
import software.amazon.awssdk.services.groundstation.model.ReserveContactResponse;
import software.amazon.awssdk.services.groundstation.model.TagResourceRequest;
import software.amazon.awssdk.services.groundstation.model.TagResourceResponse;
import software.amazon.awssdk.services.groundstation.model.UntagResourceRequest;
import software.amazon.awssdk.services.groundstation.model.UntagResourceResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateConfigResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse;
import software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest;
import software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileResponse;
import software.amazon.awssdk.services.groundstation.paginators.ListConfigsPublisher;
import software.amazon.awssdk.services.groundstation.paginators.ListContactsPublisher;
import software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsPublisher;
import software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesPublisher;
import software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsPublisher;
import software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesPublisher;
import software.amazon.awssdk.services.groundstation.paginators.ListSatellitesPublisher;
import software.amazon.awssdk.services.groundstation.waiters.GroundStationAsyncWaiter;

/**
 * Service client for accessing AWS Ground Station asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Welcome to the AWS Ground Station API Reference. AWS Ground Station is a fully managed service that enables you to
 * control satellite communications, downlink and process satellite data, and scale your satellite operations
 * efficiently and cost-effectively without having to build or manage your own ground station infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GroundStationAsyncClient extends AwsClient {
    String SERVICE_NAME = "groundstation";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "groundstation";

    /**
     * <p>
     * Cancels a contact with a specified contact ID.
     * </p>
     *
     * @param cancelContactRequest
     * @return A Java Future containing the result of the CancelContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CancelContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CancelContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelContactResponse> cancelContact(CancelContactRequest cancelContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a contact with a specified contact ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelContactRequest.Builder} avoiding the need to
     * create one manually via {@link CancelContactRequest#builder()}
     * </p>
     *
     * @param cancelContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.CancelContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CancelContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CancelContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelContactResponse> cancelContact(Consumer<CancelContactRequest.Builder> cancelContactRequest) {
        return cancelContact(CancelContactRequest.builder().applyMutation(cancelContactRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Config</code> with the specified <code>configData</code> parameters.
     * </p>
     * <p>
     * Only one type of <code>configData</code> can be specified.
     * </p>
     *
     * @param createConfigRequest
     * @return A Java Future containing the result of the CreateConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceLimitExceededException Account limits for this resource have been exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigResponse> createConfig(CreateConfigRequest createConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Config</code> with the specified <code>configData</code> parameters.
     * </p>
     * <p>
     * Only one type of <code>configData</code> can be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigRequest.Builder} avoiding the need to
     * create one manually via {@link CreateConfigRequest#builder()}
     * </p>
     *
     * @param createConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.CreateConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceLimitExceededException Account limits for this resource have been exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigResponse> createConfig(Consumer<CreateConfigRequest.Builder> createConfigRequest) {
        return createConfig(CreateConfigRequest.builder().applyMutation(createConfigRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DataflowEndpoint</code> group containing the specified list of <code>DataflowEndpoint</code>
     * objects.
     * </p>
     * <p>
     * The <code>name</code> field in each endpoint is used in your mission profile <code>DataflowEndpointConfig</code>
     * to specify which endpoints to use during a contact.
     * </p>
     * <p>
     * When a contact uses multiple <code>DataflowEndpointConfig</code> objects, each <code>Config</code> must match a
     * <code>DataflowEndpoint</code> in the same group.
     * </p>
     *
     * @param createDataflowEndpointGroupRequest
     * @return A Java Future containing the result of the CreateDataflowEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataflowEndpointGroupResponse> createDataflowEndpointGroup(
            CreateDataflowEndpointGroupRequest createDataflowEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DataflowEndpoint</code> group containing the specified list of <code>DataflowEndpoint</code>
     * objects.
     * </p>
     * <p>
     * The <code>name</code> field in each endpoint is used in your mission profile <code>DataflowEndpointConfig</code>
     * to specify which endpoints to use during a contact.
     * </p>
     * <p>
     * When a contact uses multiple <code>DataflowEndpointConfig</code> objects, each <code>Config</code> must match a
     * <code>DataflowEndpoint</code> in the same group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataflowEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataflowEndpointGroupRequest#builder()}
     * </p>
     *
     * @param createDataflowEndpointGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDataflowEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataflowEndpointGroupResponse> createDataflowEndpointGroup(
            Consumer<CreateDataflowEndpointGroupRequest.Builder> createDataflowEndpointGroupRequest) {
        return createDataflowEndpointGroup(CreateDataflowEndpointGroupRequest.builder()
                .applyMutation(createDataflowEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Creates an Ephemeris with the specified <code>EphemerisData</code>.
     * </p>
     *
     * @param createEphemerisRequest
     * @return A Java Future containing the result of the CreateEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEphemerisResponse> createEphemeris(CreateEphemerisRequest createEphemerisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Ephemeris with the specified <code>EphemerisData</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEphemerisRequest#builder()}
     * </p>
     *
     * @param createEphemerisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.CreateEphemerisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEphemerisResponse> createEphemeris(
            Consumer<CreateEphemerisRequest.Builder> createEphemerisRequest) {
        return createEphemeris(CreateEphemerisRequest.builder().applyMutation(createEphemerisRequest).build());
    }

    /**
     * <p>
     * Creates a mission profile.
     * </p>
     * <p>
     * <code>dataflowEdges</code> is a list of lists of strings. Each lower level list of strings has two elements: a
     * <i>from</i> ARN and a <i>to</i> ARN.
     * </p>
     *
     * @param createMissionProfileRequest
     * @return A Java Future containing the result of the CreateMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMissionProfileResponse> createMissionProfile(
            CreateMissionProfileRequest createMissionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a mission profile.
     * </p>
     * <p>
     * <code>dataflowEdges</code> is a list of lists of strings. Each lower level list of strings has two elements: a
     * <i>from</i> ARN and a <i>to</i> ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMissionProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMissionProfileRequest#builder()}
     * </p>
     *
     * @param createMissionProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.CreateMissionProfileRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.CreateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMissionProfileResponse> createMissionProfile(
            Consumer<CreateMissionProfileRequest.Builder> createMissionProfileRequest) {
        return createMissionProfile(CreateMissionProfileRequest.builder().applyMutation(createMissionProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Config</code>.
     * </p>
     *
     * @param deleteConfigRequest
     * @return A Java Future containing the result of the DeleteConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigResponse> deleteConfig(DeleteConfigRequest deleteConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Config</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteConfigRequest#builder()}
     * </p>
     *
     * @param deleteConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.DeleteConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigResponse> deleteConfig(Consumer<DeleteConfigRequest.Builder> deleteConfigRequest) {
        return deleteConfig(DeleteConfigRequest.builder().applyMutation(deleteConfigRequest).build());
    }

    /**
     * <p>
     * Deletes a dataflow endpoint group.
     * </p>
     *
     * @param deleteDataflowEndpointGroupRequest
     * @return A Java Future containing the result of the DeleteDataflowEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataflowEndpointGroupResponse> deleteDataflowEndpointGroup(
            DeleteDataflowEndpointGroupRequest deleteDataflowEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataflow endpoint group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataflowEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDataflowEndpointGroupRequest#builder()}
     * </p>
     *
     * @param deleteDataflowEndpointGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.DeleteDataflowEndpointGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDataflowEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataflowEndpointGroupResponse> deleteDataflowEndpointGroup(
            Consumer<DeleteDataflowEndpointGroupRequest.Builder> deleteDataflowEndpointGroupRequest) {
        return deleteDataflowEndpointGroup(DeleteDataflowEndpointGroupRequest.builder()
                .applyMutation(deleteDataflowEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an ephemeris
     * </p>
     *
     * @param deleteEphemerisRequest
     * @return A Java Future containing the result of the DeleteEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEphemerisResponse> deleteEphemeris(DeleteEphemerisRequest deleteEphemerisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ephemeris
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEphemerisRequest#builder()}
     * </p>
     *
     * @param deleteEphemerisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEphemerisResponse> deleteEphemeris(
            Consumer<DeleteEphemerisRequest.Builder> deleteEphemerisRequest) {
        return deleteEphemeris(DeleteEphemerisRequest.builder().applyMutation(deleteEphemerisRequest).build());
    }

    /**
     * <p>
     * Deletes a mission profile.
     * </p>
     *
     * @param deleteMissionProfileRequest
     * @return A Java Future containing the result of the DeleteMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMissionProfileResponse> deleteMissionProfile(
            DeleteMissionProfileRequest deleteMissionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a mission profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMissionProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMissionProfileRequest#builder()}
     * </p>
     *
     * @param deleteMissionProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DeleteMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMissionProfileResponse> deleteMissionProfile(
            Consumer<DeleteMissionProfileRequest.Builder> deleteMissionProfileRequest) {
        return deleteMissionProfile(DeleteMissionProfileRequest.builder().applyMutation(deleteMissionProfileRequest).build());
    }

    /**
     * <p>
     * Describes an existing contact.
     * </p>
     *
     * @param describeContactRequest
     * @return A Java Future containing the result of the DescribeContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeContactResponse> describeContact(DescribeContactRequest describeContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContactRequest#builder()}
     * </p>
     *
     * @param describeContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.DescribeContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeContactResponse> describeContact(
            Consumer<DescribeContactRequest.Builder> describeContactRequest) {
        return describeContact(DescribeContactRequest.builder().applyMutation(describeContactRequest).build());
    }

    /**
     * <p>
     * Describes an existing ephemeris.
     * </p>
     *
     * @param describeEphemerisRequest
     * @return A Java Future containing the result of the DescribeEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DescribeEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeEphemeris"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEphemerisResponse> describeEphemeris(DescribeEphemerisRequest describeEphemerisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing ephemeris.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEphemerisRequest#builder()}
     * </p>
     *
     * @param describeEphemerisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.DescribeEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeEphemeris"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEphemerisResponse> describeEphemeris(
            Consumer<DescribeEphemerisRequest.Builder> describeEphemerisRequest) {
        return describeEphemeris(DescribeEphemerisRequest.builder().applyMutation(describeEphemerisRequest).build());
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Gets the latest configuration information for a registered agent.
     * </p>
     *
     * @param getAgentConfigurationRequest
     * @return A Java Future containing the result of the GetAgentConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetAgentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetAgentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentConfigurationResponse> getAgentConfiguration(
            GetAgentConfigurationRequest getAgentConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Gets the latest configuration information for a registered agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetAgentConfigurationRequest#builder()}
     * </p>
     *
     * @param getAgentConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAgentConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetAgentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetAgentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentConfigurationResponse> getAgentConfiguration(
            Consumer<GetAgentConfigurationRequest.Builder> getAgentConfigurationRequest) {
        return getAgentConfiguration(GetAgentConfigurationRequest.builder().applyMutation(getAgentConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns <code>Config</code> information.
     * </p>
     * <p>
     * Only one <code>Config</code> response can be returned.
     * </p>
     *
     * @param getConfigRequest
     * @return A Java Future containing the result of the GetConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConfigResponse> getConfig(GetConfigRequest getConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns <code>Config</code> information.
     * </p>
     * <p>
     * Only one <code>Config</code> response can be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigRequest.Builder} avoiding the need to
     * create one manually via {@link GetConfigRequest#builder()}
     * </p>
     *
     * @param getConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.GetConfigRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConfigResponse> getConfig(Consumer<GetConfigRequest.Builder> getConfigRequest) {
        return getConfig(GetConfigRequest.builder().applyMutation(getConfigRequest).build());
    }

    /**
     * <p>
     * Returns the dataflow endpoint group.
     * </p>
     *
     * @param getDataflowEndpointGroupRequest
     * @return A Java Future containing the result of the GetDataflowEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataflowEndpointGroupResponse> getDataflowEndpointGroup(
            GetDataflowEndpointGroupRequest getDataflowEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the dataflow endpoint group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataflowEndpointGroupRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataflowEndpointGroupRequest#builder()}
     * </p>
     *
     * @param getDataflowEndpointGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDataflowEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetDataflowEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataflowEndpointGroupResponse> getDataflowEndpointGroup(
            Consumer<GetDataflowEndpointGroupRequest.Builder> getDataflowEndpointGroupRequest) {
        return getDataflowEndpointGroup(GetDataflowEndpointGroupRequest.builder().applyMutation(getDataflowEndpointGroupRequest)
                .build());
    }

    /**
     * <p>
     * Returns the number of reserved minutes used by account.
     * </p>
     *
     * @param getMinuteUsageRequest
     * @return A Java Future containing the result of the GetMinuteUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetMinuteUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMinuteUsage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMinuteUsageResponse> getMinuteUsage(GetMinuteUsageRequest getMinuteUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of reserved minutes used by account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMinuteUsageRequest.Builder} avoiding the need to
     * create one manually via {@link GetMinuteUsageRequest#builder()}
     * </p>
     *
     * @param getMinuteUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMinuteUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetMinuteUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMinuteUsage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMinuteUsageResponse> getMinuteUsage(Consumer<GetMinuteUsageRequest.Builder> getMinuteUsageRequest) {
        return getMinuteUsage(GetMinuteUsageRequest.builder().applyMutation(getMinuteUsageRequest).build());
    }

    /**
     * <p>
     * Returns a mission profile.
     * </p>
     *
     * @param getMissionProfileRequest
     * @return A Java Future containing the result of the GetMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMissionProfileResponse> getMissionProfile(GetMissionProfileRequest getMissionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a mission profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMissionProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetMissionProfileRequest#builder()}
     * </p>
     *
     * @param getMissionProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.GetMissionProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMissionProfileResponse> getMissionProfile(
            Consumer<GetMissionProfileRequest.Builder> getMissionProfileRequest) {
        return getMissionProfile(GetMissionProfileRequest.builder().applyMutation(getMissionProfileRequest).build());
    }

    /**
     * <p>
     * Returns a satellite.
     * </p>
     *
     * @param getSatelliteRequest
     * @return A Java Future containing the result of the GetSatellite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetSatellite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetSatellite" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSatelliteResponse> getSatellite(GetSatelliteRequest getSatelliteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a satellite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSatelliteRequest.Builder} avoiding the need to
     * create one manually via {@link GetSatelliteRequest#builder()}
     * </p>
     *
     * @param getSatelliteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.GetSatelliteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSatellite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.GetSatellite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetSatellite" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSatelliteResponse> getSatellite(Consumer<GetSatelliteRequest.Builder> getSatelliteRequest) {
        return getSatellite(GetSatelliteRequest.builder().applyMutation(getSatelliteRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>Config</code> objects.
     * </p>
     *
     * @param listConfigsRequest
     * @return A Java Future containing the result of the ListConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConfigsResponse> listConfigs(ListConfigsRequest listConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>Config</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConfigsRequest#builder()}
     * </p>
     *
     * @param listConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListConfigsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConfigsResponse> listConfigs(Consumer<ListConfigsRequest.Builder> listConfigsRequest) {
        return listConfigs(ListConfigsRequest.builder().applyMutation(listConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsPublisher publisher = client.listConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsPublisher publisher = client.listConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)} operation.</b>
     * </p>
     *
     * @param listConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigsPublisher listConfigsPaginator(ListConfigsRequest listConfigsRequest) {
        return new ListConfigsPublisher(this, listConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsPublisher publisher = client.listConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListConfigsPublisher publisher = client.listConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigs(software.amazon.awssdk.services.groundstation.model.ListConfigsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConfigsRequest#builder()}
     * </p>
     *
     * @param listConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListConfigsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigsPublisher listConfigsPaginator(Consumer<ListConfigsRequest.Builder> listConfigsRequest) {
        return listConfigsPaginator(ListConfigsRequest.builder().applyMutation(listConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of contacts.
     * </p>
     * <p>
     * If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>,
     * <code>missionprofileArn</code>, and <code>satelliteArn</code>.
     * </p>
     *
     * @param listContactsRequest
     * @return A Java Future containing the result of the ListContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListContactsResponse> listContacts(ListContactsRequest listContactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of contacts.
     * </p>
     * <p>
     * If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>,
     * <code>missionprofileArn</code>, and <code>satelliteArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListContactsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListContactsResponse> listContacts(Consumer<ListContactsRequest.Builder> listContactsRequest) {
        return listContacts(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation.</b>
     * </p>
     *
     * @param listContactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactsPublisher listContactsPaginator(ListContactsRequest listContactsRequest) {
        return new ListContactsPublisher(this, listContactsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.groundstation.model.ListContactsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListContactsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactsPublisher listContactsPaginator(Consumer<ListContactsRequest.Builder> listContactsRequest) {
        return listContactsPaginator(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DataflowEndpoint</code> groups.
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     * @return A Java Future containing the result of the ListDataflowEndpointGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataflowEndpointGroupsResponse> listDataflowEndpointGroups(
            ListDataflowEndpointGroupsRequest listDataflowEndpointGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DataflowEndpoint</code> groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataflowEndpointGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataflowEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDataflowEndpointGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataflowEndpointGroupsResponse> listDataflowEndpointGroups(
            Consumer<ListDataflowEndpointGroupsRequest.Builder> listDataflowEndpointGroupsRequest) {
        return listDataflowEndpointGroups(ListDataflowEndpointGroupsRequest.builder()
                .applyMutation(listDataflowEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsPublisher publisher = client.listDataflowEndpointGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsPublisher publisher = client.listDataflowEndpointGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataflowEndpointGroupsPublisher listDataflowEndpointGroupsPaginator(
            ListDataflowEndpointGroupsRequest listDataflowEndpointGroupsRequest) {
        return new ListDataflowEndpointGroupsPublisher(this, listDataflowEndpointGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsPublisher publisher = client.listDataflowEndpointGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListDataflowEndpointGroupsPublisher publisher = client.listDataflowEndpointGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataflowEndpointGroups(software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataflowEndpointGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataflowEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listDataflowEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListDataflowEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataflowEndpointGroupsPublisher listDataflowEndpointGroupsPaginator(
            Consumer<ListDataflowEndpointGroupsRequest.Builder> listDataflowEndpointGroupsRequest) {
        return listDataflowEndpointGroupsPaginator(ListDataflowEndpointGroupsRequest.builder()
                .applyMutation(listDataflowEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List existing ephemerides.
     * </p>
     *
     * @param listEphemeridesRequest
     * @return A Java Future containing the result of the ListEphemerides operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEphemeridesResponse> listEphemerides(ListEphemeridesRequest listEphemeridesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List existing ephemerides.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEphemeridesRequest.Builder} avoiding the need
     * to create one manually via {@link ListEphemeridesRequest#builder()}
     * </p>
     *
     * @param listEphemeridesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEphemerides operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEphemeridesResponse> listEphemerides(
            Consumer<ListEphemeridesRequest.Builder> listEphemeridesRequest) {
        return listEphemerides(ListEphemeridesRequest.builder().applyMutation(listEphemeridesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesPublisher publisher = client.listEphemeridesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesPublisher publisher = client.listEphemeridesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEphemeridesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEphemeridesPublisher listEphemeridesPaginator(ListEphemeridesRequest listEphemeridesRequest) {
        return new ListEphemeridesPublisher(this, listEphemeridesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesPublisher publisher = client.listEphemeridesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListEphemeridesPublisher publisher = client.listEphemeridesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEphemerides(software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEphemeridesRequest.Builder} avoiding the need
     * to create one manually via {@link ListEphemeridesRequest#builder()}
     * </p>
     *
     * @param listEphemeridesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListEphemerides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListEphemerides" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEphemeridesPublisher listEphemeridesPaginator(Consumer<ListEphemeridesRequest.Builder> listEphemeridesRequest) {
        return listEphemeridesPaginator(ListEphemeridesRequest.builder().applyMutation(listEphemeridesRequest).build());
    }

    /**
     * <p>
     * Returns a list of ground stations.
     * </p>
     *
     * @param listGroundStationsRequest
     * @return A Java Future containing the result of the ListGroundStations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroundStationsResponse> listGroundStations(ListGroundStationsRequest listGroundStationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ground stations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroundStationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroundStationsRequest#builder()}
     * </p>
     *
     * @param listGroundStationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGroundStations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroundStationsResponse> listGroundStations(
            Consumer<ListGroundStationsRequest.Builder> listGroundStationsRequest) {
        return listGroundStations(ListGroundStationsRequest.builder().applyMutation(listGroundStationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsPublisher publisher = client.listGroundStationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsPublisher publisher = client.listGroundStationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroundStationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroundStationsPublisher listGroundStationsPaginator(ListGroundStationsRequest listGroundStationsRequest) {
        return new ListGroundStationsPublisher(this, listGroundStationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsPublisher publisher = client.listGroundStationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListGroundStationsPublisher publisher = client.listGroundStationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroundStations(software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroundStationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroundStationsRequest#builder()}
     * </p>
     *
     * @param listGroundStationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListGroundStations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroundStationsPublisher listGroundStationsPaginator(
            Consumer<ListGroundStationsRequest.Builder> listGroundStationsRequest) {
        return listGroundStationsPaginator(ListGroundStationsRequest.builder().applyMutation(listGroundStationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of mission profiles.
     * </p>
     *
     * @param listMissionProfilesRequest
     * @return A Java Future containing the result of the ListMissionProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMissionProfilesResponse> listMissionProfiles(
            ListMissionProfilesRequest listMissionProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of mission profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMissionProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMissionProfilesRequest#builder()}
     * </p>
     *
     * @param listMissionProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMissionProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMissionProfilesResponse> listMissionProfiles(
            Consumer<ListMissionProfilesRequest.Builder> listMissionProfilesRequest) {
        return listMissionProfiles(ListMissionProfilesRequest.builder().applyMutation(listMissionProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesPublisher publisher = client.listMissionProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesPublisher publisher = client.listMissionProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMissionProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMissionProfilesPublisher listMissionProfilesPaginator(ListMissionProfilesRequest listMissionProfilesRequest) {
        return new ListMissionProfilesPublisher(this, listMissionProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesPublisher publisher = client.listMissionProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListMissionProfilesPublisher publisher = client.listMissionProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMissionProfiles(software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMissionProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMissionProfilesRequest#builder()}
     * </p>
     *
     * @param listMissionProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListMissionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMissionProfilesPublisher listMissionProfilesPaginator(
            Consumer<ListMissionProfilesRequest.Builder> listMissionProfilesRequest) {
        return listMissionProfilesPaginator(ListMissionProfilesRequest.builder().applyMutation(listMissionProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of satellites.
     * </p>
     *
     * @param listSatellitesRequest
     * @return A Java Future containing the result of the ListSatellites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSatellitesResponse> listSatellites(ListSatellitesRequest listSatellitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of satellites.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSatellitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSatellitesRequest#builder()}
     * </p>
     *
     * @param listSatellitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSatellites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSatellitesResponse> listSatellites(Consumer<ListSatellitesRequest.Builder> listSatellitesRequest) {
        return listSatellites(ListSatellitesRequest.builder().applyMutation(listSatellitesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesPublisher publisher = client.listSatellitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesPublisher publisher = client.listSatellitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation.</b>
     * </p>
     *
     * @param listSatellitesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSatellitesPublisher listSatellitesPaginator(ListSatellitesRequest listSatellitesRequest) {
        return new ListSatellitesPublisher(this, listSatellitesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesPublisher publisher = client.listSatellitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.groundstation.paginators.ListSatellitesPublisher publisher = client.listSatellitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSatellites(software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSatellitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSatellitesRequest#builder()}
     * </p>
     *
     * @param listSatellitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListSatellites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSatellitesPublisher listSatellitesPaginator(Consumer<ListSatellitesRequest.Builder> listSatellitesRequest) {
        return listSatellitesPaginator(ListSatellitesRequest.builder().applyMutation(listSatellitesRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Registers a new agent with AWS Ground Station.
     * </p>
     *
     * @param registerAgentRequest
     * @return A Java Future containing the result of the RegisterAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.RegisterAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/RegisterAgent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterAgentResponse> registerAgent(RegisterAgentRequest registerAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Registers a new agent with AWS Ground Station.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAgentRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterAgentRequest#builder()}
     * </p>
     *
     * @param registerAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.RegisterAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/RegisterAgent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterAgentResponse> registerAgent(Consumer<RegisterAgentRequest.Builder> registerAgentRequest) {
        return registerAgent(RegisterAgentRequest.builder().applyMutation(registerAgentRequest).build());
    }

    /**
     * <p>
     * Reserves a contact using specified parameters.
     * </p>
     *
     * @param reserveContactRequest
     * @return A Java Future containing the result of the ReserveContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ReserveContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ReserveContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ReserveContactResponse> reserveContact(ReserveContactRequest reserveContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reserves a contact using specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReserveContactRequest.Builder} avoiding the need to
     * create one manually via {@link ReserveContactRequest#builder()}
     * </p>
     *
     * @param reserveContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.ReserveContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ReserveContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.ReserveContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ReserveContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ReserveContactResponse> reserveContact(Consumer<ReserveContactRequest.Builder> reserveContactRequest) {
        return reserveContact(ReserveContactRequest.builder().applyMutation(reserveContactRequest).build());
    }

    /**
     * <p>
     * Assigns a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deassigns a resource tag.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deassigns a resource tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Update the status of the agent.
     * </p>
     *
     * @param updateAgentStatusRequest
     * @return A Java Future containing the result of the UpdateAgentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateAgentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentStatusResponse> updateAgentStatus(UpdateAgentStatusRequest updateAgentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * For use by AWS Ground Station Agent and shouldn't be called directly.
     * </p>
     * </note>
     * <p>
     * Update the status of the agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentStatusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAgentStatusRequest#builder()}
     * </p>
     *
     * @param updateAgentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAgentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateAgentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentStatusResponse> updateAgentStatus(
            Consumer<UpdateAgentStatusRequest.Builder> updateAgentStatusRequest) {
        return updateAgentStatus(UpdateAgentStatusRequest.builder().applyMutation(updateAgentStatusRequest).build());
    }

    /**
     * <p>
     * Updates the <code>Config</code> used when scheduling contacts.
     * </p>
     * <p>
     * Updating a <code>Config</code> will not update the execution parameters for existing future contacts scheduled
     * with this <code>Config</code>.
     * </p>
     *
     * @param updateConfigRequest
     * @return A Java Future containing the result of the UpdateConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConfigResponse> updateConfig(UpdateConfigRequest updateConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>Config</code> used when scheduling contacts.
     * </p>
     * <p>
     * Updating a <code>Config</code> will not update the execution parameters for existing future contacts scheduled
     * with this <code>Config</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateConfigRequest#builder()}
     * </p>
     *
     * @param updateConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.UpdateConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConfigResponse> updateConfig(Consumer<UpdateConfigRequest.Builder> updateConfigRequest) {
        return updateConfig(UpdateConfigRequest.builder().applyMutation(updateConfigRequest).build());
    }

    /**
     * <p>
     * Updates an existing ephemeris
     * </p>
     *
     * @param updateEphemerisRequest
     * @return A Java Future containing the result of the UpdateEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEphemerisResponse> updateEphemeris(UpdateEphemerisRequest updateEphemerisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing ephemeris
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEphemerisRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEphemerisRequest#builder()}
     * </p>
     *
     * @param updateEphemerisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEphemeris operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateEphemeris
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateEphemeris" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEphemerisResponse> updateEphemeris(
            Consumer<UpdateEphemerisRequest.Builder> updateEphemerisRequest) {
        return updateEphemeris(UpdateEphemerisRequest.builder().applyMutation(updateEphemerisRequest).build());
    }

    /**
     * <p>
     * Updates a mission profile.
     * </p>
     * <p>
     * Updating a mission profile will not update the execution parameters for existing future contacts.
     * </p>
     *
     * @param updateMissionProfileRequest
     * @return A Java Future containing the result of the UpdateMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMissionProfileResponse> updateMissionProfile(
            UpdateMissionProfileRequest updateMissionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a mission profile.
     * </p>
     * <p>
     * Updating a mission profile will not update the execution parameters for existing future contacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMissionProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMissionProfileRequest#builder()}
     * </p>
     *
     * @param updateMissionProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateMissionProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GroundStationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GroundStationAsyncClient.UpdateMissionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateMissionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMissionProfileResponse> updateMissionProfile(
            Consumer<UpdateMissionProfileRequest.Builder> updateMissionProfileRequest) {
        return updateMissionProfile(UpdateMissionProfileRequest.builder().applyMutation(updateMissionProfileRequest).build());
    }

    /**
     * Create an instance of {@link GroundStationAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link GroundStationAsyncWaiter}
     */
    default GroundStationAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default GroundStationServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GroundStationAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GroundStationAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GroundStationAsyncClient}.
     */
    static GroundStationAsyncClientBuilder builder() {
        return new DefaultGroundStationAsyncClientBuilder();
    }
}
