/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.Criticality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrackingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrackingConfig> {
    private static final SdkField<String> AUTOTRACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autotrack").getter(TrackingConfig.getter(TrackingConfig::autotrackAsString)).setter(TrackingConfig.setter(Builder::autotrack)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autotrack").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOTRACK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autotrack;

    private TrackingConfig(BuilderImpl builder) {
        this.autotrack = builder.autotrack;
    }

    public final Criticality autotrack() {
        return Criticality.fromValue(this.autotrack);
    }

    public final String autotrackAsString() {
        return this.autotrack;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autotrackAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingConfig)) {
            return false;
        }
        TrackingConfig other = (TrackingConfig)obj;
        return Objects.equals(this.autotrackAsString(), other.autotrackAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TrackingConfig").add("Autotrack", (Object)this.autotrackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autotrack": {
                return Optional.ofNullable(clazz.cast(this.autotrackAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrackingConfig, T> g) {
        return obj -> g.apply((TrackingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autotrack;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingConfig model) {
            this.autotrack(model.autotrack);
        }

        public final String getAutotrack() {
            return this.autotrack;
        }

        public final void setAutotrack(String autotrack) {
            this.autotrack = autotrack;
        }

        @Override
        public final Builder autotrack(String autotrack) {
            this.autotrack = autotrack;
            return this;
        }

        @Override
        public final Builder autotrack(Criticality autotrack) {
            this.autotrack(autotrack == null ? null : autotrack.toString());
            return this;
        }

        public TrackingConfig build() {
            return new TrackingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrackingConfig> {
        public Builder autotrack(String var1);

        public Builder autotrack(Criticality var1);
    }
}

