/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.AgentDetails;
import software.amazon.awssdk.services.groundstation.model.DiscoveryData;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterAgentRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, RegisterAgentRequest> {
    private static final SdkField<AgentDetails> AGENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentDetails").getter(RegisterAgentRequest.getter(RegisterAgentRequest::agentDetails)).setter(RegisterAgentRequest.setter(Builder::agentDetails)).constructor(AgentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDetails").build()}).build();
    private static final SdkField<DiscoveryData> DISCOVERY_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("discoveryData").getter(RegisterAgentRequest.getter(RegisterAgentRequest::discoveryData)).setter(RegisterAgentRequest.setter(Builder::discoveryData)).constructor(DiscoveryData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_DETAILS_FIELD, DISCOVERY_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("agentDetails", AGENT_DETAILS_FIELD);
            this.put("discoveryData", DISCOVERY_DATA_FIELD);
        }
    });
    private final AgentDetails agentDetails;
    private final DiscoveryData discoveryData;

    private RegisterAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentDetails = builder.agentDetails;
        this.discoveryData = builder.discoveryData;
    }

    public final AgentDetails agentDetails() {
        return this.agentDetails;
    }

    public final DiscoveryData discoveryData() {
        return this.discoveryData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAgentRequest)) {
            return false;
        }
        RegisterAgentRequest other = (RegisterAgentRequest)((Object)obj);
        return Objects.equals(this.agentDetails(), other.agentDetails()) && Objects.equals(this.discoveryData(), other.discoveryData());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterAgentRequest").add("AgentDetails", (Object)this.agentDetails()).add("DiscoveryData", (Object)this.discoveryData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentDetails": {
                return Optional.ofNullable(clazz.cast(this.agentDetails()));
            }
            case "discoveryData": {
                return Optional.ofNullable(clazz.cast(this.discoveryData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAgentRequest, T> g) {
        return obj -> g.apply((RegisterAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private AgentDetails agentDetails;
        private DiscoveryData discoveryData;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAgentRequest model) {
            super(model);
            this.agentDetails(model.agentDetails);
            this.discoveryData(model.discoveryData);
        }

        public final AgentDetails.Builder getAgentDetails() {
            return this.agentDetails != null ? this.agentDetails.toBuilder() : null;
        }

        public final void setAgentDetails(AgentDetails.BuilderImpl agentDetails) {
            this.agentDetails = agentDetails != null ? agentDetails.build() : null;
        }

        @Override
        public final Builder agentDetails(AgentDetails agentDetails) {
            this.agentDetails = agentDetails;
            return this;
        }

        public final DiscoveryData.Builder getDiscoveryData() {
            return this.discoveryData != null ? this.discoveryData.toBuilder() : null;
        }

        public final void setDiscoveryData(DiscoveryData.BuilderImpl discoveryData) {
            this.discoveryData = discoveryData != null ? discoveryData.build() : null;
        }

        @Override
        public final Builder discoveryData(DiscoveryData discoveryData) {
            this.discoveryData = discoveryData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAgentRequest build() {
            return new RegisterAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterAgentRequest> {
        public Builder agentDetails(AgentDetails var1);

        default public Builder agentDetails(Consumer<AgentDetails.Builder> agentDetails) {
            return this.agentDetails((AgentDetails)((AgentDetails.Builder)AgentDetails.builder().applyMutation(agentDetails)).build());
        }

        public Builder discoveryData(DiscoveryData var1);

        default public Builder discoveryData(Consumer<DiscoveryData.Builder> discoveryData) {
            return this.discoveryData((DiscoveryData)((DiscoveryData.Builder)DiscoveryData.builder().applyMutation(discoveryData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

