/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KmsKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KmsKey> {
    private static final SdkField<String> KMS_ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsAliasArn").getter(KmsKey.getter(KmsKey::kmsAliasArn)).setter(KmsKey.setter(Builder::kmsAliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAliasArn").build()}).build();
    private static final SdkField<String> KMS_ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsAliasName").getter(KmsKey.getter(KmsKey::kmsAliasName)).setter(KmsKey.setter(Builder::kmsAliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAliasName").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(KmsKey.getter(KmsKey::kmsKeyArn)).setter(KmsKey.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ALIAS_ARN_FIELD, KMS_ALIAS_NAME_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("kmsAliasArn", KMS_ALIAS_ARN_FIELD);
            this.put("kmsAliasName", KMS_ALIAS_NAME_FIELD);
            this.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String kmsAliasArn;
    private final String kmsAliasName;
    private final String kmsKeyArn;
    private final Type type;

    private KmsKey(BuilderImpl builder) {
        this.kmsAliasArn = builder.kmsAliasArn;
        this.kmsAliasName = builder.kmsAliasName;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.type = builder.type;
    }

    public final String kmsAliasArn() {
        return this.kmsAliasArn;
    }

    public final String kmsAliasName() {
        return this.kmsAliasName;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsKey)) {
            return false;
        }
        KmsKey other = (KmsKey)obj;
        return Objects.equals(this.kmsAliasArn(), other.kmsAliasArn()) && Objects.equals(this.kmsAliasName(), other.kmsAliasName()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"KmsKey").add("KmsAliasArn", (Object)this.kmsAliasArn()).add("KmsAliasName", (Object)this.kmsAliasName()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsAliasArn": {
                return Optional.ofNullable(clazz.cast(this.kmsAliasArn()));
            }
            case "kmsAliasName": {
                return Optional.ofNullable(clazz.cast(this.kmsAliasName()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public static KmsKey fromKmsAliasArn(String kmsAliasArn) {
        return (KmsKey)KmsKey.builder().kmsAliasArn(kmsAliasArn).build();
    }

    public static KmsKey fromKmsAliasName(String kmsAliasName) {
        return (KmsKey)KmsKey.builder().kmsAliasName(kmsAliasName).build();
    }

    public static KmsKey fromKmsKeyArn(String kmsKeyArn) {
        return (KmsKey)KmsKey.builder().kmsKeyArn(kmsKeyArn).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KmsKey, T> g) {
        return obj -> g.apply((KmsKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        KMS_ALIAS_ARN,
        KMS_ALIAS_NAME,
        KMS_KEY_ARN,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String kmsAliasArn;
        private String kmsAliasName;
        private String kmsKeyArn;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KmsKey model) {
            this.kmsAliasArn(model.kmsAliasArn);
            this.kmsAliasName(model.kmsAliasName);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getKmsAliasArn() {
            return this.kmsAliasArn;
        }

        public final void setKmsAliasArn(String kmsAliasArn) {
            String oldValue = this.kmsAliasArn;
            this.kmsAliasArn = kmsAliasArn;
            this.handleUnionValueChange(Type.KMS_ALIAS_ARN, oldValue, this.kmsAliasArn);
        }

        @Override
        public final Builder kmsAliasArn(String kmsAliasArn) {
            String oldValue = this.kmsAliasArn;
            this.kmsAliasArn = kmsAliasArn;
            this.handleUnionValueChange(Type.KMS_ALIAS_ARN, oldValue, this.kmsAliasArn);
            return this;
        }

        public final String getKmsAliasName() {
            return this.kmsAliasName;
        }

        public final void setKmsAliasName(String kmsAliasName) {
            String oldValue = this.kmsAliasName;
            this.kmsAliasName = kmsAliasName;
            this.handleUnionValueChange(Type.KMS_ALIAS_NAME, oldValue, this.kmsAliasName);
        }

        @Override
        public final Builder kmsAliasName(String kmsAliasName) {
            String oldValue = this.kmsAliasName;
            this.kmsAliasName = kmsAliasName;
            this.handleUnionValueChange(Type.KMS_ALIAS_NAME, oldValue, this.kmsAliasName);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            String oldValue = this.kmsKeyArn;
            this.kmsKeyArn = kmsKeyArn;
            this.handleUnionValueChange(Type.KMS_KEY_ARN, oldValue, this.kmsKeyArn);
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            String oldValue = this.kmsKeyArn;
            this.kmsKeyArn = kmsKeyArn;
            this.handleUnionValueChange(Type.KMS_KEY_ARN, oldValue, this.kmsKeyArn);
            return this;
        }

        public KmsKey build() {
            return new KmsKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KmsKey> {
        public Builder kmsAliasArn(String var1);

        public Builder kmsAliasName(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

