/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Version information for agent components.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentVersion.Builder, ComponentVersion> {
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentType").getter(getter(ComponentVersion::componentType)).setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()).build();

    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("versions")
            .getter(getter(ComponentVersion::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_FIELD,
            VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentType;

    private final List<String> versions;

    private ComponentVersion(BuilderImpl builder) {
        this.componentType = builder.componentType;
        this.versions = builder.versions;
    }

    /**
     * <p>
     * Component type.
     * </p>
     * 
     * @return Component type.
     */
    public final String componentType() {
        return componentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Versions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersions} method.
     * </p>
     * 
     * @return List of versions.
     */
    public final List<String> versions() {
        return versions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentType());
        hashCode = 31 * hashCode + Objects.hashCode(hasVersions() ? versions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVersion)) {
            return false;
        }
        ComponentVersion other = (ComponentVersion) obj;
        return Objects.equals(componentType(), other.componentType()) && hasVersions() == other.hasVersions()
                && Objects.equals(versions(), other.versions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentVersion").add("ComponentType", componentType())
                .add("Versions", hasVersions() ? versions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        case "versions":
            return Optional.ofNullable(clazz.cast(versions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentType", COMPONENT_TYPE_FIELD);
        map.put("versions", VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentVersion, T> g) {
        return obj -> g.apply((ComponentVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentVersion> {
        /**
         * <p>
         * Component type.
         * </p>
         * 
         * @param componentType
         *        Component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(String componentType);

        /**
         * <p>
         * List of versions.
         * </p>
         * 
         * @param versions
         *        List of versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<String> versions);

        /**
         * <p>
         * List of versions.
         * </p>
         * 
         * @param versions
         *        List of versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(String... versions);
    }

    static final class BuilderImpl implements Builder {
        private String componentType;

        private List<String> versions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentVersion model) {
            componentType(model.componentType);
            versions(model.versions);
        }

        public final String getComponentType() {
            return componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final Collection<String> getVersions() {
            if (versions instanceof SdkAutoConstructList) {
                return null;
            }
            return versions;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        public ComponentVersion build() {
            return new ComponentVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
