/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataflowEndpointGroupRequest extends GroundStationRequest implements
        ToCopyableBuilder<CreateDataflowEndpointGroupRequest.Builder, CreateDataflowEndpointGroupRequest> {
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPostPassDurationSeconds")
            .getter(getter(CreateDataflowEndpointGroupRequest::contactPostPassDurationSeconds))
            .setter(setter(Builder::contactPostPassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds")
                    .build()).build();

    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPrePassDurationSeconds")
            .getter(getter(CreateDataflowEndpointGroupRequest::contactPrePassDurationSeconds))
            .setter(setter(Builder::contactPrePassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds")
                    .build()).build();

    private static final SdkField<List<EndpointDetails>> ENDPOINT_DETAILS_FIELD = SdkField
            .<List<EndpointDetails>> builder(MarshallingType.LIST)
            .memberName("endpointDetails")
            .getter(getter(CreateDataflowEndpointGroupRequest::endpointDetails))
            .setter(setter(Builder::endpointDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDataflowEndpointGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTACT_POST_PASS_DURATION_SECONDS_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, ENDPOINT_DETAILS_FIELD,
                    TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer contactPostPassDurationSeconds;

    private final Integer contactPrePassDurationSeconds;

    private final List<EndpointDetails> endpointDetails;

    private final Map<String, String> tags;

    private CreateDataflowEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.endpointDetails = builder.endpointDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a
     * <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the
     * Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
     * </p>
     * 
     * @return Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be
     *         in a <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be
     *         emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
     */
    public final Integer contactPostPassDurationSeconds() {
        return contactPostPassDurationSeconds;
    }

    /**
     * <p>
     * Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a
     * <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the
     * Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
     * </p>
     * 
     * @return Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will
     *         be in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be
     *         emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
     */
    public final Integer contactPrePassDurationSeconds() {
        return contactPrePassDurationSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointDetails() {
        return endpointDetails != null && !(endpointDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Endpoint details of each endpoint in the dataflow endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointDetails} method.
     * </p>
     * 
     * @return Endpoint details of each endpoint in the dataflow endpoint group.
     */
    public final List<EndpointDetails> endpointDetails() {
        return endpointDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags of a dataflow endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags of a dataflow endpoint group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointDetails() ? endpointDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataflowEndpointGroupRequest)) {
            return false;
        }
        CreateDataflowEndpointGroupRequest other = (CreateDataflowEndpointGroupRequest) obj;
        return Objects.equals(contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds())
                && Objects.equals(contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds())
                && hasEndpointDetails() == other.hasEndpointDetails()
                && Objects.equals(endpointDetails(), other.endpointDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataflowEndpointGroupRequest")
                .add("ContactPostPassDurationSeconds", contactPostPassDurationSeconds())
                .add("ContactPrePassDurationSeconds", contactPrePassDurationSeconds())
                .add("EndpointDetails", hasEndpointDetails() ? endpointDetails() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactPostPassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPostPassDurationSeconds()));
        case "contactPrePassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPrePassDurationSeconds()));
        case "endpointDetails":
            return Optional.ofNullable(clazz.cast(endpointDetails()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contactPostPassDurationSeconds", CONTACT_POST_PASS_DURATION_SECONDS_FIELD);
        map.put("contactPrePassDurationSeconds", CONTACT_PRE_PASS_DURATION_SECONDS_FIELD);
        map.put("endpointDetails", ENDPOINT_DETAILS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataflowEndpointGroupRequest, T> g) {
        return obj -> g.apply((CreateDataflowEndpointGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataflowEndpointGroupRequest> {
        /**
         * <p>
         * Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a
         * <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when
         * the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
         * </p>
         * 
         * @param contactPostPassDurationSeconds
         *        Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will
         *        be in a <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will
         *        be emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds);

        /**
         * <p>
         * Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be
         * in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted
         * when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
         * </p>
         * 
         * @param contactPrePassDurationSeconds
         *        Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group
         *        will be in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event
         *        will be emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds);

        /**
         * <p>
         * Endpoint details of each endpoint in the dataflow endpoint group.
         * </p>
         * 
         * @param endpointDetails
         *        Endpoint details of each endpoint in the dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDetails(Collection<EndpointDetails> endpointDetails);

        /**
         * <p>
         * Endpoint details of each endpoint in the dataflow endpoint group.
         * </p>
         * 
         * @param endpointDetails
         *        Endpoint details of each endpoint in the dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDetails(EndpointDetails... endpointDetails);

        /**
         * <p>
         * Endpoint details of each endpoint in the dataflow endpoint group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.EndpointDetails.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.groundstation.model.EndpointDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.EndpointDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointDetails(List<EndpointDetails>)}.
         * 
         * @param endpointDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.EndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDetails(java.util.Collection<EndpointDetails>)
         */
        Builder endpointDetails(Consumer<EndpointDetails.Builder>... endpointDetails);

        /**
         * <p>
         * Tags of a dataflow endpoint group.
         * </p>
         * 
         * @param tags
         *        Tags of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private Integer contactPostPassDurationSeconds;

        private Integer contactPrePassDurationSeconds;

        private List<EndpointDetails> endpointDetails = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataflowEndpointGroupRequest model) {
            super(model);
            contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            endpointDetails(model.endpointDetails);
            tags(model.tags);
        }

        public final Integer getContactPostPassDurationSeconds() {
            return contactPostPassDurationSeconds;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return contactPrePassDurationSeconds;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final List<EndpointDetails.Builder> getEndpointDetails() {
            List<EndpointDetails.Builder> result = EndpointDetailsListCopier.copyToBuilder(this.endpointDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointDetails(Collection<EndpointDetails.BuilderImpl> endpointDetails) {
            this.endpointDetails = EndpointDetailsListCopier.copyFromBuilder(endpointDetails);
        }

        @Override
        public final Builder endpointDetails(Collection<EndpointDetails> endpointDetails) {
            this.endpointDetails = EndpointDetailsListCopier.copy(endpointDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDetails(EndpointDetails... endpointDetails) {
            endpointDetails(Arrays.asList(endpointDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDetails(Consumer<EndpointDetails.Builder>... endpointDetails) {
            endpointDetails(Stream.of(endpointDetails).map(c -> EndpointDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataflowEndpointGroupRequest build() {
            return new CreateDataflowEndpointGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
