/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Ingress address of AgentEndpoint with a port range and an optional mtu.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RangedConnectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RangedConnectionDetails.Builder, RangedConnectionDetails> {
    private static final SdkField<Integer> MTU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("mtu")
            .getter(getter(RangedConnectionDetails::mtu)).setter(setter(Builder::mtu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()).build();

    private static final SdkField<RangedSocketAddress> SOCKET_ADDRESS_FIELD = SdkField
            .<RangedSocketAddress> builder(MarshallingType.SDK_POJO).memberName("socketAddress")
            .getter(getter(RangedConnectionDetails::socketAddress)).setter(setter(Builder::socketAddress))
            .constructor(RangedSocketAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("socketAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MTU_FIELD,
            SOCKET_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer mtu;

    private final RangedSocketAddress socketAddress;

    private RangedConnectionDetails(BuilderImpl builder) {
        this.mtu = builder.mtu;
        this.socketAddress = builder.socketAddress;
    }

    /**
     * <p>
     * Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
     * </p>
     * 
     * @return Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
     */
    public final Integer mtu() {
        return mtu;
    }

    /**
     * <p>
     * A ranged socket address.
     * </p>
     * 
     * @return A ranged socket address.
     */
    public final RangedSocketAddress socketAddress() {
        return socketAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mtu());
        hashCode = 31 * hashCode + Objects.hashCode(socketAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RangedConnectionDetails)) {
            return false;
        }
        RangedConnectionDetails other = (RangedConnectionDetails) obj;
        return Objects.equals(mtu(), other.mtu()) && Objects.equals(socketAddress(), other.socketAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RangedConnectionDetails").add("Mtu", mtu()).add("SocketAddress", socketAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mtu":
            return Optional.ofNullable(clazz.cast(mtu()));
        case "socketAddress":
            return Optional.ofNullable(clazz.cast(socketAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mtu", MTU_FIELD);
        map.put("socketAddress", SOCKET_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RangedConnectionDetails, T> g) {
        return obj -> g.apply((RangedConnectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RangedConnectionDetails> {
        /**
         * <p>
         * Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
         * </p>
         * 
         * @param mtu
         *        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mtu(Integer mtu);

        /**
         * <p>
         * A ranged socket address.
         * </p>
         * 
         * @param socketAddress
         *        A ranged socket address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder socketAddress(RangedSocketAddress socketAddress);

        /**
         * <p>
         * A ranged socket address.
         * </p>
         * This is a convenience method that creates an instance of the {@link RangedSocketAddress.Builder} avoiding the
         * need to create one manually via {@link RangedSocketAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RangedSocketAddress.Builder#build()} is called immediately and
         * its result is passed to {@link #socketAddress(RangedSocketAddress)}.
         * 
         * @param socketAddress
         *        a consumer that will call methods on {@link RangedSocketAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #socketAddress(RangedSocketAddress)
         */
        default Builder socketAddress(Consumer<RangedSocketAddress.Builder> socketAddress) {
            return socketAddress(RangedSocketAddress.builder().applyMutation(socketAddress).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer mtu;

        private RangedSocketAddress socketAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(RangedConnectionDetails model) {
            mtu(model.mtu);
            socketAddress(model.socketAddress);
        }

        public final Integer getMtu() {
            return mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final RangedSocketAddress.Builder getSocketAddress() {
            return socketAddress != null ? socketAddress.toBuilder() : null;
        }

        public final void setSocketAddress(RangedSocketAddress.BuilderImpl socketAddress) {
            this.socketAddress = socketAddress != null ? socketAddress.build() : null;
        }

        @Override
        public final Builder socketAddress(RangedSocketAddress socketAddress) {
            this.socketAddress = socketAddress;
            return this;
        }

        @Override
        public RangedConnectionDetails build() {
            return new RangedConnectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
