/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEphemerisRequest extends GroundStationRequest implements
        ToCopyableBuilder<UpdateEphemerisRequest.Builder, UpdateEphemerisRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(UpdateEphemerisRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisId").getter(getter(UpdateEphemerisRequest::ephemerisId)).setter(setter(Builder::ephemerisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ephemerisId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateEphemerisRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(UpdateEphemerisRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            EPHEMERIS_ID_FIELD, NAME_FIELD, PRIORITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean enabled;

    private final String ephemerisId;

    private final String name;

    private final Integer priority;

    private UpdateEphemerisRequest(BuilderImpl builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.ephemerisId = builder.ephemerisId;
        this.name = builder.name;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * Whether the ephemeris is enabled or not. Changing this value will not require the ephemeris to be re-validated.
     * </p>
     * 
     * @return Whether the ephemeris is enabled or not. Changing this value will not require the ephemeris to be
     *         re-validated.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The AWS Ground Station ephemeris ID.
     * </p>
     * 
     * @return The AWS Ground Station ephemeris ID.
     */
    public final String ephemerisId() {
        return ephemerisId;
    }

    /**
     * <p>
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     * </p>
     * 
     * @return A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
     * </p>
     * <p>
     * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     * </p>
     * <p>
     * Priority must be 1 or greater
     * </p>
     * 
     * @return Customer-provided priority score to establish the order in which overlapping ephemerides should be
     *         used.</p>
     *         <p>
     *         The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     *         </p>
     *         <p>
     *         Priority must be 1 or greater
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEphemerisRequest)) {
            return false;
        }
        UpdateEphemerisRequest other = (UpdateEphemerisRequest) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(ephemerisId(), other.ephemerisId())
                && Objects.equals(name(), other.name()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEphemerisRequest").add("Enabled", enabled()).add("EphemerisId", ephemerisId())
                .add("Name", name()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "ephemerisId":
            return Optional.ofNullable(clazz.cast(ephemerisId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("ephemerisId", EPHEMERIS_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEphemerisRequest, T> g) {
        return obj -> g.apply((UpdateEphemerisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEphemerisRequest> {
        /**
         * <p>
         * Whether the ephemeris is enabled or not. Changing this value will not require the ephemeris to be
         * re-validated.
         * </p>
         * 
         * @param enabled
         *        Whether the ephemeris is enabled or not. Changing this value will not require the ephemeris to be
         *        re-validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The AWS Ground Station ephemeris ID.
         * </p>
         * 
         * @param ephemerisId
         *        The AWS Ground Station ephemeris ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerisId(String ephemerisId);

        /**
         * <p>
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         * </p>
         * 
         * @param name
         *        A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
         * </p>
         * <p>
         * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         * </p>
         * <p>
         * Priority must be 1 or greater
         * </p>
         * 
         * @param priority
         *        Customer-provided priority score to establish the order in which overlapping ephemerides should be
         *        used.</p>
         *        <p>
         *        The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         *        </p>
         *        <p>
         *        Priority must be 1 or greater
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private Boolean enabled;

        private String ephemerisId;

        private String name;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEphemerisRequest model) {
            super(model);
            enabled(model.enabled);
            ephemerisId(model.ephemerisId);
            name(model.name);
            priority(model.priority);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEphemerisId() {
            return ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEphemerisRequest build() {
            return new UpdateEphemerisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
