/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.ContactData;
import software.amazon.awssdk.services.groundstation.model.ContactListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactsResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListContactsResponse> {
    private static final SdkField<List<ContactData>> CONTACT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contactList").getter(ListContactsResponse.getter(ListContactsResponse::contactList)).setter(ListContactsResponse.setter(Builder::contactList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListContactsResponse.getter(ListContactsResponse::nextToken)).setter(ListContactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListContactsResponse.memberNameToFieldInitializer();
    private final List<ContactData> contactList;
    private final String nextToken;

    private ListContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contactList = builder.contactList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContactList() {
        return this.contactList != null && !(this.contactList instanceof SdkAutoConstructList);
    }

    public final List<ContactData> contactList() {
        return this.contactList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactList() ? this.contactList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsResponse)) {
            return false;
        }
        ListContactsResponse other = (ListContactsResponse)((Object)obj);
        return this.hasContactList() == other.hasContactList() && Objects.equals(this.contactList(), other.contactList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactsResponse").add("ContactList", this.hasContactList() ? this.contactList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactList": {
                return Optional.ofNullable(clazz.cast(this.contactList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contactList", CONTACT_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactsResponse, T> g) {
        return obj -> g.apply((ListContactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private List<ContactData> contactList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsResponse model) {
            super(model);
            this.contactList(model.contactList);
            this.nextToken(model.nextToken);
        }

        public final List<ContactData.Builder> getContactList() {
            List<ContactData.Builder> result = ContactListCopier.copyToBuilder(this.contactList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactList(Collection<ContactData.BuilderImpl> contactList) {
            this.contactList = ContactListCopier.copyFromBuilder(contactList);
        }

        @Override
        public final Builder contactList(Collection<ContactData> contactList) {
            this.contactList = ContactListCopier.copy(contactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactList(ContactData ... contactList) {
            this.contactList(Arrays.asList(contactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactList(Consumer<ContactData.Builder> ... contactList) {
            this.contactList(Stream.of(contactList).map(c -> (ContactData)((ContactData.Builder)ContactData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactsResponse build() {
            return new ListContactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactsResponse> {
        public Builder contactList(Collection<ContactData> var1);

        public Builder contactList(ContactData ... var1);

        public Builder contactList(Consumer<ContactData.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

