/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.Eirp;
import software.amazon.awssdk.services.groundstation.model.UplinkSpectrumConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AntennaUplinkConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AntennaUplinkConfig> {
    private static final SdkField<UplinkSpectrumConfig> SPECTRUM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spectrumConfig").getter(AntennaUplinkConfig.getter(AntennaUplinkConfig::spectrumConfig)).setter(AntennaUplinkConfig.setter(Builder::spectrumConfig)).constructor(UplinkSpectrumConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spectrumConfig").build()}).build();
    private static final SdkField<Eirp> TARGET_EIRP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetEirp").getter(AntennaUplinkConfig.getter(AntennaUplinkConfig::targetEirp)).setter(AntennaUplinkConfig.setter(Builder::targetEirp)).constructor(Eirp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetEirp").build()}).build();
    private static final SdkField<Boolean> TRANSMIT_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("transmitDisabled").getter(AntennaUplinkConfig.getter(AntennaUplinkConfig::transmitDisabled)).setter(AntennaUplinkConfig.setter(Builder::transmitDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transmitDisabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECTRUM_CONFIG_FIELD, TARGET_EIRP_FIELD, TRANSMIT_DISABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AntennaUplinkConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UplinkSpectrumConfig spectrumConfig;
    private final Eirp targetEirp;
    private final Boolean transmitDisabled;

    private AntennaUplinkConfig(BuilderImpl builder) {
        this.spectrumConfig = builder.spectrumConfig;
        this.targetEirp = builder.targetEirp;
        this.transmitDisabled = builder.transmitDisabled;
    }

    public final UplinkSpectrumConfig spectrumConfig() {
        return this.spectrumConfig;
    }

    public final Eirp targetEirp() {
        return this.targetEirp;
    }

    public final Boolean transmitDisabled() {
        return this.transmitDisabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spectrumConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEirp());
        hashCode = 31 * hashCode + Objects.hashCode(this.transmitDisabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaUplinkConfig)) {
            return false;
        }
        AntennaUplinkConfig other = (AntennaUplinkConfig)obj;
        return Objects.equals(this.spectrumConfig(), other.spectrumConfig()) && Objects.equals(this.targetEirp(), other.targetEirp()) && Objects.equals(this.transmitDisabled(), other.transmitDisabled());
    }

    public final String toString() {
        return ToString.builder((String)"AntennaUplinkConfig").add("SpectrumConfig", (Object)this.spectrumConfig()).add("TargetEirp", (Object)this.targetEirp()).add("TransmitDisabled", (Object)this.transmitDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spectrumConfig": {
                return Optional.ofNullable(clazz.cast(this.spectrumConfig()));
            }
            case "targetEirp": {
                return Optional.ofNullable(clazz.cast(this.targetEirp()));
            }
            case "transmitDisabled": {
                return Optional.ofNullable(clazz.cast(this.transmitDisabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spectrumConfig", SPECTRUM_CONFIG_FIELD);
        map.put("targetEirp", TARGET_EIRP_FIELD);
        map.put("transmitDisabled", TRANSMIT_DISABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AntennaUplinkConfig, T> g) {
        return obj -> g.apply((AntennaUplinkConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UplinkSpectrumConfig spectrumConfig;
        private Eirp targetEirp;
        private Boolean transmitDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaUplinkConfig model) {
            this.spectrumConfig(model.spectrumConfig);
            this.targetEirp(model.targetEirp);
            this.transmitDisabled(model.transmitDisabled);
        }

        public final UplinkSpectrumConfig.Builder getSpectrumConfig() {
            return this.spectrumConfig != null ? this.spectrumConfig.toBuilder() : null;
        }

        public final void setSpectrumConfig(UplinkSpectrumConfig.BuilderImpl spectrumConfig) {
            this.spectrumConfig = spectrumConfig != null ? spectrumConfig.build() : null;
        }

        @Override
        public final Builder spectrumConfig(UplinkSpectrumConfig spectrumConfig) {
            this.spectrumConfig = spectrumConfig;
            return this;
        }

        public final Eirp.Builder getTargetEirp() {
            return this.targetEirp != null ? this.targetEirp.toBuilder() : null;
        }

        public final void setTargetEirp(Eirp.BuilderImpl targetEirp) {
            this.targetEirp = targetEirp != null ? targetEirp.build() : null;
        }

        @Override
        public final Builder targetEirp(Eirp targetEirp) {
            this.targetEirp = targetEirp;
            return this;
        }

        public final Boolean getTransmitDisabled() {
            return this.transmitDisabled;
        }

        public final void setTransmitDisabled(Boolean transmitDisabled) {
            this.transmitDisabled = transmitDisabled;
        }

        @Override
        public final Builder transmitDisabled(Boolean transmitDisabled) {
            this.transmitDisabled = transmitDisabled;
            return this;
        }

        public AntennaUplinkConfig build() {
            return new AntennaUplinkConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AntennaUplinkConfig> {
        public Builder spectrumConfig(UplinkSpectrumConfig var1);

        default public Builder spectrumConfig(Consumer<UplinkSpectrumConfig.Builder> spectrumConfig) {
            return this.spectrumConfig((UplinkSpectrumConfig)((UplinkSpectrumConfig.Builder)UplinkSpectrumConfig.builder().applyMutation(spectrumConfig)).build());
        }

        public Builder targetEirp(Eirp var1);

        default public Builder targetEirp(Consumer<Eirp.Builder> targetEirp) {
            return this.targetEirp((Eirp)((Eirp.Builder)Eirp.builder().applyMutation(targetEirp)).build());
        }

        public Builder transmitDisabled(Boolean var1);
    }
}

