/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.AgentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentStatusData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentStatusData> {
    private static final SdkField<Long> BYTES_RECEIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bytesReceived").getter(ComponentStatusData.getter(ComponentStatusData::bytesReceived)).setter(ComponentStatusData.setter(Builder::bytesReceived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesReceived").build()}).build();
    private static final SdkField<Long> BYTES_SENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bytesSent").getter(ComponentStatusData.getter(ComponentStatusData::bytesSent)).setter(ComponentStatusData.setter(Builder::bytesSent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesSent").build()}).build();
    private static final SdkField<String> CAPABILITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityArn").getter(ComponentStatusData.getter(ComponentStatusData::capabilityArn)).setter(ComponentStatusData.setter(Builder::capabilityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityArn").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentType").getter(ComponentStatusData.getter(ComponentStatusData::componentType)).setter(ComponentStatusData.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()}).build();
    private static final SdkField<String> DATAFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataflowId").getter(ComponentStatusData.getter(ComponentStatusData::dataflowId)).setter(ComponentStatusData.setter(Builder::dataflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowId").build()}).build();
    private static final SdkField<Long> PACKETS_DROPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("packetsDropped").getter(ComponentStatusData.getter(ComponentStatusData::packetsDropped)).setter(ComponentStatusData.setter(Builder::packetsDropped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetsDropped").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ComponentStatusData.getter(ComponentStatusData::statusAsString)).setter(ComponentStatusData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_RECEIVED_FIELD, BYTES_SENT_FIELD, CAPABILITY_ARN_FIELD, COMPONENT_TYPE_FIELD, DATAFLOW_ID_FIELD, PACKETS_DROPPED_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentStatusData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long bytesReceived;
    private final Long bytesSent;
    private final String capabilityArn;
    private final String componentType;
    private final String dataflowId;
    private final Long packetsDropped;
    private final String status;

    private ComponentStatusData(BuilderImpl builder) {
        this.bytesReceived = builder.bytesReceived;
        this.bytesSent = builder.bytesSent;
        this.capabilityArn = builder.capabilityArn;
        this.componentType = builder.componentType;
        this.dataflowId = builder.dataflowId;
        this.packetsDropped = builder.packetsDropped;
        this.status = builder.status;
    }

    public final Long bytesReceived() {
        return this.bytesReceived;
    }

    public final Long bytesSent() {
        return this.bytesSent;
    }

    public final String capabilityArn() {
        return this.capabilityArn;
    }

    public final String componentType() {
        return this.componentType;
    }

    public final String dataflowId() {
        return this.dataflowId;
    }

    public final Long packetsDropped() {
        return this.packetsDropped;
    }

    public final AgentStatus status() {
        return AgentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesReceived());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesSent());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetsDropped());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentStatusData)) {
            return false;
        }
        ComponentStatusData other = (ComponentStatusData)obj;
        return Objects.equals(this.bytesReceived(), other.bytesReceived()) && Objects.equals(this.bytesSent(), other.bytesSent()) && Objects.equals(this.capabilityArn(), other.capabilityArn()) && Objects.equals(this.componentType(), other.componentType()) && Objects.equals(this.dataflowId(), other.dataflowId()) && Objects.equals(this.packetsDropped(), other.packetsDropped()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentStatusData").add("BytesReceived", (Object)this.bytesReceived()).add("BytesSent", (Object)this.bytesSent()).add("CapabilityArn", (Object)this.capabilityArn()).add("ComponentType", (Object)this.componentType()).add("DataflowId", (Object)this.dataflowId()).add("PacketsDropped", (Object)this.packetsDropped()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bytesReceived": {
                return Optional.ofNullable(clazz.cast(this.bytesReceived()));
            }
            case "bytesSent": {
                return Optional.ofNullable(clazz.cast(this.bytesSent()));
            }
            case "capabilityArn": {
                return Optional.ofNullable(clazz.cast(this.capabilityArn()));
            }
            case "componentType": {
                return Optional.ofNullable(clazz.cast(this.componentType()));
            }
            case "dataflowId": {
                return Optional.ofNullable(clazz.cast(this.dataflowId()));
            }
            case "packetsDropped": {
                return Optional.ofNullable(clazz.cast(this.packetsDropped()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bytesReceived", BYTES_RECEIVED_FIELD);
        map.put("bytesSent", BYTES_SENT_FIELD);
        map.put("capabilityArn", CAPABILITY_ARN_FIELD);
        map.put("componentType", COMPONENT_TYPE_FIELD);
        map.put("dataflowId", DATAFLOW_ID_FIELD);
        map.put("packetsDropped", PACKETS_DROPPED_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentStatusData, T> g) {
        return obj -> g.apply((ComponentStatusData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long bytesReceived;
        private Long bytesSent;
        private String capabilityArn;
        private String componentType;
        private String dataflowId;
        private Long packetsDropped;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentStatusData model) {
            this.bytesReceived(model.bytesReceived);
            this.bytesSent(model.bytesSent);
            this.capabilityArn(model.capabilityArn);
            this.componentType(model.componentType);
            this.dataflowId(model.dataflowId);
            this.packetsDropped(model.packetsDropped);
            this.status(model.status);
        }

        public final Long getBytesReceived() {
            return this.bytesReceived;
        }

        public final void setBytesReceived(Long bytesReceived) {
            this.bytesReceived = bytesReceived;
        }

        @Override
        public final Builder bytesReceived(Long bytesReceived) {
            this.bytesReceived = bytesReceived;
            return this;
        }

        public final Long getBytesSent() {
            return this.bytesSent;
        }

        public final void setBytesSent(Long bytesSent) {
            this.bytesSent = bytesSent;
        }

        @Override
        public final Builder bytesSent(Long bytesSent) {
            this.bytesSent = bytesSent;
            return this;
        }

        public final String getCapabilityArn() {
            return this.capabilityArn;
        }

        public final void setCapabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
        }

        @Override
        public final Builder capabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
            return this;
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final String getDataflowId() {
            return this.dataflowId;
        }

        public final void setDataflowId(String dataflowId) {
            this.dataflowId = dataflowId;
        }

        @Override
        public final Builder dataflowId(String dataflowId) {
            this.dataflowId = dataflowId;
            return this;
        }

        public final Long getPacketsDropped() {
            return this.packetsDropped;
        }

        public final void setPacketsDropped(Long packetsDropped) {
            this.packetsDropped = packetsDropped;
        }

        @Override
        public final Builder packetsDropped(Long packetsDropped) {
            this.packetsDropped = packetsDropped;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ComponentStatusData build() {
            return new ComponentStatusData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentStatusData> {
        public Builder bytesReceived(Long var1);

        public Builder bytesSent(Long var1);

        public Builder capabilityArn(String var1);

        public Builder componentType(String var1);

        public Builder dataflowId(String var1);

        public Builder packetsDropped(Long var1);

        public Builder status(String var1);

        public Builder status(AgentStatus var1);
    }
}

