/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactStatus {
    SCHEDULING("SCHEDULING"),
    FAILED_TO_SCHEDULE("FAILED_TO_SCHEDULE"),
    SCHEDULED("SCHEDULED"),
    CANCELLED("CANCELLED"),
    AWS_CANCELLED("AWS_CANCELLED"),
    PREPASS("PREPASS"),
    PASS("PASS"),
    POSTPASS("POSTPASS"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    AVAILABLE("AVAILABLE"),
    CANCELLING("CANCELLING"),
    AWS_FAILED("AWS_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactStatus> VALUE_MAP;
    private final String value;

    private ContactStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactStatus> knownValues() {
        EnumSet<ContactStatus> knownValues = EnumSet.allOf(ContactStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactStatus.class, ContactStatus::toString);
    }
}

