/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.SocketAddress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionDetails> {
    private static final SdkField<Integer> MTU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mtu").getter(ConnectionDetails.getter(ConnectionDetails::mtu)).setter(ConnectionDetails.setter(Builder::mtu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()}).build();
    private static final SdkField<SocketAddress> SOCKET_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("socketAddress").getter(ConnectionDetails.getter(ConnectionDetails::socketAddress)).setter(ConnectionDetails.setter(Builder::socketAddress)).constructor(SocketAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("socketAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MTU_FIELD, SOCKET_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer mtu;
    private final SocketAddress socketAddress;

    private ConnectionDetails(BuilderImpl builder) {
        this.mtu = builder.mtu;
        this.socketAddress = builder.socketAddress;
    }

    public final Integer mtu() {
        return this.mtu;
    }

    public final SocketAddress socketAddress() {
        return this.socketAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mtu());
        hashCode = 31 * hashCode + Objects.hashCode(this.socketAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)obj;
        return Objects.equals(this.mtu(), other.mtu()) && Objects.equals(this.socketAddress(), other.socketAddress());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionDetails").add("Mtu", (Object)this.mtu()).add("SocketAddress", (Object)this.socketAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mtu": {
                return Optional.ofNullable(clazz.cast(this.mtu()));
            }
            case "socketAddress": {
                return Optional.ofNullable(clazz.cast(this.socketAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mtu", MTU_FIELD);
        map.put("socketAddress", SOCKET_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionDetails, T> g) {
        return obj -> g.apply((ConnectionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer mtu;
        private SocketAddress socketAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionDetails model) {
            this.mtu(model.mtu);
            this.socketAddress(model.socketAddress);
        }

        public final Integer getMtu() {
            return this.mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final SocketAddress.Builder getSocketAddress() {
            return this.socketAddress != null ? this.socketAddress.toBuilder() : null;
        }

        public final void setSocketAddress(SocketAddress.BuilderImpl socketAddress) {
            this.socketAddress = socketAddress != null ? socketAddress.build() : null;
        }

        @Override
        public final Builder socketAddress(SocketAddress socketAddress) {
            this.socketAddress = socketAddress;
            return this;
        }

        public ConnectionDetails build() {
            return new ConnectionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionDetails> {
        public Builder mtu(Integer var1);

        public Builder socketAddress(SocketAddress var1);

        default public Builder socketAddress(Consumer<SocketAddress.Builder> socketAddress) {
            return this.socketAddress((SocketAddress)((SocketAddress.Builder)SocketAddress.builder().applyMutation(socketAddress)).build());
        }
    }
}

