/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.ContactStatus;
import software.amazon.awssdk.services.groundstation.model.DataflowDetail;
import software.amazon.awssdk.services.groundstation.model.DataflowListCopier;
import software.amazon.awssdk.services.groundstation.model.Elevation;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeContactResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, DescribeContactResponse> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactId").getter(DescribeContactResponse.getter(DescribeContactResponse::contactId)).setter(DescribeContactResponse.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactId").build()}).build();
    private static final SdkField<String> CONTACT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactStatus").getter(DescribeContactResponse.getter(DescribeContactResponse::contactStatusAsString)).setter(DescribeContactResponse.setter(Builder::contactStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactStatus").build()}).build();
    private static final SdkField<List<DataflowDetail>> DATAFLOW_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataflowList").getter(DescribeContactResponse.getter(DescribeContactResponse::dataflowList)).setter(DescribeContactResponse.setter(Builder::dataflowList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataflowDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(DescribeContactResponse.getter(DescribeContactResponse::endTime)).setter(DescribeContactResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(DescribeContactResponse.getter(DescribeContactResponse::errorMessage)).setter(DescribeContactResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groundStation").getter(DescribeContactResponse.getter(DescribeContactResponse::groundStation)).setter(DescribeContactResponse.setter(Builder::groundStation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()}).build();
    private static final SdkField<Elevation> MAXIMUM_ELEVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maximumElevation").getter(DescribeContactResponse.getter(DescribeContactResponse::maximumElevation)).setter(DescribeContactResponse.setter(Builder::maximumElevation)).constructor(Elevation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumElevation").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileArn").getter(DescribeContactResponse.getter(DescribeContactResponse::missionProfileArn)).setter(DescribeContactResponse.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<Instant> POST_PASS_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("postPassEndTime").getter(DescribeContactResponse.getter(DescribeContactResponse::postPassEndTime)).setter(DescribeContactResponse.setter(Builder::postPassEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postPassEndTime").build()}).build();
    private static final SdkField<Instant> PRE_PASS_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("prePassStartTime").getter(DescribeContactResponse.getter(DescribeContactResponse::prePassStartTime)).setter(DescribeContactResponse.setter(Builder::prePassStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prePassStartTime").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(DescribeContactResponse.getter(DescribeContactResponse::region)).setter(DescribeContactResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteArn").getter(DescribeContactResponse.getter(DescribeContactResponse::satelliteArn)).setter(DescribeContactResponse.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(DescribeContactResponse.getter(DescribeContactResponse::startTime)).setter(DescribeContactResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeContactResponse.getter(DescribeContactResponse::tags)).setter(DescribeContactResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> VISIBILITY_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("visibilityEndTime").getter(DescribeContactResponse.getter(DescribeContactResponse::visibilityEndTime)).setter(DescribeContactResponse.setter(Builder::visibilityEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityEndTime").build()}).build();
    private static final SdkField<Instant> VISIBILITY_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("visibilityStartTime").getter(DescribeContactResponse.getter(DescribeContactResponse::visibilityStartTime)).setter(DescribeContactResponse.setter(Builder::visibilityStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, CONTACT_STATUS_FIELD, DATAFLOW_LIST_FIELD, END_TIME_FIELD, ERROR_MESSAGE_FIELD, GROUND_STATION_FIELD, MAXIMUM_ELEVATION_FIELD, MISSION_PROFILE_ARN_FIELD, POST_PASS_END_TIME_FIELD, PRE_PASS_START_TIME_FIELD, REGION_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, TAGS_FIELD, VISIBILITY_END_TIME_FIELD, VISIBILITY_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeContactResponse.memberNameToFieldInitializer();
    private final String contactId;
    private final String contactStatus;
    private final List<DataflowDetail> dataflowList;
    private final Instant endTime;
    private final String errorMessage;
    private final String groundStation;
    private final Elevation maximumElevation;
    private final String missionProfileArn;
    private final Instant postPassEndTime;
    private final Instant prePassStartTime;
    private final String region;
    private final String satelliteArn;
    private final Instant startTime;
    private final Map<String, String> tags;
    private final Instant visibilityEndTime;
    private final Instant visibilityStartTime;

    private DescribeContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.contactStatus = builder.contactStatus;
        this.dataflowList = builder.dataflowList;
        this.endTime = builder.endTime;
        this.errorMessage = builder.errorMessage;
        this.groundStation = builder.groundStation;
        this.maximumElevation = builder.maximumElevation;
        this.missionProfileArn = builder.missionProfileArn;
        this.postPassEndTime = builder.postPassEndTime;
        this.prePassStartTime = builder.prePassStartTime;
        this.region = builder.region;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.tags = builder.tags;
        this.visibilityEndTime = builder.visibilityEndTime;
        this.visibilityStartTime = builder.visibilityStartTime;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final ContactStatus contactStatus() {
        return ContactStatus.fromValue(this.contactStatus);
    }

    public final String contactStatusAsString() {
        return this.contactStatus;
    }

    public final boolean hasDataflowList() {
        return this.dataflowList != null && !(this.dataflowList instanceof SdkAutoConstructList);
    }

    public final List<DataflowDetail> dataflowList() {
        return this.dataflowList;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String groundStation() {
        return this.groundStation;
    }

    public final Elevation maximumElevation() {
        return this.maximumElevation;
    }

    public final String missionProfileArn() {
        return this.missionProfileArn;
    }

    public final Instant postPassEndTime() {
        return this.postPassEndTime;
    }

    public final Instant prePassStartTime() {
        return this.prePassStartTime;
    }

    public final String region() {
        return this.region;
    }

    public final String satelliteArn() {
        return this.satelliteArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant visibilityEndTime() {
        return this.visibilityEndTime;
    }

    public final Instant visibilityStartTime() {
        return this.visibilityStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataflowList() ? this.dataflowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumElevation());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.postPassEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.prePassStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContactResponse)) {
            return false;
        }
        DescribeContactResponse other = (DescribeContactResponse)((Object)obj);
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.contactStatusAsString(), other.contactStatusAsString()) && this.hasDataflowList() == other.hasDataflowList() && Objects.equals(this.dataflowList(), other.dataflowList()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.groundStation(), other.groundStation()) && Objects.equals(this.maximumElevation(), other.maximumElevation()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.postPassEndTime(), other.postPassEndTime()) && Objects.equals(this.prePassStartTime(), other.prePassStartTime()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.startTime(), other.startTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.visibilityEndTime(), other.visibilityEndTime()) && Objects.equals(this.visibilityStartTime(), other.visibilityStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeContactResponse").add("ContactId", (Object)this.contactId()).add("ContactStatus", (Object)this.contactStatusAsString()).add("DataflowList", this.hasDataflowList() ? this.dataflowList() : null).add("EndTime", (Object)this.endTime()).add("ErrorMessage", (Object)this.errorMessage()).add("GroundStation", (Object)this.groundStation()).add("MaximumElevation", (Object)this.maximumElevation()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("PostPassEndTime", (Object)this.postPassEndTime()).add("PrePassStartTime", (Object)this.prePassStartTime()).add("Region", (Object)this.region()).add("SatelliteArn", (Object)this.satelliteArn()).add("StartTime", (Object)this.startTime()).add("Tags", this.hasTags() ? this.tags() : null).add("VisibilityEndTime", (Object)this.visibilityEndTime()).add("VisibilityStartTime", (Object)this.visibilityStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "contactStatus": {
                return Optional.ofNullable(clazz.cast(this.contactStatusAsString()));
            }
            case "dataflowList": {
                return Optional.ofNullable(clazz.cast(this.dataflowList()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "groundStation": {
                return Optional.ofNullable(clazz.cast(this.groundStation()));
            }
            case "maximumElevation": {
                return Optional.ofNullable(clazz.cast(this.maximumElevation()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "postPassEndTime": {
                return Optional.ofNullable(clazz.cast(this.postPassEndTime()));
            }
            case "prePassStartTime": {
                return Optional.ofNullable(clazz.cast(this.prePassStartTime()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "visibilityEndTime": {
                return Optional.ofNullable(clazz.cast(this.visibilityEndTime()));
            }
            case "visibilityStartTime": {
                return Optional.ofNullable(clazz.cast(this.visibilityStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contactId", CONTACT_ID_FIELD);
        map.put("contactStatus", CONTACT_STATUS_FIELD);
        map.put("dataflowList", DATAFLOW_LIST_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("groundStation", GROUND_STATION_FIELD);
        map.put("maximumElevation", MAXIMUM_ELEVATION_FIELD);
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("postPassEndTime", POST_PASS_END_TIME_FIELD);
        map.put("prePassStartTime", PRE_PASS_START_TIME_FIELD);
        map.put("region", REGION_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("visibilityEndTime", VISIBILITY_END_TIME_FIELD);
        map.put("visibilityStartTime", VISIBILITY_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeContactResponse, T> g) {
        return obj -> g.apply((DescribeContactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String contactId;
        private String contactStatus;
        private List<DataflowDetail> dataflowList = DefaultSdkAutoConstructList.getInstance();
        private Instant endTime;
        private String errorMessage;
        private String groundStation;
        private Elevation maximumElevation;
        private String missionProfileArn;
        private Instant postPassEndTime;
        private Instant prePassStartTime;
        private String region;
        private String satelliteArn;
        private Instant startTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant visibilityEndTime;
        private Instant visibilityStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContactResponse model) {
            super(model);
            this.contactId(model.contactId);
            this.contactStatus(model.contactStatus);
            this.dataflowList(model.dataflowList);
            this.endTime(model.endTime);
            this.errorMessage(model.errorMessage);
            this.groundStation(model.groundStation);
            this.maximumElevation(model.maximumElevation);
            this.missionProfileArn(model.missionProfileArn);
            this.postPassEndTime(model.postPassEndTime);
            this.prePassStartTime(model.prePassStartTime);
            this.region(model.region);
            this.satelliteArn(model.satelliteArn);
            this.startTime(model.startTime);
            this.tags(model.tags);
            this.visibilityEndTime(model.visibilityEndTime);
            this.visibilityStartTime(model.visibilityStartTime);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getContactStatus() {
            return this.contactStatus;
        }

        public final void setContactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
        }

        @Override
        public final Builder contactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
            return this;
        }

        @Override
        public final Builder contactStatus(ContactStatus contactStatus) {
            this.contactStatus(contactStatus == null ? null : contactStatus.toString());
            return this;
        }

        public final List<DataflowDetail.Builder> getDataflowList() {
            List<DataflowDetail.Builder> result = DataflowListCopier.copyToBuilder(this.dataflowList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataflowList(Collection<DataflowDetail.BuilderImpl> dataflowList) {
            this.dataflowList = DataflowListCopier.copyFromBuilder(dataflowList);
        }

        @Override
        public final Builder dataflowList(Collection<DataflowDetail> dataflowList) {
            this.dataflowList = DataflowListCopier.copy(dataflowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowList(DataflowDetail ... dataflowList) {
            this.dataflowList(Arrays.asList(dataflowList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowList(Consumer<DataflowDetail.Builder> ... dataflowList) {
            this.dataflowList(Stream.of(dataflowList).map(c -> (DataflowDetail)((DataflowDetail.Builder)DataflowDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getGroundStation() {
            return this.groundStation;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final Elevation.Builder getMaximumElevation() {
            return this.maximumElevation != null ? this.maximumElevation.toBuilder() : null;
        }

        public final void setMaximumElevation(Elevation.BuilderImpl maximumElevation) {
            this.maximumElevation = maximumElevation != null ? maximumElevation.build() : null;
        }

        @Override
        public final Builder maximumElevation(Elevation maximumElevation) {
            this.maximumElevation = maximumElevation;
            return this;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final Instant getPostPassEndTime() {
            return this.postPassEndTime;
        }

        public final void setPostPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
        }

        @Override
        public final Builder postPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
            return this;
        }

        public final Instant getPrePassStartTime() {
            return this.prePassStartTime;
        }

        public final void setPrePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
        }

        @Override
        public final Builder prePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Instant getVisibilityEndTime() {
            return this.visibilityEndTime;
        }

        public final void setVisibilityEndTime(Instant visibilityEndTime) {
            this.visibilityEndTime = visibilityEndTime;
        }

        @Override
        public final Builder visibilityEndTime(Instant visibilityEndTime) {
            this.visibilityEndTime = visibilityEndTime;
            return this;
        }

        public final Instant getVisibilityStartTime() {
            return this.visibilityStartTime;
        }

        public final void setVisibilityStartTime(Instant visibilityStartTime) {
            this.visibilityStartTime = visibilityStartTime;
        }

        @Override
        public final Builder visibilityStartTime(Instant visibilityStartTime) {
            this.visibilityStartTime = visibilityStartTime;
            return this;
        }

        @Override
        public DescribeContactResponse build() {
            return new DescribeContactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeContactResponse> {
        public Builder contactId(String var1);

        public Builder contactStatus(String var1);

        public Builder contactStatus(ContactStatus var1);

        public Builder dataflowList(Collection<DataflowDetail> var1);

        public Builder dataflowList(DataflowDetail ... var1);

        public Builder dataflowList(Consumer<DataflowDetail.Builder> ... var1);

        public Builder endTime(Instant var1);

        public Builder errorMessage(String var1);

        public Builder groundStation(String var1);

        public Builder maximumElevation(Elevation var1);

        default public Builder maximumElevation(Consumer<Elevation.Builder> maximumElevation) {
            return this.maximumElevation((Elevation)((Elevation.Builder)Elevation.builder().applyMutation(maximumElevation)).build());
        }

        public Builder missionProfileArn(String var1);

        public Builder postPassEndTime(Instant var1);

        public Builder prePassStartTime(Instant var1);

        public Builder region(String var1);

        public Builder satelliteArn(String var1);

        public Builder startTime(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder visibilityEndTime(Instant var1);

        public Builder visibilityStartTime(Instant var1);
    }
}

