/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a dataflow endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataflowEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<DataflowEndpoint.Builder, DataflowEndpoint> {
    private static final SdkField<SocketAddress> ADDRESS_FIELD = SdkField.<SocketAddress> builder(MarshallingType.SDK_POJO)
            .memberName("address").getter(getter(DataflowEndpoint::address)).setter(setter(Builder::address))
            .constructor(SocketAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()).build();

    private static final SdkField<Integer> MTU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("mtu")
            .getter(getter(DataflowEndpoint::mtu)).setter(setter(Builder::mtu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataflowEndpoint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataflowEndpoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, MTU_FIELD,
            NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SocketAddress address;

    private final Integer mtu;

    private final String name;

    private final String status;

    private DataflowEndpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.mtu = builder.mtu;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * Socket address of a dataflow endpoint.
     * </p>
     * 
     * @return Socket address of a dataflow endpoint.
     */
    public final SocketAddress address() {
        return address;
    }

    /**
     * <p>
     * Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
     * </p>
     * 
     * @return Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
     */
    public final Integer mtu() {
        return mtu;
    }

    /**
     * <p>
     * Name of a dataflow endpoint.
     * </p>
     * 
     * @return Name of a dataflow endpoint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Status of a dataflow endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of a dataflow endpoint.
     * @see EndpointStatus
     */
    public final EndpointStatus status() {
        return EndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of a dataflow endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of a dataflow endpoint.
     * @see EndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(mtu());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataflowEndpoint)) {
            return false;
        }
        DataflowEndpoint other = (DataflowEndpoint) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(mtu(), other.mtu())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataflowEndpoint").add("Address", address()).add("Mtu", mtu()).add("Name", name())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "address":
            return Optional.ofNullable(clazz.cast(address()));
        case "mtu":
            return Optional.ofNullable(clazz.cast(mtu()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("address", ADDRESS_FIELD);
        map.put("mtu", MTU_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataflowEndpoint, T> g) {
        return obj -> g.apply((DataflowEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataflowEndpoint> {
        /**
         * <p>
         * Socket address of a dataflow endpoint.
         * </p>
         * 
         * @param address
         *        Socket address of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(SocketAddress address);

        /**
         * <p>
         * Socket address of a dataflow endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link SocketAddress.Builder} avoiding the need
         * to create one manually via {@link SocketAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SocketAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #address(SocketAddress)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link SocketAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(SocketAddress)
         */
        default Builder address(Consumer<SocketAddress.Builder> address) {
            return address(SocketAddress.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
         * </p>
         * 
         * @param mtu
         *        Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mtu(Integer mtu);

        /**
         * <p>
         * Name of a dataflow endpoint.
         * </p>
         * 
         * @param name
         *        Name of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Status of a dataflow endpoint.
         * </p>
         * 
         * @param status
         *        Status of a dataflow endpoint.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of a dataflow endpoint.
         * </p>
         * 
         * @param status
         *        Status of a dataflow endpoint.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(EndpointStatus status);
    }

    static final class BuilderImpl implements Builder {
        private SocketAddress address;

        private Integer mtu;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataflowEndpoint model) {
            address(model.address);
            mtu(model.mtu);
            name(model.name);
            status(model.status);
        }

        public final SocketAddress.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(SocketAddress.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(SocketAddress address) {
            this.address = address;
            return this;
        }

        public final Integer getMtu() {
            return mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DataflowEndpoint build() {
            return new DataflowEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
