/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContactResponse extends GroundStationResponse implements
        ToCopyableBuilder<DescribeContactResponse.Builder, DescribeContactResponse> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactId").getter(getter(DescribeContactResponse::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactId").build()).build();

    private static final SdkField<String> CONTACT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactStatus").getter(getter(DescribeContactResponse::contactStatusAsString))
            .setter(setter(Builder::contactStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactStatus").build()).build();

    private static final SdkField<List<DataflowDetail>> DATAFLOW_LIST_FIELD = SdkField
            .<List<DataflowDetail>> builder(MarshallingType.LIST)
            .memberName("dataflowList")
            .getter(getter(DescribeContactResponse::dataflowList))
            .setter(setter(Builder::dataflowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataflowDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataflowDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(DescribeContactResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(DescribeContactResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groundStation").getter(getter(DescribeContactResponse::groundStation))
            .setter(setter(Builder::groundStation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()).build();

    private static final SdkField<Elevation> MAXIMUM_ELEVATION_FIELD = SdkField.<Elevation> builder(MarshallingType.SDK_POJO)
            .memberName("maximumElevation").getter(getter(DescribeContactResponse::maximumElevation))
            .setter(setter(Builder::maximumElevation)).constructor(Elevation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumElevation").build()).build();

    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("missionProfileArn").getter(getter(DescribeContactResponse::missionProfileArn))
            .setter(setter(Builder::missionProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()).build();

    private static final SdkField<Instant> POST_PASS_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("postPassEndTime").getter(getter(DescribeContactResponse::postPassEndTime))
            .setter(setter(Builder::postPassEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postPassEndTime").build()).build();

    private static final SdkField<Instant> PRE_PASS_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("prePassStartTime").getter(getter(DescribeContactResponse::prePassStartTime))
            .setter(setter(Builder::prePassStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prePassStartTime").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(DescribeContactResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("satelliteArn").getter(getter(DescribeContactResponse::satelliteArn))
            .setter(setter(Builder::satelliteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DescribeContactResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeContactResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> VISIBILITY_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("visibilityEndTime").getter(getter(DescribeContactResponse::visibilityEndTime))
            .setter(setter(Builder::visibilityEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityEndTime").build()).build();

    private static final SdkField<Instant> VISIBILITY_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("visibilityStartTime").getter(getter(DescribeContactResponse::visibilityStartTime))
            .setter(setter(Builder::visibilityStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            CONTACT_STATUS_FIELD, DATAFLOW_LIST_FIELD, END_TIME_FIELD, ERROR_MESSAGE_FIELD, GROUND_STATION_FIELD,
            MAXIMUM_ELEVATION_FIELD, MISSION_PROFILE_ARN_FIELD, POST_PASS_END_TIME_FIELD, PRE_PASS_START_TIME_FIELD,
            REGION_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, TAGS_FIELD, VISIBILITY_END_TIME_FIELD,
            VISIBILITY_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactId;

    private final String contactStatus;

    private final List<DataflowDetail> dataflowList;

    private final Instant endTime;

    private final String errorMessage;

    private final String groundStation;

    private final Elevation maximumElevation;

    private final String missionProfileArn;

    private final Instant postPassEndTime;

    private final Instant prePassStartTime;

    private final String region;

    private final String satelliteArn;

    private final Instant startTime;

    private final Map<String, String> tags;

    private final Instant visibilityEndTime;

    private final Instant visibilityStartTime;

    private DescribeContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.contactStatus = builder.contactStatus;
        this.dataflowList = builder.dataflowList;
        this.endTime = builder.endTime;
        this.errorMessage = builder.errorMessage;
        this.groundStation = builder.groundStation;
        this.maximumElevation = builder.maximumElevation;
        this.missionProfileArn = builder.missionProfileArn;
        this.postPassEndTime = builder.postPassEndTime;
        this.prePassStartTime = builder.prePassStartTime;
        this.region = builder.region;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.tags = builder.tags;
        this.visibilityEndTime = builder.visibilityEndTime;
        this.visibilityStartTime = builder.visibilityStartTime;
    }

    /**
     * <p>
     * UUID of a contact.
     * </p>
     * 
     * @return UUID of a contact.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * Status of a contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactStatus}
     * will return {@link ContactStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contactStatusAsString}.
     * </p>
     * 
     * @return Status of a contact.
     * @see ContactStatus
     */
    public final ContactStatus contactStatus() {
        return ContactStatus.fromValue(contactStatus);
    }

    /**
     * <p>
     * Status of a contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactStatus}
     * will return {@link ContactStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contactStatusAsString}.
     * </p>
     * 
     * @return Status of a contact.
     * @see ContactStatus
     */
    public final String contactStatusAsString() {
        return contactStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataflowList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataflowList() {
        return dataflowList != null && !(dataflowList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List describing source and destination details for each dataflow edge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataflowList} method.
     * </p>
     * 
     * @return List describing source and destination details for each dataflow edge.
     */
    public final List<DataflowDetail> dataflowList() {
        return dataflowList;
    }

    /**
     * <p>
     * End time of a contact in UTC.
     * </p>
     * 
     * @return End time of a contact in UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Error message for a contact.
     * </p>
     * 
     * @return Error message for a contact.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Ground station for a contact.
     * </p>
     * 
     * @return Ground station for a contact.
     */
    public final String groundStation() {
        return groundStation;
    }

    /**
     * <p>
     * Maximum elevation angle of a contact.
     * </p>
     * 
     * @return Maximum elevation angle of a contact.
     */
    public final Elevation maximumElevation() {
        return maximumElevation;
    }

    /**
     * <p>
     * ARN of a mission profile.
     * </p>
     * 
     * @return ARN of a mission profile.
     */
    public final String missionProfileArn() {
        return missionProfileArn;
    }

    /**
     * <p>
     * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     * finished.
     * </p>
     * 
     * @return Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     *         finished.
     */
    public final Instant postPassEndTime() {
        return postPassEndTime;
    }

    /**
     * <p>
     * Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.
     * </p>
     * 
     * @return Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming
     *         pass.
     */
    public final Instant prePassStartTime() {
        return prePassStartTime;
    }

    /**
     * <p>
     * Region of a contact.
     * </p>
     * 
     * @return Region of a contact.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * ARN of a satellite.
     * </p>
     * 
     * @return ARN of a satellite.
     */
    public final String satelliteArn() {
        return satelliteArn;
    }

    /**
     * <p>
     * Start time of a contact in UTC.
     * </p>
     * 
     * @return Start time of a contact in UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to a contact.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Projected time in UTC your satellite will set below the <a
     * href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is based
     * on the satellite's current active ephemeris for future contacts and the ephemeris that was active during contact
     * execution for completed contacts.
     * </p>
     * 
     * @return Projected time in UTC your satellite will set below the <a
     *         href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time
     *         is based on the satellite's current active ephemeris for future contacts and the ephemeris that was
     *         active during contact execution for completed contacts.
     */
    public final Instant visibilityEndTime() {
        return visibilityEndTime;
    }

    /**
     * <p>
     * Projected time in UTC your satellite will rise above the <a
     * href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is based
     * on the satellite's current active ephemeris for future contacts and the ephemeris that was active during contact
     * execution for completed contacts.
     * </p>
     * 
     * @return Projected time in UTC your satellite will rise above the <a
     *         href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time
     *         is based on the satellite's current active ephemeris for future contacts and the ephemeris that was
     *         active during contact execution for completed contacts.
     */
    public final Instant visibilityStartTime() {
        return visibilityStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(contactStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataflowList() ? dataflowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(maximumElevation());
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(postPassEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(prePassStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visibilityEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContactResponse)) {
            return false;
        }
        DescribeContactResponse other = (DescribeContactResponse) obj;
        return Objects.equals(contactId(), other.contactId())
                && Objects.equals(contactStatusAsString(), other.contactStatusAsString())
                && hasDataflowList() == other.hasDataflowList() && Objects.equals(dataflowList(), other.dataflowList())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(groundStation(), other.groundStation())
                && Objects.equals(maximumElevation(), other.maximumElevation())
                && Objects.equals(missionProfileArn(), other.missionProfileArn())
                && Objects.equals(postPassEndTime(), other.postPassEndTime())
                && Objects.equals(prePassStartTime(), other.prePassStartTime()) && Objects.equals(region(), other.region())
                && Objects.equals(satelliteArn(), other.satelliteArn()) && Objects.equals(startTime(), other.startTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(visibilityEndTime(), other.visibilityEndTime())
                && Objects.equals(visibilityStartTime(), other.visibilityStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeContactResponse").add("ContactId", contactId())
                .add("ContactStatus", contactStatusAsString()).add("DataflowList", hasDataflowList() ? dataflowList() : null)
                .add("EndTime", endTime()).add("ErrorMessage", errorMessage()).add("GroundStation", groundStation())
                .add("MaximumElevation", maximumElevation()).add("MissionProfileArn", missionProfileArn())
                .add("PostPassEndTime", postPassEndTime()).add("PrePassStartTime", prePassStartTime()).add("Region", region())
                .add("SatelliteArn", satelliteArn()).add("StartTime", startTime()).add("Tags", hasTags() ? tags() : null)
                .add("VisibilityEndTime", visibilityEndTime()).add("VisibilityStartTime", visibilityStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "contactStatus":
            return Optional.ofNullable(clazz.cast(contactStatusAsString()));
        case "dataflowList":
            return Optional.ofNullable(clazz.cast(dataflowList()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "groundStation":
            return Optional.ofNullable(clazz.cast(groundStation()));
        case "maximumElevation":
            return Optional.ofNullable(clazz.cast(maximumElevation()));
        case "missionProfileArn":
            return Optional.ofNullable(clazz.cast(missionProfileArn()));
        case "postPassEndTime":
            return Optional.ofNullable(clazz.cast(postPassEndTime()));
        case "prePassStartTime":
            return Optional.ofNullable(clazz.cast(prePassStartTime()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "satelliteArn":
            return Optional.ofNullable(clazz.cast(satelliteArn()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "visibilityEndTime":
            return Optional.ofNullable(clazz.cast(visibilityEndTime()));
        case "visibilityStartTime":
            return Optional.ofNullable(clazz.cast(visibilityStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contactId", CONTACT_ID_FIELD);
        map.put("contactStatus", CONTACT_STATUS_FIELD);
        map.put("dataflowList", DATAFLOW_LIST_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("groundStation", GROUND_STATION_FIELD);
        map.put("maximumElevation", MAXIMUM_ELEVATION_FIELD);
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("postPassEndTime", POST_PASS_END_TIME_FIELD);
        map.put("prePassStartTime", PRE_PASS_START_TIME_FIELD);
        map.put("region", REGION_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("visibilityEndTime", VISIBILITY_END_TIME_FIELD);
        map.put("visibilityStartTime", VISIBILITY_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeContactResponse, T> g) {
        return obj -> g.apply((DescribeContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeContactResponse> {
        /**
         * <p>
         * UUID of a contact.
         * </p>
         * 
         * @param contactId
         *        UUID of a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * Status of a contact.
         * </p>
         * 
         * @param contactStatus
         *        Status of a contact.
         * @see ContactStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactStatus
         */
        Builder contactStatus(String contactStatus);

        /**
         * <p>
         * Status of a contact.
         * </p>
         * 
         * @param contactStatus
         *        Status of a contact.
         * @see ContactStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactStatus
         */
        Builder contactStatus(ContactStatus contactStatus);

        /**
         * <p>
         * List describing source and destination details for each dataflow edge.
         * </p>
         * 
         * @param dataflowList
         *        List describing source and destination details for each dataflow edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowList(Collection<DataflowDetail> dataflowList);

        /**
         * <p>
         * List describing source and destination details for each dataflow edge.
         * </p>
         * 
         * @param dataflowList
         *        List describing source and destination details for each dataflow edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowList(DataflowDetail... dataflowList);

        /**
         * <p>
         * List describing source and destination details for each dataflow edge.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.DataflowDetail.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.groundstation.model.DataflowDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.DataflowDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #dataflowList(List<DataflowDetail>)}.
         * 
         * @param dataflowList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.DataflowDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataflowList(java.util.Collection<DataflowDetail>)
         */
        Builder dataflowList(Consumer<DataflowDetail.Builder>... dataflowList);

        /**
         * <p>
         * End time of a contact in UTC.
         * </p>
         * 
         * @param endTime
         *        End time of a contact in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Error message for a contact.
         * </p>
         * 
         * @param errorMessage
         *        Error message for a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Ground station for a contact.
         * </p>
         * 
         * @param groundStation
         *        Ground station for a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStation(String groundStation);

        /**
         * <p>
         * Maximum elevation angle of a contact.
         * </p>
         * 
         * @param maximumElevation
         *        Maximum elevation angle of a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumElevation(Elevation maximumElevation);

        /**
         * <p>
         * Maximum elevation angle of a contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link Elevation.Builder} avoiding the need to
         * create one manually via {@link Elevation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Elevation.Builder#build()} is called immediately and its result
         * is passed to {@link #maximumElevation(Elevation)}.
         * 
         * @param maximumElevation
         *        a consumer that will call methods on {@link Elevation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumElevation(Elevation)
         */
        default Builder maximumElevation(Consumer<Elevation.Builder> maximumElevation) {
            return maximumElevation(Elevation.builder().applyMutation(maximumElevation).build());
        }

        /**
         * <p>
         * ARN of a mission profile.
         * </p>
         * 
         * @param missionProfileArn
         *        ARN of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileArn(String missionProfileArn);

        /**
         * <p>
         * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
         * finished.
         * </p>
         * 
         * @param postPassEndTime
         *        Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass
         *        has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postPassEndTime(Instant postPassEndTime);

        /**
         * <p>
         * Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.
         * </p>
         * 
         * @param prePassStartTime
         *        Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming
         *        pass.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prePassStartTime(Instant prePassStartTime);

        /**
         * <p>
         * Region of a contact.
         * </p>
         * 
         * @param region
         *        Region of a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * ARN of a satellite.
         * </p>
         * 
         * @param satelliteArn
         *        ARN of a satellite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteArn(String satelliteArn);

        /**
         * <p>
         * Start time of a contact in UTC.
         * </p>
         * 
         * @param startTime
         *        Start time of a contact in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Tags assigned to a contact.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Projected time in UTC your satellite will set below the <a
         * href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is
         * based on the satellite's current active ephemeris for future contacts and the ephemeris that was active
         * during contact execution for completed contacts.
         * </p>
         * 
         * @param visibilityEndTime
         *        Projected time in UTC your satellite will set below the <a
         *        href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This
         *        time is based on the satellite's current active ephemeris for future contacts and the ephemeris that
         *        was active during contact execution for completed contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityEndTime(Instant visibilityEndTime);

        /**
         * <p>
         * Projected time in UTC your satellite will rise above the <a
         * href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is
         * based on the satellite's current active ephemeris for future contacts and the ephemeris that was active
         * during contact execution for completed contacts.
         * </p>
         * 
         * @param visibilityStartTime
         *        Projected time in UTC your satellite will rise above the <a
         *        href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This
         *        time is based on the satellite's current active ephemeris for future contacts and the ephemeris that
         *        was active during contact execution for completed contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityStartTime(Instant visibilityStartTime);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String contactId;

        private String contactStatus;

        private List<DataflowDetail> dataflowList = DefaultSdkAutoConstructList.getInstance();

        private Instant endTime;

        private String errorMessage;

        private String groundStation;

        private Elevation maximumElevation;

        private String missionProfileArn;

        private Instant postPassEndTime;

        private Instant prePassStartTime;

        private String region;

        private String satelliteArn;

        private Instant startTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant visibilityEndTime;

        private Instant visibilityStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContactResponse model) {
            super(model);
            contactId(model.contactId);
            contactStatus(model.contactStatus);
            dataflowList(model.dataflowList);
            endTime(model.endTime);
            errorMessage(model.errorMessage);
            groundStation(model.groundStation);
            maximumElevation(model.maximumElevation);
            missionProfileArn(model.missionProfileArn);
            postPassEndTime(model.postPassEndTime);
            prePassStartTime(model.prePassStartTime);
            region(model.region);
            satelliteArn(model.satelliteArn);
            startTime(model.startTime);
            tags(model.tags);
            visibilityEndTime(model.visibilityEndTime);
            visibilityStartTime(model.visibilityStartTime);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getContactStatus() {
            return contactStatus;
        }

        public final void setContactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
        }

        @Override
        public final Builder contactStatus(String contactStatus) {
            this.contactStatus = contactStatus;
            return this;
        }

        @Override
        public final Builder contactStatus(ContactStatus contactStatus) {
            this.contactStatus(contactStatus == null ? null : contactStatus.toString());
            return this;
        }

        public final List<DataflowDetail.Builder> getDataflowList() {
            List<DataflowDetail.Builder> result = DataflowListCopier.copyToBuilder(this.dataflowList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataflowList(Collection<DataflowDetail.BuilderImpl> dataflowList) {
            this.dataflowList = DataflowListCopier.copyFromBuilder(dataflowList);
        }

        @Override
        public final Builder dataflowList(Collection<DataflowDetail> dataflowList) {
            this.dataflowList = DataflowListCopier.copy(dataflowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowList(DataflowDetail... dataflowList) {
            dataflowList(Arrays.asList(dataflowList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowList(Consumer<DataflowDetail.Builder>... dataflowList) {
            dataflowList(Stream.of(dataflowList).map(c -> DataflowDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getGroundStation() {
            return groundStation;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final Elevation.Builder getMaximumElevation() {
            return maximumElevation != null ? maximumElevation.toBuilder() : null;
        }

        public final void setMaximumElevation(Elevation.BuilderImpl maximumElevation) {
            this.maximumElevation = maximumElevation != null ? maximumElevation.build() : null;
        }

        @Override
        public final Builder maximumElevation(Elevation maximumElevation) {
            this.maximumElevation = maximumElevation;
            return this;
        }

        public final String getMissionProfileArn() {
            return missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final Instant getPostPassEndTime() {
            return postPassEndTime;
        }

        public final void setPostPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
        }

        @Override
        public final Builder postPassEndTime(Instant postPassEndTime) {
            this.postPassEndTime = postPassEndTime;
            return this;
        }

        public final Instant getPrePassStartTime() {
            return prePassStartTime;
        }

        public final void setPrePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
        }

        @Override
        public final Builder prePassStartTime(Instant prePassStartTime) {
            this.prePassStartTime = prePassStartTime;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getSatelliteArn() {
            return satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Instant getVisibilityEndTime() {
            return visibilityEndTime;
        }

        public final void setVisibilityEndTime(Instant visibilityEndTime) {
            this.visibilityEndTime = visibilityEndTime;
        }

        @Override
        public final Builder visibilityEndTime(Instant visibilityEndTime) {
            this.visibilityEndTime = visibilityEndTime;
            return this;
        }

        public final Instant getVisibilityStartTime() {
            return visibilityStartTime;
        }

        public final void setVisibilityStartTime(Instant visibilityStartTime) {
            this.visibilityStartTime = visibilityStartTime;
        }

        @Override
        public final Builder visibilityStartTime(Instant visibilityStartTime) {
            this.visibilityStartTime = visibilityStartTime;
            return this;
        }

        @Override
        public DescribeContactResponse build() {
            return new DescribeContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
