/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEphemerisResponse extends GroundStationResponse implements
        ToCopyableBuilder<DescribeEphemerisResponse.Builder, DescribeEphemerisResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DescribeEphemerisResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(DescribeEphemerisResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisId").getter(getter(DescribeEphemerisResponse::ephemerisId))
            .setter(setter(Builder::ephemerisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()).build();

    private static final SdkField<String> INVALID_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invalidReason").getter(getter(DescribeEphemerisResponse::invalidReasonAsString))
            .setter(setter(Builder::invalidReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidReason").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeEphemerisResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(DescribeEphemerisResponse::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("satelliteId").getter(getter(DescribeEphemerisResponse::satelliteId))
            .setter(setter(Builder::satelliteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeEphemerisResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<EphemerisTypeDescription> SUPPLIED_DATA_FIELD = SdkField
            .<EphemerisTypeDescription> builder(MarshallingType.SDK_POJO).memberName("suppliedData")
            .getter(getter(DescribeEphemerisResponse::suppliedData)).setter(setter(Builder::suppliedData))
            .constructor(EphemerisTypeDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppliedData").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeEphemerisResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            ENABLED_FIELD, EPHEMERIS_ID_FIELD, INVALID_REASON_FIELD, NAME_FIELD, PRIORITY_FIELD, SATELLITE_ID_FIELD,
            STATUS_FIELD, SUPPLIED_DATA_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant creationTime;

    private final Boolean enabled;

    private final String ephemerisId;

    private final String invalidReason;

    private final String name;

    private final Integer priority;

    private final String satelliteId;

    private final String status;

    private final EphemerisTypeDescription suppliedData;

    private final Map<String, String> tags;

    private DescribeEphemerisResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.enabled = builder.enabled;
        this.ephemerisId = builder.ephemerisId;
        this.invalidReason = builder.invalidReason;
        this.name = builder.name;
        this.priority = builder.priority;
        this.satelliteId = builder.satelliteId;
        this.status = builder.status;
        this.suppliedData = builder.suppliedData;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The time the ephemeris was uploaded in UTC.
     * </p>
     * 
     * @return The time the ephemeris was uploaded in UTC.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Whether or not the ephemeris is enabled.
     * </p>
     * 
     * @return Whether or not the ephemeris is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The AWS Ground Station ephemeris ID.
     * </p>
     * 
     * @return The AWS Ground Station ephemeris ID.
     */
    public final String ephemerisId() {
        return ephemerisId;
    }

    /**
     * <p>
     * Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invalidReason}
     * will return {@link EphemerisInvalidReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invalidReasonAsString}.
     * </p>
     * 
     * @return Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code>
     *         status.
     * @see EphemerisInvalidReason
     */
    public final EphemerisInvalidReason invalidReason() {
        return EphemerisInvalidReason.fromValue(invalidReason);
    }

    /**
     * <p>
     * Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invalidReason}
     * will return {@link EphemerisInvalidReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invalidReasonAsString}.
     * </p>
     * 
     * @return Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code>
     *         status.
     * @see EphemerisInvalidReason
     */
    public final String invalidReasonAsString() {
        return invalidReason;
    }

    /**
     * <p>
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     * </p>
     * 
     * @return A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
     * </p>
     * <p>
     * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     * </p>
     * <p>
     * Priority must be 1 or greater
     * </p>
     * 
     * @return Customer-provided priority score to establish the order in which overlapping ephemerides should be
     *         used.</p>
     *         <p>
     *         The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     *         </p>
     *         <p>
     *         Priority must be 1 or greater
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The AWS Ground Station satellite ID associated with ephemeris.
     * </p>
     * 
     * @return The AWS Ground Station satellite ID associated with ephemeris.
     */
    public final String satelliteId() {
        return satelliteId;
    }

    /**
     * <p>
     * The status of the ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EphemerisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ephemeris.
     * @see EphemerisStatus
     */
    public final EphemerisStatus status() {
        return EphemerisStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EphemerisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ephemeris.
     * @see EphemerisStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Supplied ephemeris data.
     * </p>
     * 
     * @return Supplied ephemeris data.
     */
    public final EphemerisTypeDescription suppliedData() {
        return suppliedData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to an ephemeris.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to an ephemeris.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(invalidReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(suppliedData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEphemerisResponse)) {
            return false;
        }
        DescribeEphemerisResponse other = (DescribeEphemerisResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(ephemerisId(), other.ephemerisId())
                && Objects.equals(invalidReasonAsString(), other.invalidReasonAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority()) && Objects.equals(satelliteId(), other.satelliteId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(suppliedData(), other.suppliedData()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEphemerisResponse").add("CreationTime", creationTime()).add("Enabled", enabled())
                .add("EphemerisId", ephemerisId()).add("InvalidReason", invalidReasonAsString()).add("Name", name())
                .add("Priority", priority()).add("SatelliteId", satelliteId()).add("Status", statusAsString())
                .add("SuppliedData", suppliedData()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "ephemerisId":
            return Optional.ofNullable(clazz.cast(ephemerisId()));
        case "invalidReason":
            return Optional.ofNullable(clazz.cast(invalidReasonAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "satelliteId":
            return Optional.ofNullable(clazz.cast(satelliteId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "suppliedData":
            return Optional.ofNullable(clazz.cast(suppliedData()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("ephemerisId", EPHEMERIS_ID_FIELD);
        map.put("invalidReason", INVALID_REASON_FIELD);
        map.put("name", NAME_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("satelliteId", SATELLITE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("suppliedData", SUPPLIED_DATA_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEphemerisResponse, T> g) {
        return obj -> g.apply((DescribeEphemerisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEphemerisResponse> {
        /**
         * <p>
         * The time the ephemeris was uploaded in UTC.
         * </p>
         * 
         * @param creationTime
         *        The time the ephemeris was uploaded in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Whether or not the ephemeris is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether or not the ephemeris is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The AWS Ground Station ephemeris ID.
         * </p>
         * 
         * @param ephemerisId
         *        The AWS Ground Station ephemeris ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerisId(String ephemerisId);

        /**
         * <p>
         * Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code> status.
         * </p>
         * 
         * @param invalidReason
         *        Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code>
         *        status.
         * @see EphemerisInvalidReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisInvalidReason
         */
        Builder invalidReason(String invalidReason);

        /**
         * <p>
         * Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code> status.
         * </p>
         * 
         * @param invalidReason
         *        Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code>
         *        status.
         * @see EphemerisInvalidReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisInvalidReason
         */
        Builder invalidReason(EphemerisInvalidReason invalidReason);

        /**
         * <p>
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         * </p>
         * 
         * @param name
         *        A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
         * </p>
         * <p>
         * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         * </p>
         * <p>
         * Priority must be 1 or greater
         * </p>
         * 
         * @param priority
         *        Customer-provided priority score to establish the order in which overlapping ephemerides should be
         *        used.</p>
         *        <p>
         *        The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         *        </p>
         *        <p>
         *        Priority must be 1 or greater
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The AWS Ground Station satellite ID associated with ephemeris.
         * </p>
         * 
         * @param satelliteId
         *        The AWS Ground Station satellite ID associated with ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteId(String satelliteId);

        /**
         * <p>
         * The status of the ephemeris.
         * </p>
         * 
         * @param status
         *        The status of the ephemeris.
         * @see EphemerisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ephemeris.
         * </p>
         * 
         * @param status
         *        The status of the ephemeris.
         * @see EphemerisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisStatus
         */
        Builder status(EphemerisStatus status);

        /**
         * <p>
         * Supplied ephemeris data.
         * </p>
         * 
         * @param suppliedData
         *        Supplied ephemeris data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppliedData(EphemerisTypeDescription suppliedData);

        /**
         * <p>
         * Supplied ephemeris data.
         * </p>
         * This is a convenience method that creates an instance of the {@link EphemerisTypeDescription.Builder}
         * avoiding the need to create one manually via {@link EphemerisTypeDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EphemerisTypeDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #suppliedData(EphemerisTypeDescription)}.
         * 
         * @param suppliedData
         *        a consumer that will call methods on {@link EphemerisTypeDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppliedData(EphemerisTypeDescription)
         */
        default Builder suppliedData(Consumer<EphemerisTypeDescription.Builder> suppliedData) {
            return suppliedData(EphemerisTypeDescription.builder().applyMutation(suppliedData).build());
        }

        /**
         * <p>
         * Tags assigned to an ephemeris.
         * </p>
         * 
         * @param tags
         *        Tags assigned to an ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private Boolean enabled;

        private String ephemerisId;

        private String invalidReason;

        private String name;

        private Integer priority;

        private String satelliteId;

        private String status;

        private EphemerisTypeDescription suppliedData;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEphemerisResponse model) {
            super(model);
            creationTime(model.creationTime);
            enabled(model.enabled);
            ephemerisId(model.ephemerisId);
            invalidReason(model.invalidReason);
            name(model.name);
            priority(model.priority);
            satelliteId(model.satelliteId);
            status(model.status);
            suppliedData(model.suppliedData);
            tags(model.tags);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEphemerisId() {
            return ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getInvalidReason() {
            return invalidReason;
        }

        public final void setInvalidReason(String invalidReason) {
            this.invalidReason = invalidReason;
        }

        @Override
        public final Builder invalidReason(String invalidReason) {
            this.invalidReason = invalidReason;
            return this;
        }

        @Override
        public final Builder invalidReason(EphemerisInvalidReason invalidReason) {
            this.invalidReason(invalidReason == null ? null : invalidReason.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getSatelliteId() {
            return satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EphemerisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final EphemerisTypeDescription.Builder getSuppliedData() {
            return suppliedData != null ? suppliedData.toBuilder() : null;
        }

        public final void setSuppliedData(EphemerisTypeDescription.BuilderImpl suppliedData) {
            this.suppliedData = suppliedData != null ? suppliedData.build() : null;
        }

        @Override
        public final Builder suppliedData(EphemerisTypeDescription suppliedData) {
            this.suppliedData = suppliedData;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeEphemerisResponse build() {
            return new DescribeEphemerisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
