/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that describes the frequency bandwidth.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrequencyBandwidth implements SdkPojo, Serializable,
        ToCopyableBuilder<FrequencyBandwidth.Builder, FrequencyBandwidth> {
    private static final SdkField<String> UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("units")
            .getter(getter(FrequencyBandwidth::unitsAsString)).setter(setter(Builder::units))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(FrequencyBandwidth::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNITS_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String units;

    private final Double value;

    private FrequencyBandwidth(BuilderImpl builder) {
        this.units = builder.units;
        this.value = builder.value;
    }

    /**
     * <p>
     * Frequency bandwidth units.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link BandwidthUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return Frequency bandwidth units.
     * @see BandwidthUnits
     */
    public final BandwidthUnits units() {
        return BandwidthUnits.fromValue(units);
    }

    /**
     * <p>
     * Frequency bandwidth units.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link BandwidthUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return Frequency bandwidth units.
     * @see BandwidthUnits
     */
    public final String unitsAsString() {
        return units;
    }

    /**
     * <p>
     * Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.
     *         </p>
     *         </li>
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrequencyBandwidth)) {
            return false;
        }
        FrequencyBandwidth other = (FrequencyBandwidth) obj;
        return Objects.equals(unitsAsString(), other.unitsAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrequencyBandwidth").add("Units", unitsAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "units":
            return Optional.ofNullable(clazz.cast(unitsAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("units", UNITS_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FrequencyBandwidth, T> g) {
        return obj -> g.apply((FrequencyBandwidth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrequencyBandwidth> {
        /**
         * <p>
         * Frequency bandwidth units.
         * </p>
         * 
         * @param units
         *        Frequency bandwidth units.
         * @see BandwidthUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthUnits
         */
        Builder units(String units);

        /**
         * <p>
         * Frequency bandwidth units.
         * </p>
         * 
         * @param units
         *        Frequency bandwidth units.
         * @see BandwidthUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthUnits
         */
        Builder units(BandwidthUnits units);

        /**
         * <p>
         * Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String units;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(FrequencyBandwidth model) {
            units(model.units);
            value(model.value);
        }

        public final String getUnits() {
            return units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        @Override
        public final Builder units(BandwidthUnits units) {
            this.units(units == null ? null : units.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public FrequencyBandwidth build() {
            return new FrequencyBandwidth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
