/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetConfigResponse.Builder, GetConfigResponse> {
    private static final SdkField<String> CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configArn").getter(getter(GetConfigResponse::configArn)).setter(setter(Builder::configArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configArn").build()).build();

    private static final SdkField<ConfigTypeData> CONFIG_DATA_FIELD = SdkField.<ConfigTypeData> builder(MarshallingType.SDK_POJO)
            .memberName("configData").getter(getter(GetConfigResponse::configData)).setter(setter(Builder::configData))
            .constructor(ConfigTypeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configData").build()).build();

    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configId").getter(getter(GetConfigResponse::configId)).setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()).build();

    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configType").getter(getter(GetConfigResponse::configTypeAsString)).setter(setter(Builder::configType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetConfigResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetConfigResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ARN_FIELD,
            CONFIG_DATA_FIELD, CONFIG_ID_FIELD, CONFIG_TYPE_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configArn;

    private final ConfigTypeData configData;

    private final String configId;

    private final String configType;

    private final String name;

    private final Map<String, String> tags;

    private GetConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configArn = builder.configArn;
        this.configData = builder.configData;
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * ARN of a <code>Config</code>
     * </p>
     * 
     * @return ARN of a <code>Config</code>
     */
    public final String configArn() {
        return configArn;
    }

    /**
     * <p>
     * Data elements in a <code>Config</code>.
     * </p>
     * 
     * @return Data elements in a <code>Config</code>.
     */
    public final ConfigTypeData configData() {
        return configData;
    }

    /**
     * <p>
     * UUID of a <code>Config</code>.
     * </p>
     * 
     * @return UUID of a <code>Config</code>.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(configType);
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final String configTypeAsString() {
        return configType;
    }

    /**
     * <p>
     * Name of a <code>Config</code>.
     * </p>
     * 
     * @return Name of a <code>Config</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a <code>Config</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to a <code>Config</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configArn());
        hashCode = 31 * hashCode + Objects.hashCode(configData());
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigResponse)) {
            return false;
        }
        GetConfigResponse other = (GetConfigResponse) obj;
        return Objects.equals(configArn(), other.configArn()) && Objects.equals(configData(), other.configData())
                && Objects.equals(configId(), other.configId())
                && Objects.equals(configTypeAsString(), other.configTypeAsString()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigResponse").add("ConfigArn", configArn()).add("ConfigData", configData())
                .add("ConfigId", configId()).add("ConfigType", configTypeAsString()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configArn":
            return Optional.ofNullable(clazz.cast(configArn()));
        case "configData":
            return Optional.ofNullable(clazz.cast(configData()));
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "configType":
            return Optional.ofNullable(clazz.cast(configTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configArn", CONFIG_ARN_FIELD);
        map.put("configData", CONFIG_DATA_FIELD);
        map.put("configId", CONFIG_ID_FIELD);
        map.put("configType", CONFIG_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigResponse, T> g) {
        return obj -> g.apply((GetConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigResponse> {
        /**
         * <p>
         * ARN of a <code>Config</code>
         * </p>
         * 
         * @param configArn
         *        ARN of a <code>Config</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configArn(String configArn);

        /**
         * <p>
         * Data elements in a <code>Config</code>.
         * </p>
         * 
         * @param configData
         *        Data elements in a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configData(ConfigTypeData configData);

        /**
         * <p>
         * Data elements in a <code>Config</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigTypeData.Builder} avoiding the need
         * to create one manually via {@link ConfigTypeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigTypeData.Builder#build()} is called immediately and its
         * result is passed to {@link #configData(ConfigTypeData)}.
         * 
         * @param configData
         *        a consumer that will call methods on {@link ConfigTypeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configData(ConfigTypeData)
         */
        default Builder configData(Consumer<ConfigTypeData.Builder> configData) {
            return configData(ConfigTypeData.builder().applyMutation(configData).build());
        }

        /**
         * <p>
         * UUID of a <code>Config</code>.
         * </p>
         * 
         * @param configId
         *        UUID of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(String configType);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(ConfigCapabilityType configType);

        /**
         * <p>
         * Name of a <code>Config</code>.
         * </p>
         * 
         * @param name
         *        Name of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Tags assigned to a <code>Config</code>.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String configArn;

        private ConfigTypeData configData;

        private String configId;

        private String configType;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigResponse model) {
            super(model);
            configArn(model.configArn);
            configData(model.configData);
            configId(model.configId);
            configType(model.configType);
            name(model.name);
            tags(model.tags);
        }

        public final String getConfigArn() {
            return configArn;
        }

        public final void setConfigArn(String configArn) {
            this.configArn = configArn;
        }

        @Override
        public final Builder configArn(String configArn) {
            this.configArn = configArn;
            return this;
        }

        public final ConfigTypeData.Builder getConfigData() {
            return configData != null ? configData.toBuilder() : null;
        }

        public final void setConfigData(ConfigTypeData.BuilderImpl configData) {
            this.configData = configData != null ? configData.build() : null;
        }

        @Override
        public final Builder configData(ConfigTypeData configData) {
            this.configData = configData;
            return this;
        }

        public final String getConfigId() {
            return configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getConfigType() {
            return configType;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetConfigResponse build() {
            return new GetConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
