/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMinuteUsageResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetMinuteUsageResponse.Builder, GetMinuteUsageResponse> {
    private static final SdkField<Integer> ESTIMATED_MINUTES_REMAINING_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("estimatedMinutesRemaining")
            .getter(getter(GetMinuteUsageResponse::estimatedMinutesRemaining)).setter(setter(Builder::estimatedMinutesRemaining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMinutesRemaining").build())
            .build();

    private static final SdkField<Boolean> IS_RESERVED_MINUTES_CUSTOMER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("isReservedMinutesCustomer")
            .getter(getter(GetMinuteUsageResponse::isReservedMinutesCustomer)).setter(setter(Builder::isReservedMinutesCustomer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isReservedMinutesCustomer").build())
            .build();

    private static final SdkField<Integer> TOTAL_RESERVED_MINUTE_ALLOCATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalReservedMinuteAllocation")
            .getter(getter(GetMinuteUsageResponse::totalReservedMinuteAllocation))
            .setter(setter(Builder::totalReservedMinuteAllocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalReservedMinuteAllocation")
                    .build()).build();

    private static final SdkField<Integer> TOTAL_SCHEDULED_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalScheduledMinutes").getter(getter(GetMinuteUsageResponse::totalScheduledMinutes))
            .setter(setter(Builder::totalScheduledMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalScheduledMinutes").build())
            .build();

    private static final SdkField<Integer> UPCOMING_MINUTES_SCHEDULED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("upcomingMinutesScheduled").getter(getter(GetMinuteUsageResponse::upcomingMinutesScheduled))
            .setter(setter(Builder::upcomingMinutesScheduled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upcomingMinutesScheduled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_MINUTES_REMAINING_FIELD, IS_RESERVED_MINUTES_CUSTOMER_FIELD, TOTAL_RESERVED_MINUTE_ALLOCATION_FIELD,
            TOTAL_SCHEDULED_MINUTES_FIELD, UPCOMING_MINUTES_SCHEDULED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer estimatedMinutesRemaining;

    private final Boolean isReservedMinutesCustomer;

    private final Integer totalReservedMinuteAllocation;

    private final Integer totalScheduledMinutes;

    private final Integer upcomingMinutesScheduled;

    private GetMinuteUsageResponse(BuilderImpl builder) {
        super(builder);
        this.estimatedMinutesRemaining = builder.estimatedMinutesRemaining;
        this.isReservedMinutesCustomer = builder.isReservedMinutesCustomer;
        this.totalReservedMinuteAllocation = builder.totalReservedMinuteAllocation;
        this.totalScheduledMinutes = builder.totalScheduledMinutes;
        this.upcomingMinutesScheduled = builder.upcomingMinutesScheduled;
    }

    /**
     * <p>
     * Estimated number of minutes remaining for an account, specific to the month being requested.
     * </p>
     * 
     * @return Estimated number of minutes remaining for an account, specific to the month being requested.
     */
    public final Integer estimatedMinutesRemaining() {
        return estimatedMinutesRemaining;
    }

    /**
     * <p>
     * Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the month
     * being requested.
     * </p>
     * 
     * @return Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the
     *         month being requested.
     */
    public final Boolean isReservedMinutesCustomer() {
        return isReservedMinutesCustomer;
    }

    /**
     * <p>
     * Total number of reserved minutes allocated, specific to the month being requested.
     * </p>
     * 
     * @return Total number of reserved minutes allocated, specific to the month being requested.
     */
    public final Integer totalReservedMinuteAllocation() {
        return totalReservedMinuteAllocation;
    }

    /**
     * <p>
     * Total scheduled minutes for an account, specific to the month being requested.
     * </p>
     * 
     * @return Total scheduled minutes for an account, specific to the month being requested.
     */
    public final Integer totalScheduledMinutes() {
        return totalScheduledMinutes;
    }

    /**
     * <p>
     * Upcoming minutes scheduled for an account, specific to the month being requested.
     * </p>
     * 
     * @return Upcoming minutes scheduled for an account, specific to the month being requested.
     */
    public final Integer upcomingMinutesScheduled() {
        return upcomingMinutesScheduled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMinutesRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(isReservedMinutesCustomer());
        hashCode = 31 * hashCode + Objects.hashCode(totalReservedMinuteAllocation());
        hashCode = 31 * hashCode + Objects.hashCode(totalScheduledMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(upcomingMinutesScheduled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMinuteUsageResponse)) {
            return false;
        }
        GetMinuteUsageResponse other = (GetMinuteUsageResponse) obj;
        return Objects.equals(estimatedMinutesRemaining(), other.estimatedMinutesRemaining())
                && Objects.equals(isReservedMinutesCustomer(), other.isReservedMinutesCustomer())
                && Objects.equals(totalReservedMinuteAllocation(), other.totalReservedMinuteAllocation())
                && Objects.equals(totalScheduledMinutes(), other.totalScheduledMinutes())
                && Objects.equals(upcomingMinutesScheduled(), other.upcomingMinutesScheduled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMinuteUsageResponse").add("EstimatedMinutesRemaining", estimatedMinutesRemaining())
                .add("IsReservedMinutesCustomer", isReservedMinutesCustomer())
                .add("TotalReservedMinuteAllocation", totalReservedMinuteAllocation())
                .add("TotalScheduledMinutes", totalScheduledMinutes())
                .add("UpcomingMinutesScheduled", upcomingMinutesScheduled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedMinutesRemaining":
            return Optional.ofNullable(clazz.cast(estimatedMinutesRemaining()));
        case "isReservedMinutesCustomer":
            return Optional.ofNullable(clazz.cast(isReservedMinutesCustomer()));
        case "totalReservedMinuteAllocation":
            return Optional.ofNullable(clazz.cast(totalReservedMinuteAllocation()));
        case "totalScheduledMinutes":
            return Optional.ofNullable(clazz.cast(totalScheduledMinutes()));
        case "upcomingMinutesScheduled":
            return Optional.ofNullable(clazz.cast(upcomingMinutesScheduled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("estimatedMinutesRemaining", ESTIMATED_MINUTES_REMAINING_FIELD);
        map.put("isReservedMinutesCustomer", IS_RESERVED_MINUTES_CUSTOMER_FIELD);
        map.put("totalReservedMinuteAllocation", TOTAL_RESERVED_MINUTE_ALLOCATION_FIELD);
        map.put("totalScheduledMinutes", TOTAL_SCHEDULED_MINUTES_FIELD);
        map.put("upcomingMinutesScheduled", UPCOMING_MINUTES_SCHEDULED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMinuteUsageResponse, T> g) {
        return obj -> g.apply((GetMinuteUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMinuteUsageResponse> {
        /**
         * <p>
         * Estimated number of minutes remaining for an account, specific to the month being requested.
         * </p>
         * 
         * @param estimatedMinutesRemaining
         *        Estimated number of minutes remaining for an account, specific to the month being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMinutesRemaining(Integer estimatedMinutesRemaining);

        /**
         * <p>
         * Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the month
         * being requested.
         * </p>
         * 
         * @param isReservedMinutesCustomer
         *        Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the
         *        month being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isReservedMinutesCustomer(Boolean isReservedMinutesCustomer);

        /**
         * <p>
         * Total number of reserved minutes allocated, specific to the month being requested.
         * </p>
         * 
         * @param totalReservedMinuteAllocation
         *        Total number of reserved minutes allocated, specific to the month being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalReservedMinuteAllocation(Integer totalReservedMinuteAllocation);

        /**
         * <p>
         * Total scheduled minutes for an account, specific to the month being requested.
         * </p>
         * 
         * @param totalScheduledMinutes
         *        Total scheduled minutes for an account, specific to the month being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalScheduledMinutes(Integer totalScheduledMinutes);

        /**
         * <p>
         * Upcoming minutes scheduled for an account, specific to the month being requested.
         * </p>
         * 
         * @param upcomingMinutesScheduled
         *        Upcoming minutes scheduled for an account, specific to the month being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upcomingMinutesScheduled(Integer upcomingMinutesScheduled);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private Integer estimatedMinutesRemaining;

        private Boolean isReservedMinutesCustomer;

        private Integer totalReservedMinuteAllocation;

        private Integer totalScheduledMinutes;

        private Integer upcomingMinutesScheduled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMinuteUsageResponse model) {
            super(model);
            estimatedMinutesRemaining(model.estimatedMinutesRemaining);
            isReservedMinutesCustomer(model.isReservedMinutesCustomer);
            totalReservedMinuteAllocation(model.totalReservedMinuteAllocation);
            totalScheduledMinutes(model.totalScheduledMinutes);
            upcomingMinutesScheduled(model.upcomingMinutesScheduled);
        }

        public final Integer getEstimatedMinutesRemaining() {
            return estimatedMinutesRemaining;
        }

        public final void setEstimatedMinutesRemaining(Integer estimatedMinutesRemaining) {
            this.estimatedMinutesRemaining = estimatedMinutesRemaining;
        }

        @Override
        public final Builder estimatedMinutesRemaining(Integer estimatedMinutesRemaining) {
            this.estimatedMinutesRemaining = estimatedMinutesRemaining;
            return this;
        }

        public final Boolean getIsReservedMinutesCustomer() {
            return isReservedMinutesCustomer;
        }

        public final void setIsReservedMinutesCustomer(Boolean isReservedMinutesCustomer) {
            this.isReservedMinutesCustomer = isReservedMinutesCustomer;
        }

        @Override
        public final Builder isReservedMinutesCustomer(Boolean isReservedMinutesCustomer) {
            this.isReservedMinutesCustomer = isReservedMinutesCustomer;
            return this;
        }

        public final Integer getTotalReservedMinuteAllocation() {
            return totalReservedMinuteAllocation;
        }

        public final void setTotalReservedMinuteAllocation(Integer totalReservedMinuteAllocation) {
            this.totalReservedMinuteAllocation = totalReservedMinuteAllocation;
        }

        @Override
        public final Builder totalReservedMinuteAllocation(Integer totalReservedMinuteAllocation) {
            this.totalReservedMinuteAllocation = totalReservedMinuteAllocation;
            return this;
        }

        public final Integer getTotalScheduledMinutes() {
            return totalScheduledMinutes;
        }

        public final void setTotalScheduledMinutes(Integer totalScheduledMinutes) {
            this.totalScheduledMinutes = totalScheduledMinutes;
        }

        @Override
        public final Builder totalScheduledMinutes(Integer totalScheduledMinutes) {
            this.totalScheduledMinutes = totalScheduledMinutes;
            return this;
        }

        public final Integer getUpcomingMinutesScheduled() {
            return upcomingMinutesScheduled;
        }

        public final void setUpcomingMinutesScheduled(Integer upcomingMinutesScheduled) {
            this.upcomingMinutesScheduled = upcomingMinutesScheduled;
        }

        @Override
        public final Builder upcomingMinutesScheduled(Integer upcomingMinutesScheduled) {
            this.upcomingMinutesScheduled = upcomingMinutesScheduled;
            return this;
        }

        @Override
        public GetMinuteUsageResponse build() {
            return new GetMinuteUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
