/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * KMS key info.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KmsKey implements SdkPojo, Serializable, ToCopyableBuilder<KmsKey.Builder, KmsKey> {
    private static final SdkField<String> KMS_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsAliasArn").getter(getter(KmsKey::kmsAliasArn)).setter(setter(Builder::kmsAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAliasArn").build()).build();

    private static final SdkField<String> KMS_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsAliasName").getter(getter(KmsKey::kmsAliasName)).setter(setter(Builder::kmsAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAliasName").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(KmsKey::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ALIAS_ARN_FIELD,
            KMS_ALIAS_NAME_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsAliasArn;

    private final String kmsAliasName;

    private final String kmsKeyArn;

    private final Type type;

    private KmsKey(BuilderImpl builder) {
        this.kmsAliasArn = builder.kmsAliasArn;
        this.kmsAliasName = builder.kmsAliasName;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.type = builder.type;
    }

    /**
     * <p>
     * KMS Alias Arn.
     * </p>
     * 
     * @return KMS Alias Arn.
     */
    public final String kmsAliasArn() {
        return kmsAliasArn;
    }

    /**
     * <p>
     * KMS Alias Name.
     * </p>
     * 
     * @return KMS Alias Name.
     */
    public final String kmsAliasName() {
        return kmsAliasName;
    }

    /**
     * <p>
     * KMS Key Arn.
     * </p>
     * 
     * @return KMS Key Arn.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsKey)) {
            return false;
        }
        KmsKey other = (KmsKey) obj;
        return Objects.equals(kmsAliasArn(), other.kmsAliasArn()) && Objects.equals(kmsAliasName(), other.kmsAliasName())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KmsKey").add("KmsAliasArn", kmsAliasArn()).add("KmsAliasName", kmsAliasName())
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsAliasArn":
            return Optional.ofNullable(clazz.cast(kmsAliasArn()));
        case "kmsAliasName":
            return Optional.ofNullable(clazz.cast(kmsAliasName()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #kmsAliasArn()} initialized to the given value.
     *
     * <p>
     * KMS Alias Arn.
     * </p>
     * 
     * @param kmsAliasArn
     *        KMS Alias Arn.
     */
    public static KmsKey fromKmsAliasArn(String kmsAliasArn) {
        return builder().kmsAliasArn(kmsAliasArn).build();
    }

    /**
     * Create an instance of this class with {@link #kmsAliasName()} initialized to the given value.
     *
     * <p>
     * KMS Alias Name.
     * </p>
     * 
     * @param kmsAliasName
     *        KMS Alias Name.
     */
    public static KmsKey fromKmsAliasName(String kmsAliasName) {
        return builder().kmsAliasName(kmsAliasName).build();
    }

    /**
     * Create an instance of this class with {@link #kmsKeyArn()} initialized to the given value.
     *
     * <p>
     * KMS Key Arn.
     * </p>
     * 
     * @param kmsKeyArn
     *        KMS Key Arn.
     */
    public static KmsKey fromKmsKeyArn(String kmsKeyArn) {
        return builder().kmsKeyArn(kmsKeyArn).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kmsAliasArn", KMS_ALIAS_ARN_FIELD);
        map.put("kmsAliasName", KMS_ALIAS_NAME_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KmsKey, T> g) {
        return obj -> g.apply((KmsKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KmsKey> {
        /**
         * <p>
         * KMS Alias Arn.
         * </p>
         * 
         * @param kmsAliasArn
         *        KMS Alias Arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsAliasArn(String kmsAliasArn);

        /**
         * <p>
         * KMS Alias Name.
         * </p>
         * 
         * @param kmsAliasName
         *        KMS Alias Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsAliasName(String kmsAliasName);

        /**
         * <p>
         * KMS Key Arn.
         * </p>
         * 
         * @param kmsKeyArn
         *        KMS Key Arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String kmsAliasArn;

        private String kmsAliasName;

        private String kmsKeyArn;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KmsKey model) {
            kmsAliasArn(model.kmsAliasArn);
            kmsAliasName(model.kmsAliasName);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getKmsAliasArn() {
            return kmsAliasArn;
        }

        public final void setKmsAliasArn(String kmsAliasArn) {
            Object oldValue = this.kmsAliasArn;
            this.kmsAliasArn = kmsAliasArn;
            handleUnionValueChange(Type.KMS_ALIAS_ARN, oldValue, this.kmsAliasArn);
        }

        @Override
        public final Builder kmsAliasArn(String kmsAliasArn) {
            Object oldValue = this.kmsAliasArn;
            this.kmsAliasArn = kmsAliasArn;
            handleUnionValueChange(Type.KMS_ALIAS_ARN, oldValue, this.kmsAliasArn);
            return this;
        }

        public final String getKmsAliasName() {
            return kmsAliasName;
        }

        public final void setKmsAliasName(String kmsAliasName) {
            Object oldValue = this.kmsAliasName;
            this.kmsAliasName = kmsAliasName;
            handleUnionValueChange(Type.KMS_ALIAS_NAME, oldValue, this.kmsAliasName);
        }

        @Override
        public final Builder kmsAliasName(String kmsAliasName) {
            Object oldValue = this.kmsAliasName;
            this.kmsAliasName = kmsAliasName;
            handleUnionValueChange(Type.KMS_ALIAS_NAME, oldValue, this.kmsAliasName);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            Object oldValue = this.kmsKeyArn;
            this.kmsKeyArn = kmsKeyArn;
            handleUnionValueChange(Type.KMS_KEY_ARN, oldValue, this.kmsKeyArn);
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            Object oldValue = this.kmsKeyArn;
            this.kmsKeyArn = kmsKeyArn;
            handleUnionValueChange(Type.KMS_KEY_ARN, oldValue, this.kmsKeyArn);
            return this;
        }

        @Override
        public KmsKey build() {
            return new KmsKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see KmsKey#type()
     */
    public enum Type {
        KMS_ALIAS_ARN,

        KMS_ALIAS_NAME,

        KMS_KEY_ARN,

        UNKNOWN_TO_SDK_VERSION
    }
}
