/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactsRequest extends GroundStationRequest implements
        ToCopyableBuilder<ListContactsRequest.Builder, ListContactsRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListContactsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groundStation").getter(getter(ListContactsRequest::groundStation))
            .setter(setter(Builder::groundStation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListContactsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("missionProfileArn").getter(getter(ListContactsRequest::missionProfileArn))
            .setter(setter(Builder::missionProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListContactsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("satelliteArn").getter(getter(ListContactsRequest::satelliteArn)).setter(setter(Builder::satelliteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListContactsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusList")
            .getter(getter(ListContactsRequest::statusListAsStrings))
            .setter(setter(Builder::statusListWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            GROUND_STATION_FIELD, MAX_RESULTS_FIELD, MISSION_PROFILE_ARN_FIELD, NEXT_TOKEN_FIELD, SATELLITE_ARN_FIELD,
            START_TIME_FIELD, STATUS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant endTime;

    private final String groundStation;

    private final Integer maxResults;

    private final String missionProfileArn;

    private final String nextToken;

    private final String satelliteArn;

    private final Instant startTime;

    private final List<String> statusList;

    private ListContactsRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.groundStation = builder.groundStation;
        this.maxResults = builder.maxResults;
        this.missionProfileArn = builder.missionProfileArn;
        this.nextToken = builder.nextToken;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.statusList = builder.statusList;
    }

    /**
     * <p>
     * End time of a contact in UTC.
     * </p>
     * 
     * @return End time of a contact in UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Name of a ground station.
     * </p>
     * 
     * @return Name of a ground station.
     */
    public final String groundStation() {
        return groundStation;
    }

    /**
     * <p>
     * Maximum number of contacts returned.
     * </p>
     * 
     * @return Maximum number of contacts returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * ARN of a mission profile.
     * </p>
     * 
     * @return ARN of a mission profile.
     */
    public final String missionProfileArn() {
        return missionProfileArn;
    }

    /**
     * <p>
     * Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of
     * results.
     * </p>
     * 
     * @return Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * ARN of a satellite.
     * </p>
     * 
     * @return ARN of a satellite.
     */
    public final String satelliteArn() {
        return satelliteArn;
    }

    /**
     * <p>
     * Start time of a contact in UTC.
     * </p>
     * 
     * @return Start time of a contact in UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Status of a contact reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusList} method.
     * </p>
     * 
     * @return Status of a contact reservation.
     */
    public final List<ContactStatus> statusList() {
        return StatusListCopier.copyStringToEnum(statusList);
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatusList() {
        return statusList != null && !(statusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Status of a contact reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusList} method.
     * </p>
     * 
     * @return Status of a contact reservation.
     */
    public final List<String> statusListAsStrings() {
        return statusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusList() ? statusListAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsRequest)) {
            return false;
        }
        ListContactsRequest other = (ListContactsRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(groundStation(), other.groundStation())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(missionProfileArn(), other.missionProfileArn())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(satelliteArn(), other.satelliteArn())
                && Objects.equals(startTime(), other.startTime()) && hasStatusList() == other.hasStatusList()
                && Objects.equals(statusListAsStrings(), other.statusListAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactsRequest").add("EndTime", endTime()).add("GroundStation", groundStation())
                .add("MaxResults", maxResults()).add("MissionProfileArn", missionProfileArn()).add("NextToken", nextToken())
                .add("SatelliteArn", satelliteArn()).add("StartTime", startTime())
                .add("StatusList", hasStatusList() ? statusListAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "groundStation":
            return Optional.ofNullable(clazz.cast(groundStation()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "missionProfileArn":
            return Optional.ofNullable(clazz.cast(missionProfileArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "satelliteArn":
            return Optional.ofNullable(clazz.cast(satelliteArn()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "statusList":
            return Optional.ofNullable(clazz.cast(statusListAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endTime", END_TIME_FIELD);
        map.put("groundStation", GROUND_STATION_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("statusList", STATUS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactsRequest, T> g) {
        return obj -> g.apply((ListContactsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListContactsRequest> {
        /**
         * <p>
         * End time of a contact in UTC.
         * </p>
         * 
         * @param endTime
         *        End time of a contact in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Name of a ground station.
         * </p>
         * 
         * @param groundStation
         *        Name of a ground station.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStation(String groundStation);

        /**
         * <p>
         * Maximum number of contacts returned.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of contacts returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * ARN of a mission profile.
         * </p>
         * 
         * @param missionProfileArn
         *        ARN of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileArn(String missionProfileArn);

        /**
         * <p>
         * Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next
         *        page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * ARN of a satellite.
         * </p>
         * 
         * @param satelliteArn
         *        ARN of a satellite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteArn(String satelliteArn);

        /**
         * <p>
         * Start time of a contact in UTC.
         * </p>
         * 
         * @param startTime
         *        Start time of a contact in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Status of a contact reservation.
         * </p>
         * 
         * @param statusList
         *        Status of a contact reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusListWithStrings(Collection<String> statusList);

        /**
         * <p>
         * Status of a contact reservation.
         * </p>
         * 
         * @param statusList
         *        Status of a contact reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusListWithStrings(String... statusList);

        /**
         * <p>
         * Status of a contact reservation.
         * </p>
         * 
         * @param statusList
         *        Status of a contact reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(Collection<ContactStatus> statusList);

        /**
         * <p>
         * Status of a contact reservation.
         * </p>
         * 
         * @param statusList
         *        Status of a contact reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(ContactStatus... statusList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private Instant endTime;

        private String groundStation;

        private Integer maxResults;

        private String missionProfileArn;

        private String nextToken;

        private String satelliteArn;

        private Instant startTime;

        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsRequest model) {
            super(model);
            endTime(model.endTime);
            groundStation(model.groundStation);
            maxResults(model.maxResults);
            missionProfileArn(model.missionProfileArn);
            nextToken(model.nextToken);
            satelliteArn(model.satelliteArn);
            startTime(model.startTime);
            statusListWithStrings(model.statusList);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getGroundStation() {
            return groundStation;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMissionProfileArn() {
            return missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSatelliteArn() {
            return satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Collection<String> getStatusList() {
            if (statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return statusList;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = StatusListCopier.copy(statusList);
        }

        @Override
        public final Builder statusListWithStrings(Collection<String> statusList) {
            this.statusList = StatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusListWithStrings(String... statusList) {
            statusListWithStrings(Arrays.asList(statusList));
            return this;
        }

        @Override
        public final Builder statusList(Collection<ContactStatus> statusList) {
            this.statusList = StatusListCopier.copyEnumToString(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(ContactStatus... statusList) {
            statusList(Arrays.asList(statusList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactsRequest build() {
            return new ListContactsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
