/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Item in a list of mission profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MissionProfileListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<MissionProfileListItem.Builder, MissionProfileListItem> {
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("missionProfileArn").getter(getter(MissionProfileListItem::missionProfileArn))
            .setter(setter(Builder::missionProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()).build();

    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("missionProfileId").getter(getter(MissionProfileListItem::missionProfileId))
            .setter(setter(Builder::missionProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MissionProfileListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(MissionProfileListItem::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MISSION_PROFILE_ARN_FIELD,
            MISSION_PROFILE_ID_FIELD, NAME_FIELD, REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String missionProfileArn;

    private final String missionProfileId;

    private final String name;

    private final String region;

    private MissionProfileListItem(BuilderImpl builder) {
        this.missionProfileArn = builder.missionProfileArn;
        this.missionProfileId = builder.missionProfileId;
        this.name = builder.name;
        this.region = builder.region;
    }

    /**
     * <p>
     * ARN of a mission profile.
     * </p>
     * 
     * @return ARN of a mission profile.
     */
    public final String missionProfileArn() {
        return missionProfileArn;
    }

    /**
     * <p>
     * UUID of a mission profile.
     * </p>
     * 
     * @return UUID of a mission profile.
     */
    public final String missionProfileId() {
        return missionProfileId;
    }

    /**
     * <p>
     * Name of a mission profile.
     * </p>
     * 
     * @return Name of a mission profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Region of a mission profile.
     * </p>
     * 
     * @return Region of a mission profile.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MissionProfileListItem)) {
            return false;
        }
        MissionProfileListItem other = (MissionProfileListItem) obj;
        return Objects.equals(missionProfileArn(), other.missionProfileArn())
                && Objects.equals(missionProfileId(), other.missionProfileId()) && Objects.equals(name(), other.name())
                && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MissionProfileListItem").add("MissionProfileArn", missionProfileArn())
                .add("MissionProfileId", missionProfileId()).add("Name", name()).add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "missionProfileArn":
            return Optional.ofNullable(clazz.cast(missionProfileArn()));
        case "missionProfileId":
            return Optional.ofNullable(clazz.cast(missionProfileId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("missionProfileId", MISSION_PROFILE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MissionProfileListItem, T> g) {
        return obj -> g.apply((MissionProfileListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MissionProfileListItem> {
        /**
         * <p>
         * ARN of a mission profile.
         * </p>
         * 
         * @param missionProfileArn
         *        ARN of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileArn(String missionProfileArn);

        /**
         * <p>
         * UUID of a mission profile.
         * </p>
         * 
         * @param missionProfileId
         *        UUID of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileId(String missionProfileId);

        /**
         * <p>
         * Name of a mission profile.
         * </p>
         * 
         * @param name
         *        Name of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Region of a mission profile.
         * </p>
         * 
         * @param region
         *        Region of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String missionProfileArn;

        private String missionProfileId;

        private String name;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(MissionProfileListItem model) {
            missionProfileArn(model.missionProfileArn);
            missionProfileId(model.missionProfileId);
            name(model.name);
            region(model.region);
        }

        public final String getMissionProfileArn() {
            return missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final String getMissionProfileId() {
            return missionProfileId;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public MissionProfileListItem build() {
            return new MissionProfileListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
