/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A socket address with a port range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RangedSocketAddress implements SdkPojo, Serializable,
        ToCopyableBuilder<RangedSocketAddress.Builder, RangedSocketAddress> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RangedSocketAddress::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<IntegerRange> PORT_RANGE_FIELD = SdkField.<IntegerRange> builder(MarshallingType.SDK_POJO)
            .memberName("portRange").getter(getter(RangedSocketAddress::portRange)).setter(setter(Builder::portRange))
            .constructor(IntegerRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PORT_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final IntegerRange portRange;

    private RangedSocketAddress(BuilderImpl builder) {
        this.name = builder.name;
        this.portRange = builder.portRange;
    }

    /**
     * <p>
     * IPv4 socket address.
     * </p>
     * 
     * @return IPv4 socket address.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Port range of a socket address.
     * </p>
     * 
     * @return Port range of a socket address.
     */
    public final IntegerRange portRange() {
        return portRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(portRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RangedSocketAddress)) {
            return false;
        }
        RangedSocketAddress other = (RangedSocketAddress) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(portRange(), other.portRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RangedSocketAddress").add("Name", name()).add("PortRange", portRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "portRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("portRange", PORT_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RangedSocketAddress, T> g) {
        return obj -> g.apply((RangedSocketAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RangedSocketAddress> {
        /**
         * <p>
         * IPv4 socket address.
         * </p>
         * 
         * @param name
         *        IPv4 socket address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Port range of a socket address.
         * </p>
         * 
         * @param portRange
         *        Port range of a socket address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(IntegerRange portRange);

        /**
         * <p>
         * Port range of a socket address.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegerRange.Builder} avoiding the need
         * to create one manually via {@link IntegerRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegerRange.Builder#build()} is called immediately and its
         * result is passed to {@link #portRange(IntegerRange)}.
         * 
         * @param portRange
         *        a consumer that will call methods on {@link IntegerRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(IntegerRange)
         */
        default Builder portRange(Consumer<IntegerRange.Builder> portRange) {
            return portRange(IntegerRange.builder().applyMutation(portRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private IntegerRange portRange;

        private BuilderImpl() {
        }

        private BuilderImpl(RangedSocketAddress model) {
            name(model.name);
            portRange(model.portRange);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final IntegerRange.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        public final void setPortRange(IntegerRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        @Override
        public final Builder portRange(IntegerRange portRange) {
            this.portRange = portRange;
            return this;
        }

        @Override
        public RangedSocketAddress build() {
            return new RangedSocketAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
