/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.EndpointDetails;
import software.amazon.awssdk.services.groundstation.model.EndpointDetailsListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataflowEndpointGroupRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, CreateDataflowEndpointGroupRequest> {
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPostPassDurationSeconds").getter(CreateDataflowEndpointGroupRequest.getter(CreateDataflowEndpointGroupRequest::contactPostPassDurationSeconds)).setter(CreateDataflowEndpointGroupRequest.setter(Builder::contactPostPassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds").build()}).build();
    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPrePassDurationSeconds").getter(CreateDataflowEndpointGroupRequest.getter(CreateDataflowEndpointGroupRequest::contactPrePassDurationSeconds)).setter(CreateDataflowEndpointGroupRequest.setter(Builder::contactPrePassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds").build()}).build();
    private static final SdkField<List<EndpointDetails>> ENDPOINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("endpointDetails").getter(CreateDataflowEndpointGroupRequest.getter(CreateDataflowEndpointGroupRequest::endpointDetails)).setter(CreateDataflowEndpointGroupRequest.setter(Builder::endpointDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDataflowEndpointGroupRequest.getter(CreateDataflowEndpointGroupRequest::tags)).setter(CreateDataflowEndpointGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_POST_PASS_DURATION_SECONDS_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, ENDPOINT_DETAILS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataflowEndpointGroupRequest.memberNameToFieldInitializer();
    private final Integer contactPostPassDurationSeconds;
    private final Integer contactPrePassDurationSeconds;
    private final List<EndpointDetails> endpointDetails;
    private final Map<String, String> tags;

    private CreateDataflowEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.endpointDetails = builder.endpointDetails;
        this.tags = builder.tags;
    }

    public final Integer contactPostPassDurationSeconds() {
        return this.contactPostPassDurationSeconds;
    }

    public final Integer contactPrePassDurationSeconds() {
        return this.contactPrePassDurationSeconds;
    }

    public final boolean hasEndpointDetails() {
        return this.endpointDetails != null && !(this.endpointDetails instanceof SdkAutoConstructList);
    }

    public final List<EndpointDetails> endpointDetails() {
        return this.endpointDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointDetails() ? this.endpointDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataflowEndpointGroupRequest)) {
            return false;
        }
        CreateDataflowEndpointGroupRequest other = (CreateDataflowEndpointGroupRequest)((Object)obj);
        return Objects.equals(this.contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds()) && Objects.equals(this.contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds()) && this.hasEndpointDetails() == other.hasEndpointDetails() && Objects.equals(this.endpointDetails(), other.endpointDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataflowEndpointGroupRequest").add("ContactPostPassDurationSeconds", (Object)this.contactPostPassDurationSeconds()).add("ContactPrePassDurationSeconds", (Object)this.contactPrePassDurationSeconds()).add("EndpointDetails", this.hasEndpointDetails() ? this.endpointDetails() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactPostPassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPostPassDurationSeconds()));
            }
            case "contactPrePassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPrePassDurationSeconds()));
            }
            case "endpointDetails": {
                return Optional.ofNullable(clazz.cast(this.endpointDetails()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contactPostPassDurationSeconds", CONTACT_POST_PASS_DURATION_SECONDS_FIELD);
        map.put("contactPrePassDurationSeconds", CONTACT_PRE_PASS_DURATION_SECONDS_FIELD);
        map.put("endpointDetails", ENDPOINT_DETAILS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataflowEndpointGroupRequest, T> g) {
        return obj -> g.apply((CreateDataflowEndpointGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Integer contactPostPassDurationSeconds;
        private Integer contactPrePassDurationSeconds;
        private List<EndpointDetails> endpointDetails = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataflowEndpointGroupRequest model) {
            super(model);
            this.contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            this.contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            this.endpointDetails(model.endpointDetails);
            this.tags(model.tags);
        }

        public final Integer getContactPostPassDurationSeconds() {
            return this.contactPostPassDurationSeconds;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return this.contactPrePassDurationSeconds;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final List<EndpointDetails.Builder> getEndpointDetails() {
            List<EndpointDetails.Builder> result = EndpointDetailsListCopier.copyToBuilder(this.endpointDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointDetails(Collection<EndpointDetails.BuilderImpl> endpointDetails) {
            this.endpointDetails = EndpointDetailsListCopier.copyFromBuilder(endpointDetails);
        }

        @Override
        public final Builder endpointDetails(Collection<EndpointDetails> endpointDetails) {
            this.endpointDetails = EndpointDetailsListCopier.copy(endpointDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDetails(EndpointDetails ... endpointDetails) {
            this.endpointDetails(Arrays.asList(endpointDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDetails(Consumer<EndpointDetails.Builder> ... endpointDetails) {
            this.endpointDetails(Stream.of(endpointDetails).map(c -> (EndpointDetails)((EndpointDetails.Builder)EndpointDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataflowEndpointGroupRequest build() {
            return new CreateDataflowEndpointGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataflowEndpointGroupRequest> {
        public Builder contactPostPassDurationSeconds(Integer var1);

        public Builder contactPrePassDurationSeconds(Integer var1);

        public Builder endpointDetails(Collection<EndpointDetails> var1);

        public Builder endpointDetails(EndpointDetails ... var1);

        public Builder endpointDetails(Consumer<EndpointDetails.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

