/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.endpoints.internal;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.groundstation.endpoints.internal.Outputs;
import software.amazon.awssdk.services.groundstation.endpoints.internal.Partition;
import software.amazon.awssdk.services.groundstation.endpoints.internal.PartitionDataProvider;
import software.amazon.awssdk.services.groundstation.endpoints.internal.Partitions;
import software.amazon.awssdk.services.groundstation.endpoints.internal.RegionOverride;
import software.amazon.awssdk.utils.ClassLoaderHelper;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkInternalApi
public final class DefaultPartitionDataProvider
implements PartitionDataProvider {
    private static final JsonNodeParser PARSER = JsonNodeParser.create();

    @Override
    public Partitions loadPartitions() {
        return (Partitions)OptionalUtils.firstPresent(this.systemSettingPartitionsFile(), (Supplier[])new Supplier[]{this::classpathPartitionsFile, () -> Optional.of(LazyPartitionsContainer.PARTITIONS)}).orElseThrow(() -> new IllegalStateException("Unable to find partition metadata."));
    }

    private Optional<Partitions> systemSettingPartitionsFile() {
        return SdkSystemSetting.AWS_PARTITIONS_FILE.getStringValue().map(x$0 -> Paths.get(x$0, new String[0])).map(p -> (InputStream)FunctionalUtils.invokeSafely(() -> Files.newInputStream(p, new OpenOption[0]))).map(this::readPartitionsFile);
    }

    private Optional<Partitions> classpathPartitionsFile() {
        return Optional.ofNullable(ClassLoaderHelper.classLoader((Class[])new Class[]{this.getClass()}).getResourceAsStream("software/amazon/awssdk/global/partitions.json")).map(this::readPartitionsFile);
    }

    private Partitions readPartitionsFile(InputStream partitionsFile) {
        try {
            Partitions partitions = Partitions.fromNode(PARSER.parse(partitionsFile));
            return partitions;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)partitionsFile, null);
        }
    }

    static class LazyPartitionsContainer {
        static final Partitions PARTITIONS = Partitions.builder().version("1.1").addPartition(Partition.builder().id("aws").regionRegex("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$").putRegion("af-south-1", RegionOverride.builder().build()).putRegion("ap-east-1", RegionOverride.builder().build()).putRegion("ap-east-2", RegionOverride.builder().build()).putRegion("ap-northeast-1", RegionOverride.builder().build()).putRegion("ap-northeast-2", RegionOverride.builder().build()).putRegion("ap-northeast-3", RegionOverride.builder().build()).putRegion("ap-south-1", RegionOverride.builder().build()).putRegion("ap-south-2", RegionOverride.builder().build()).putRegion("ap-southeast-1", RegionOverride.builder().build()).putRegion("ap-southeast-2", RegionOverride.builder().build()).putRegion("ap-southeast-3", RegionOverride.builder().build()).putRegion("ap-southeast-4", RegionOverride.builder().build()).putRegion("ap-southeast-5", RegionOverride.builder().build()).putRegion("ap-southeast-6", RegionOverride.builder().build()).putRegion("ap-southeast-7", RegionOverride.builder().build()).putRegion("aws-global", RegionOverride.builder().build()).putRegion("ca-central-1", RegionOverride.builder().build()).putRegion("ca-west-1", RegionOverride.builder().build()).putRegion("eu-central-1", RegionOverride.builder().build()).putRegion("eu-central-2", RegionOverride.builder().build()).putRegion("eu-north-1", RegionOverride.builder().build()).putRegion("eu-south-1", RegionOverride.builder().build()).putRegion("eu-south-2", RegionOverride.builder().build()).putRegion("eu-west-1", RegionOverride.builder().build()).putRegion("eu-west-2", RegionOverride.builder().build()).putRegion("eu-west-3", RegionOverride.builder().build()).putRegion("il-central-1", RegionOverride.builder().build()).putRegion("me-central-1", RegionOverride.builder().build()).putRegion("me-south-1", RegionOverride.builder().build()).putRegion("mx-central-1", RegionOverride.builder().build()).putRegion("sa-east-1", RegionOverride.builder().build()).putRegion("us-east-1", RegionOverride.builder().build()).putRegion("us-east-2", RegionOverride.builder().build()).putRegion("us-west-1", RegionOverride.builder().build()).putRegion("us-west-2", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("amazonaws.com").dualStackDnsSuffix("api.aws").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("us-east-1").build()).build()).addPartition(Partition.builder().id("aws-cn").regionRegex("^cn\\-\\w+\\-\\d+$").putRegion("aws-cn-global", RegionOverride.builder().build()).putRegion("cn-north-1", RegionOverride.builder().build()).putRegion("cn-northwest-1", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("amazonaws.com.cn").dualStackDnsSuffix("api.amazonwebservices.com.cn").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("cn-northwest-1").build()).build()).addPartition(Partition.builder().id("aws-eusc").regionRegex("^eusc\\-(de)\\-\\w+\\-\\d+$").putRegion("eusc-de-east-1", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("amazonaws.eu").dualStackDnsSuffix("api.amazonwebservices.eu").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("eusc-de-east-1").build()).build()).addPartition(Partition.builder().id("aws-iso").regionRegex("^us\\-iso\\-\\w+\\-\\d+$").putRegion("aws-iso-global", RegionOverride.builder().build()).putRegion("us-iso-east-1", RegionOverride.builder().build()).putRegion("us-iso-west-1", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("c2s.ic.gov").dualStackDnsSuffix("api.aws.ic.gov").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("us-iso-east-1").build()).build()).addPartition(Partition.builder().id("aws-iso-b").regionRegex("^us\\-isob\\-\\w+\\-\\d+$").putRegion("aws-iso-b-global", RegionOverride.builder().build()).putRegion("us-isob-east-1", RegionOverride.builder().build()).putRegion("us-isob-west-1", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("sc2s.sgov.gov").dualStackDnsSuffix("api.aws.scloud").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("us-isob-east-1").build()).build()).addPartition(Partition.builder().id("aws-iso-e").regionRegex("^eu\\-isoe\\-\\w+\\-\\d+$").putRegion("aws-iso-e-global", RegionOverride.builder().build()).putRegion("eu-isoe-west-1", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("cloud.adc-e.uk").dualStackDnsSuffix("api.cloud-aws.adc-e.uk").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("eu-isoe-west-1").build()).build()).addPartition(Partition.builder().id("aws-iso-f").regionRegex("^us\\-isof\\-\\w+\\-\\d+$").putRegion("aws-iso-f-global", RegionOverride.builder().build()).putRegion("us-isof-east-1", RegionOverride.builder().build()).putRegion("us-isof-south-1", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("csp.hci.ic.gov").dualStackDnsSuffix("api.aws.hci.ic.gov").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("us-isof-south-1").build()).build()).addPartition(Partition.builder().id("aws-us-gov").regionRegex("^us\\-gov\\-\\w+\\-\\d+$").putRegion("aws-us-gov-global", RegionOverride.builder().build()).putRegion("us-gov-east-1", RegionOverride.builder().build()).putRegion("us-gov-west-1", RegionOverride.builder().build()).outputs(Outputs.builder().dnsSuffix("amazonaws.com").dualStackDnsSuffix("api.aws").supportsFips(true).supportsDualStack(true).implicitGlobalRegion("us-gov-west-1").build()).build()).build();

        LazyPartitionsContainer() {
        }
    }
}

