/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEphemerisRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, UpdateEphemerisRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(UpdateEphemerisRequest.getter(UpdateEphemerisRequest::enabled)).setter(UpdateEphemerisRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisId").getter(UpdateEphemerisRequest.getter(UpdateEphemerisRequest::ephemerisId)).setter(UpdateEphemerisRequest.setter(Builder::ephemerisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ephemerisId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateEphemerisRequest.getter(UpdateEphemerisRequest::name)).setter(UpdateEphemerisRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(UpdateEphemerisRequest.getter(UpdateEphemerisRequest::priority)).setter(UpdateEphemerisRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, EPHEMERIS_ID_FIELD, NAME_FIELD, PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEphemerisRequest.memberNameToFieldInitializer();
    private final Boolean enabled;
    private final String ephemerisId;
    private final String name;
    private final Integer priority;

    private UpdateEphemerisRequest(BuilderImpl builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.ephemerisId = builder.ephemerisId;
        this.name = builder.name;
        this.priority = builder.priority;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String ephemerisId() {
        return this.ephemerisId;
    }

    public final String name() {
        return this.name;
    }

    public final Integer priority() {
        return this.priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEphemerisRequest)) {
            return false;
        }
        UpdateEphemerisRequest other = (UpdateEphemerisRequest)((Object)obj);
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.ephemerisId(), other.ephemerisId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEphemerisRequest").add("Enabled", (Object)this.enabled()).add("EphemerisId", (Object)this.ephemerisId()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ephemerisId": {
                return Optional.ofNullable(clazz.cast(this.ephemerisId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("ephemerisId", EPHEMERIS_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEphemerisRequest, T> g) {
        return obj -> g.apply((UpdateEphemerisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String ephemerisId;
        private String name;
        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEphemerisRequest model) {
            super(model);
            this.enabled(model.enabled);
            this.ephemerisId(model.ephemerisId);
            this.name(model.name);
            this.priority(model.priority);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEphemerisId() {
            return this.ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEphemerisRequest build() {
            return new UpdateEphemerisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEphemerisRequest> {
        public Builder enabled(Boolean var1);

        public Builder ephemerisId(String var1);

        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

