/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how AWS Ground Station should configure an antenna for downlink during a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AntennaDownlinkConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AntennaDownlinkConfig.Builder, AntennaDownlinkConfig> {
    private static final SdkField<SpectrumConfig> SPECTRUM_CONFIG_FIELD = SdkField
            .<SpectrumConfig> builder(MarshallingType.SDK_POJO).memberName("spectrumConfig")
            .getter(getter(AntennaDownlinkConfig::spectrumConfig)).setter(setter(Builder::spectrumConfig))
            .constructor(SpectrumConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spectrumConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECTRUM_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SpectrumConfig spectrumConfig;

    private AntennaDownlinkConfig(BuilderImpl builder) {
        this.spectrumConfig = builder.spectrumConfig;
    }

    /**
     * <p>
     * Object that describes a spectral <code>Config</code>.
     * </p>
     * 
     * @return Object that describes a spectral <code>Config</code>.
     */
    public final SpectrumConfig spectrumConfig() {
        return spectrumConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spectrumConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntennaDownlinkConfig)) {
            return false;
        }
        AntennaDownlinkConfig other = (AntennaDownlinkConfig) obj;
        return Objects.equals(spectrumConfig(), other.spectrumConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AntennaDownlinkConfig").add("SpectrumConfig", spectrumConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spectrumConfig":
            return Optional.ofNullable(clazz.cast(spectrumConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spectrumConfig", SPECTRUM_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AntennaDownlinkConfig, T> g) {
        return obj -> g.apply((AntennaDownlinkConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AntennaDownlinkConfig> {
        /**
         * <p>
         * Object that describes a spectral <code>Config</code>.
         * </p>
         * 
         * @param spectrumConfig
         *        Object that describes a spectral <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spectrumConfig(SpectrumConfig spectrumConfig);

        /**
         * <p>
         * Object that describes a spectral <code>Config</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpectrumConfig.Builder} avoiding the need
         * to create one manually via {@link SpectrumConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpectrumConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #spectrumConfig(SpectrumConfig)}.
         * 
         * @param spectrumConfig
         *        a consumer that will call methods on {@link SpectrumConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spectrumConfig(SpectrumConfig)
         */
        default Builder spectrumConfig(Consumer<SpectrumConfig.Builder> spectrumConfig) {
            return spectrumConfig(SpectrumConfig.builder().applyMutation(spectrumConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SpectrumConfig spectrumConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AntennaDownlinkConfig model) {
            spectrumConfig(model.spectrumConfig);
        }

        public final SpectrumConfig.Builder getSpectrumConfig() {
            return spectrumConfig != null ? spectrumConfig.toBuilder() : null;
        }

        public final void setSpectrumConfig(SpectrumConfig.BuilderImpl spectrumConfig) {
            this.spectrumConfig = spectrumConfig != null ? spectrumConfig.build() : null;
        }

        @Override
        public final Builder spectrumConfig(SpectrumConfig spectrumConfig) {
            this.spectrumConfig = spectrumConfig;
            return this;
        }

        @Override
        public AntennaDownlinkConfig build() {
            return new AntennaDownlinkConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
