/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AzElSegmentListCopier {
    static List<AzElSegment> copy(Collection<? extends AzElSegment> azElSegmentListParam) {
        List<AzElSegment> list;
        if (azElSegmentListParam == null || azElSegmentListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AzElSegment> modifiableList = new ArrayList<>(azElSegmentListParam.size());
            azElSegmentListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AzElSegment> copyFromBuilder(Collection<? extends AzElSegment.Builder> azElSegmentListParam) {
        List<AzElSegment> list;
        if (azElSegmentListParam == null || azElSegmentListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AzElSegment> modifiableList = new ArrayList<>(azElSegmentListParam.size());
            azElSegmentListParam.forEach(entry -> {
                AzElSegment member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AzElSegment.Builder> copyToBuilder(Collection<? extends AzElSegment> azElSegmentListParam) {
        List<AzElSegment.Builder> list;
        if (azElSegmentListParam == null || azElSegmentListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AzElSegment.Builder> modifiableList = new ArrayList<>(azElSegmentListParam.size());
            azElSegmentListParam.forEach(entry -> {
                AzElSegment.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
