/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Azimuth elevation segment collection.
 * </p>
 * <p>
 * Contains five or more time-ordered segments that define antenna pointing angles over the ephemeris validity period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AzElSegments implements SdkPojo, Serializable, ToCopyableBuilder<AzElSegments.Builder, AzElSegments> {
    private static final SdkField<String> ANGLE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("angleUnit").getter(getter(AzElSegments::angleUnitAsString)).setter(setter(Builder::angleUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("angleUnit").build()).build();

    private static final SdkField<List<AzElSegment>> AZ_EL_SEGMENT_LIST_FIELD = SdkField
            .<List<AzElSegment>> builder(MarshallingType.LIST)
            .memberName("azElSegmentList")
            .getter(getter(AzElSegments::azElSegmentList))
            .setter(setter(Builder::azElSegmentList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azElSegmentList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AzElSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AzElSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANGLE_UNIT_FIELD,
            AZ_EL_SEGMENT_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String angleUnit;

    private final List<AzElSegment> azElSegmentList;

    private AzElSegments(BuilderImpl builder) {
        this.angleUnit = builder.angleUnit;
        this.azElSegmentList = builder.azElSegmentList;
    }

    /**
     * <p>
     * The unit of measure for azimuth and elevation angles. All angles in all segments must use the same unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #angleUnit} will
     * return {@link AngleUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #angleUnitAsString}.
     * </p>
     * 
     * @return The unit of measure for azimuth and elevation angles. All angles in all segments must use the same unit.
     * @see AngleUnits
     */
    public final AngleUnits angleUnit() {
        return AngleUnits.fromValue(angleUnit);
    }

    /**
     * <p>
     * The unit of measure for azimuth and elevation angles. All angles in all segments must use the same unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #angleUnit} will
     * return {@link AngleUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #angleUnitAsString}.
     * </p>
     * 
     * @return The unit of measure for azimuth and elevation angles. All angles in all segments must use the same unit.
     * @see AngleUnits
     */
    public final String angleUnitAsString() {
        return angleUnit;
    }

    /**
     * For responses, this returns true if the service returned a value for the AzElSegmentList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAzElSegmentList() {
        return azElSegmentList != null && !(azElSegmentList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of azimuth elevation segments.
     * </p>
     * <p>
     * Must contain between 1 and 100 segments. Segments must be in chronological order with no overlaps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAzElSegmentList} method.
     * </p>
     * 
     * @return List of azimuth elevation segments.</p>
     *         <p>
     *         Must contain between 1 and 100 segments. Segments must be in chronological order with no overlaps.
     */
    public final List<AzElSegment> azElSegmentList() {
        return azElSegmentList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(angleUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAzElSegmentList() ? azElSegmentList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AzElSegments)) {
            return false;
        }
        AzElSegments other = (AzElSegments) obj;
        return Objects.equals(angleUnitAsString(), other.angleUnitAsString())
                && hasAzElSegmentList() == other.hasAzElSegmentList()
                && Objects.equals(azElSegmentList(), other.azElSegmentList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AzElSegments").add("AngleUnit", angleUnitAsString())
                .add("AzElSegmentList", hasAzElSegmentList() ? azElSegmentList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "angleUnit":
            return Optional.ofNullable(clazz.cast(angleUnitAsString()));
        case "azElSegmentList":
            return Optional.ofNullable(clazz.cast(azElSegmentList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("angleUnit", ANGLE_UNIT_FIELD);
        map.put("azElSegmentList", AZ_EL_SEGMENT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AzElSegments, T> g) {
        return obj -> g.apply((AzElSegments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AzElSegments> {
        /**
         * <p>
         * The unit of measure for azimuth and elevation angles. All angles in all segments must use the same unit.
         * </p>
         * 
         * @param angleUnit
         *        The unit of measure for azimuth and elevation angles. All angles in all segments must use the same
         *        unit.
         * @see AngleUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AngleUnits
         */
        Builder angleUnit(String angleUnit);

        /**
         * <p>
         * The unit of measure for azimuth and elevation angles. All angles in all segments must use the same unit.
         * </p>
         * 
         * @param angleUnit
         *        The unit of measure for azimuth and elevation angles. All angles in all segments must use the same
         *        unit.
         * @see AngleUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AngleUnits
         */
        Builder angleUnit(AngleUnits angleUnit);

        /**
         * <p>
         * List of azimuth elevation segments.
         * </p>
         * <p>
         * Must contain between 1 and 100 segments. Segments must be in chronological order with no overlaps.
         * </p>
         * 
         * @param azElSegmentList
         *        List of azimuth elevation segments.</p>
         *        <p>
         *        Must contain between 1 and 100 segments. Segments must be in chronological order with no overlaps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azElSegmentList(Collection<AzElSegment> azElSegmentList);

        /**
         * <p>
         * List of azimuth elevation segments.
         * </p>
         * <p>
         * Must contain between 1 and 100 segments. Segments must be in chronological order with no overlaps.
         * </p>
         * 
         * @param azElSegmentList
         *        List of azimuth elevation segments.</p>
         *        <p>
         *        Must contain between 1 and 100 segments. Segments must be in chronological order with no overlaps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azElSegmentList(AzElSegment... azElSegmentList);

        /**
         * <p>
         * List of azimuth elevation segments.
         * </p>
         * <p>
         * Must contain between 1 and 100 segments. Segments must be in chronological order with no overlaps.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.AzElSegment.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.groundstation.model.AzElSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.AzElSegment.Builder#build()} is called immediately
         * and its result is passed to {@link #azElSegmentList(List<AzElSegment>)}.
         * 
         * @param azElSegmentList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.AzElSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #azElSegmentList(java.util.Collection<AzElSegment>)
         */
        Builder azElSegmentList(Consumer<AzElSegment.Builder>... azElSegmentList);
    }

    static final class BuilderImpl implements Builder {
        private String angleUnit;

        private List<AzElSegment> azElSegmentList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AzElSegments model) {
            angleUnit(model.angleUnit);
            azElSegmentList(model.azElSegmentList);
        }

        public final String getAngleUnit() {
            return angleUnit;
        }

        public final void setAngleUnit(String angleUnit) {
            this.angleUnit = angleUnit;
        }

        @Override
        public final Builder angleUnit(String angleUnit) {
            this.angleUnit = angleUnit;
            return this;
        }

        @Override
        public final Builder angleUnit(AngleUnits angleUnit) {
            this.angleUnit(angleUnit == null ? null : angleUnit.toString());
            return this;
        }

        public final List<AzElSegment.Builder> getAzElSegmentList() {
            List<AzElSegment.Builder> result = AzElSegmentListCopier.copyToBuilder(this.azElSegmentList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAzElSegmentList(Collection<AzElSegment.BuilderImpl> azElSegmentList) {
            this.azElSegmentList = AzElSegmentListCopier.copyFromBuilder(azElSegmentList);
        }

        @Override
        public final Builder azElSegmentList(Collection<AzElSegment> azElSegmentList) {
            this.azElSegmentList = AzElSegmentListCopier.copy(azElSegmentList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azElSegmentList(AzElSegment... azElSegmentList) {
            azElSegmentList(Arrays.asList(azElSegmentList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azElSegmentList(Consumer<AzElSegment.Builder>... azElSegmentList) {
            azElSegmentList(Stream.of(azElSegmentList).map(c -> AzElSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AzElSegments build() {
            return new AzElSegments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
