/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for azimuth elevation segment data.
 * </p>
 * <p>
 * Specify either <a>AzElSegmentsData$s3Object</a> to reference data in Amazon S3, or <a>AzElSegmentsData$azElData</a>
 * to provide data inline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AzElSegmentsData implements SdkPojo, Serializable,
        ToCopyableBuilder<AzElSegmentsData.Builder, AzElSegmentsData> {
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("s3Object").getter(getter(AzElSegmentsData::s3Object)).setter(setter(Builder::s3Object))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()).build();

    private static final SdkField<AzElSegments> AZ_EL_DATA_FIELD = SdkField.<AzElSegments> builder(MarshallingType.SDK_POJO)
            .memberName("azElData").getter(getter(AzElSegmentsData::azElData)).setter(setter(Builder::azElData))
            .constructor(AzElSegments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azElData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_FIELD,
            AZ_EL_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Object s3Object;

    private final AzElSegments azElData;

    private final Type type;

    private AzElSegmentsData(BuilderImpl builder) {
        this.s3Object = builder.s3Object;
        this.azElData = builder.azElData;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon S3 object containing azimuth elevation segment data.
     * </p>
     * <p>
     * The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
     * structure.
     * </p>
     * 
     * @return The Amazon S3 object containing azimuth elevation segment data.</p>
     *         <p>
     *         The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
     *         structure.
     */
    public final S3Object s3Object() {
        return s3Object;
    }

    /**
     * <p>
     * Azimuth elevation segment data provided directly in the request.
     * </p>
     * <p>
     * Use this option for smaller datasets or when Amazon S3 access is not available.
     * </p>
     * 
     * @return Azimuth elevation segment data provided directly in the request.</p>
     *         <p>
     *         Use this option for smaller datasets or when Amazon S3 access is not available.
     */
    public final AzElSegments azElData() {
        return azElData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Object());
        hashCode = 31 * hashCode + Objects.hashCode(azElData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AzElSegmentsData)) {
            return false;
        }
        AzElSegmentsData other = (AzElSegmentsData) obj;
        return Objects.equals(s3Object(), other.s3Object()) && Objects.equals(azElData(), other.azElData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AzElSegmentsData").add("S3Object", s3Object()).add("AzElData", azElData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Object":
            return Optional.ofNullable(clazz.cast(s3Object()));
        case "azElData":
            return Optional.ofNullable(clazz.cast(azElData()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3Object()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 object containing azimuth elevation segment data.
     * </p>
     * <p>
     * The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
     * structure.
     * </p>
     * 
     * @param s3Object
     *        The Amazon S3 object containing azimuth elevation segment data.</p>
     *        <p>
     *        The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
     *        structure.
     */
    public static AzElSegmentsData fromS3Object(S3Object s3Object) {
        return builder().s3Object(s3Object).build();
    }

    /**
     * Create an instance of this class with {@link #s3Object()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 object containing azimuth elevation segment data.
     * </p>
     * <p>
     * The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
     * structure.
     * </p>
     * 
     * @param s3Object
     *        The Amazon S3 object containing azimuth elevation segment data.</p>
     *        <p>
     *        The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
     *        structure.
     */
    public static AzElSegmentsData fromS3Object(Consumer<S3Object.Builder> s3Object) {
        S3Object.Builder builder = S3Object.builder();
        s3Object.accept(builder);
        return fromS3Object(builder.build());
    }

    /**
     * Create an instance of this class with {@link #azElData()} initialized to the given value.
     *
     * <p>
     * Azimuth elevation segment data provided directly in the request.
     * </p>
     * <p>
     * Use this option for smaller datasets or when Amazon S3 access is not available.
     * </p>
     * 
     * @param azElData
     *        Azimuth elevation segment data provided directly in the request.</p>
     *        <p>
     *        Use this option for smaller datasets or when Amazon S3 access is not available.
     */
    public static AzElSegmentsData fromAzElData(AzElSegments azElData) {
        return builder().azElData(azElData).build();
    }

    /**
     * Create an instance of this class with {@link #azElData()} initialized to the given value.
     *
     * <p>
     * Azimuth elevation segment data provided directly in the request.
     * </p>
     * <p>
     * Use this option for smaller datasets or when Amazon S3 access is not available.
     * </p>
     * 
     * @param azElData
     *        Azimuth elevation segment data provided directly in the request.</p>
     *        <p>
     *        Use this option for smaller datasets or when Amazon S3 access is not available.
     */
    public static AzElSegmentsData fromAzElData(Consumer<AzElSegments.Builder> azElData) {
        AzElSegments.Builder builder = AzElSegments.builder();
        azElData.accept(builder);
        return fromAzElData(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Object", S3_OBJECT_FIELD);
        map.put("azElData", AZ_EL_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AzElSegmentsData, T> g) {
        return obj -> g.apply((AzElSegmentsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AzElSegmentsData> {
        /**
         * <p>
         * The Amazon S3 object containing azimuth elevation segment data.
         * </p>
         * <p>
         * The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
         * structure.
         * </p>
         * 
         * @param s3Object
         *        The Amazon S3 object containing azimuth elevation segment data.</p>
         *        <p>
         *        The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the
         *        <a>AzElSegments</a> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Object(S3Object s3Object);

        /**
         * <p>
         * The Amazon S3 object containing azimuth elevation segment data.
         * </p>
         * <p>
         * The Amazon S3 object must contain JSON-formatted azimuth elevation data matching the <a>AzElSegments</a>
         * structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Object(S3Object)}.
         * 
         * @param s3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Object(S3Object)
         */
        default Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return s3Object(S3Object.builder().applyMutation(s3Object).build());
        }

        /**
         * <p>
         * Azimuth elevation segment data provided directly in the request.
         * </p>
         * <p>
         * Use this option for smaller datasets or when Amazon S3 access is not available.
         * </p>
         * 
         * @param azElData
         *        Azimuth elevation segment data provided directly in the request.</p>
         *        <p>
         *        Use this option for smaller datasets or when Amazon S3 access is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azElData(AzElSegments azElData);

        /**
         * <p>
         * Azimuth elevation segment data provided directly in the request.
         * </p>
         * <p>
         * Use this option for smaller datasets or when Amazon S3 access is not available.
         * </p>
         * This is a convenience method that creates an instance of the {@link AzElSegments.Builder} avoiding the need
         * to create one manually via {@link AzElSegments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AzElSegments.Builder#build()} is called immediately and its
         * result is passed to {@link #azElData(AzElSegments)}.
         * 
         * @param azElData
         *        a consumer that will call methods on {@link AzElSegments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #azElData(AzElSegments)
         */
        default Builder azElData(Consumer<AzElSegments.Builder> azElData) {
            return azElData(AzElSegments.builder().applyMutation(azElData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Object s3Object;

        private AzElSegments azElData;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AzElSegmentsData model) {
            s3Object(model.s3Object);
            azElData(model.azElData);
        }

        public final S3Object.Builder getS3Object() {
            return s3Object != null ? s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            Object oldValue = this.s3Object;
            this.s3Object = s3Object != null ? s3Object.build() : null;
            handleUnionValueChange(Type.S3_OBJECT, oldValue, this.s3Object);
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            Object oldValue = this.s3Object;
            this.s3Object = s3Object;
            handleUnionValueChange(Type.S3_OBJECT, oldValue, this.s3Object);
            return this;
        }

        public final AzElSegments.Builder getAzElData() {
            return azElData != null ? azElData.toBuilder() : null;
        }

        public final void setAzElData(AzElSegments.BuilderImpl azElData) {
            Object oldValue = this.azElData;
            this.azElData = azElData != null ? azElData.build() : null;
            handleUnionValueChange(Type.AZ_EL_DATA, oldValue, this.azElData);
        }

        @Override
        public final Builder azElData(AzElSegments azElData) {
            Object oldValue = this.azElData;
            this.azElData = azElData;
            handleUnionValueChange(Type.AZ_EL_DATA, oldValue, this.azElData);
            return this;
        }

        @Override
        public AzElSegmentsData build() {
            return new AzElSegmentsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AzElSegmentsData#type()
     */
    public enum Type {
        S3_OBJECT,

        AZ_EL_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
