/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data on the status of agent components.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentStatusData implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentStatusData.Builder, ComponentStatusData> {
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentType").getter(getter(ComponentStatusData::componentType))
            .setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()).build();

    private static final SdkField<String> CAPABILITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityArn").getter(getter(ComponentStatusData::capabilityArn))
            .setter(setter(Builder::capabilityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ComponentStatusData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> BYTES_SENT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("bytesSent")
            .getter(getter(ComponentStatusData::bytesSent)).setter(setter(Builder::bytesSent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesSent").build()).build();

    private static final SdkField<Long> BYTES_RECEIVED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bytesReceived").getter(getter(ComponentStatusData::bytesReceived))
            .setter(setter(Builder::bytesReceived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesReceived").build()).build();

    private static final SdkField<Long> PACKETS_DROPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("packetsDropped").getter(getter(ComponentStatusData::packetsDropped))
            .setter(setter(Builder::packetsDropped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetsDropped").build()).build();

    private static final SdkField<String> DATAFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowId").getter(getter(ComponentStatusData::dataflowId)).setter(setter(Builder::dataflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COMPONENT_TYPE_FIELD, CAPABILITY_ARN_FIELD, STATUS_FIELD, BYTES_SENT_FIELD,
                    BYTES_RECEIVED_FIELD, PACKETS_DROPPED_FIELD, DATAFLOW_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentType;

    private final String capabilityArn;

    private final String status;

    private final Long bytesSent;

    private final Long bytesReceived;

    private final Long packetsDropped;

    private final String dataflowId;

    private ComponentStatusData(BuilderImpl builder) {
        this.componentType = builder.componentType;
        this.capabilityArn = builder.capabilityArn;
        this.status = builder.status;
        this.bytesSent = builder.bytesSent;
        this.bytesReceived = builder.bytesReceived;
        this.packetsDropped = builder.packetsDropped;
        this.dataflowId = builder.dataflowId;
    }

    /**
     * <p>
     * The Component type.
     * </p>
     * 
     * @return The Component type.
     */
    public final String componentType() {
        return componentType;
    }

    /**
     * <p>
     * Capability ARN of the component.
     * </p>
     * 
     * @return Capability ARN of the component.
     */
    public final String capabilityArn() {
        return capabilityArn;
    }

    /**
     * <p>
     * Component status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Component status.
     * @see AgentStatus
     */
    public final AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * Component status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Component status.
     * @see AgentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Bytes sent by the component.
     * </p>
     * 
     * @return Bytes sent by the component.
     */
    public final Long bytesSent() {
        return bytesSent;
    }

    /**
     * <p>
     * Bytes received by the component.
     * </p>
     * 
     * @return Bytes received by the component.
     */
    public final Long bytesReceived() {
        return bytesReceived;
    }

    /**
     * <p>
     * Packets dropped by component.
     * </p>
     * 
     * @return Packets dropped by component.
     */
    public final Long packetsDropped() {
        return packetsDropped;
    }

    /**
     * <p>
     * Dataflow UUID associated with the component.
     * </p>
     * 
     * @return Dataflow UUID associated with the component.
     */
    public final String dataflowId() {
        return dataflowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentType());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bytesSent());
        hashCode = 31 * hashCode + Objects.hashCode(bytesReceived());
        hashCode = 31 * hashCode + Objects.hashCode(packetsDropped());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentStatusData)) {
            return false;
        }
        ComponentStatusData other = (ComponentStatusData) obj;
        return Objects.equals(componentType(), other.componentType()) && Objects.equals(capabilityArn(), other.capabilityArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(bytesSent(), other.bytesSent())
                && Objects.equals(bytesReceived(), other.bytesReceived())
                && Objects.equals(packetsDropped(), other.packetsDropped()) && Objects.equals(dataflowId(), other.dataflowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentStatusData").add("ComponentType", componentType())
                .add("CapabilityArn", capabilityArn()).add("Status", statusAsString()).add("BytesSent", bytesSent())
                .add("BytesReceived", bytesReceived()).add("PacketsDropped", packetsDropped()).add("DataflowId", dataflowId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        case "capabilityArn":
            return Optional.ofNullable(clazz.cast(capabilityArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "bytesSent":
            return Optional.ofNullable(clazz.cast(bytesSent()));
        case "bytesReceived":
            return Optional.ofNullable(clazz.cast(bytesReceived()));
        case "packetsDropped":
            return Optional.ofNullable(clazz.cast(packetsDropped()));
        case "dataflowId":
            return Optional.ofNullable(clazz.cast(dataflowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentType", COMPONENT_TYPE_FIELD);
        map.put("capabilityArn", CAPABILITY_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("bytesSent", BYTES_SENT_FIELD);
        map.put("bytesReceived", BYTES_RECEIVED_FIELD);
        map.put("packetsDropped", PACKETS_DROPPED_FIELD);
        map.put("dataflowId", DATAFLOW_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentStatusData, T> g) {
        return obj -> g.apply((ComponentStatusData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentStatusData> {
        /**
         * <p>
         * The Component type.
         * </p>
         * 
         * @param componentType
         *        The Component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(String componentType);

        /**
         * <p>
         * Capability ARN of the component.
         * </p>
         * 
         * @param capabilityArn
         *        Capability ARN of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityArn(String capabilityArn);

        /**
         * <p>
         * Component status.
         * </p>
         * 
         * @param status
         *        Component status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Component status.
         * </p>
         * 
         * @param status
         *        Component status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);

        /**
         * <p>
         * Bytes sent by the component.
         * </p>
         * 
         * @param bytesSent
         *        Bytes sent by the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesSent(Long bytesSent);

        /**
         * <p>
         * Bytes received by the component.
         * </p>
         * 
         * @param bytesReceived
         *        Bytes received by the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesReceived(Long bytesReceived);

        /**
         * <p>
         * Packets dropped by component.
         * </p>
         * 
         * @param packetsDropped
         *        Packets dropped by component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetsDropped(Long packetsDropped);

        /**
         * <p>
         * Dataflow UUID associated with the component.
         * </p>
         * 
         * @param dataflowId
         *        Dataflow UUID associated with the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowId(String dataflowId);
    }

    static final class BuilderImpl implements Builder {
        private String componentType;

        private String capabilityArn;

        private String status;

        private Long bytesSent;

        private Long bytesReceived;

        private Long packetsDropped;

        private String dataflowId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentStatusData model) {
            componentType(model.componentType);
            capabilityArn(model.capabilityArn);
            status(model.status);
            bytesSent(model.bytesSent);
            bytesReceived(model.bytesReceived);
            packetsDropped(model.packetsDropped);
            dataflowId(model.dataflowId);
        }

        public final String getComponentType() {
            return componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final String getCapabilityArn() {
            return capabilityArn;
        }

        public final void setCapabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
        }

        @Override
        public final Builder capabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getBytesSent() {
            return bytesSent;
        }

        public final void setBytesSent(Long bytesSent) {
            this.bytesSent = bytesSent;
        }

        @Override
        public final Builder bytesSent(Long bytesSent) {
            this.bytesSent = bytesSent;
            return this;
        }

        public final Long getBytesReceived() {
            return bytesReceived;
        }

        public final void setBytesReceived(Long bytesReceived) {
            this.bytesReceived = bytesReceived;
        }

        @Override
        public final Builder bytesReceived(Long bytesReceived) {
            this.bytesReceived = bytesReceived;
            return this;
        }

        public final Long getPacketsDropped() {
            return packetsDropped;
        }

        public final void setPacketsDropped(Long packetsDropped) {
            this.packetsDropped = packetsDropped;
        }

        @Override
        public final Builder packetsDropped(Long packetsDropped) {
            this.packetsDropped = packetsDropped;
            return this;
        }

        public final String getDataflowId() {
            return dataflowId;
        }

        public final void setDataflowId(String dataflowId) {
            this.dataflowId = dataflowId;
        }

        @Override
        public final Builder dataflowId(String dataflowId) {
            this.dataflowId = dataflowId;
            return this;
        }

        @Override
        public ComponentStatusData build() {
            return new ComponentStatusData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
