/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An item in a list of <code>Config</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigListItem implements SdkPojo, Serializable, ToCopyableBuilder<ConfigListItem.Builder, ConfigListItem> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configId").getter(getter(ConfigListItem::configId)).setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()).build();

    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configType").getter(getter(ConfigListItem::configTypeAsString)).setter(setter(Builder::configType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()).build();

    private static final SdkField<String> CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configArn").getter(getter(ConfigListItem::configArn)).setter(setter(Builder::configArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfigListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD,
            CONFIG_TYPE_FIELD, CONFIG_ARN_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configId;

    private final String configType;

    private final String configArn;

    private final String name;

    private ConfigListItem(BuilderImpl builder) {
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.configArn = builder.configArn;
        this.name = builder.name;
    }

    /**
     * <p>
     * UUID of a <code>Config</code>.
     * </p>
     * 
     * @return UUID of a <code>Config</code>.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(configType);
    }

    /**
     * <p>
     * Type of a <code>Config</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configType} will
     * return {@link ConfigCapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #configTypeAsString}.
     * </p>
     * 
     * @return Type of a <code>Config</code>.
     * @see ConfigCapabilityType
     */
    public final String configTypeAsString() {
        return configType;
    }

    /**
     * <p>
     * ARN of a <code>Config</code>.
     * </p>
     * 
     * @return ARN of a <code>Config</code>.
     */
    public final String configArn() {
        return configArn;
    }

    /**
     * <p>
     * Name of a <code>Config</code>.
     * </p>
     * 
     * @return Name of a <code>Config</code>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigListItem)) {
            return false;
        }
        ConfigListItem other = (ConfigListItem) obj;
        return Objects.equals(configId(), other.configId()) && Objects.equals(configTypeAsString(), other.configTypeAsString())
                && Objects.equals(configArn(), other.configArn()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigListItem").add("ConfigId", configId()).add("ConfigType", configTypeAsString())
                .add("ConfigArn", configArn()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "configType":
            return Optional.ofNullable(clazz.cast(configTypeAsString()));
        case "configArn":
            return Optional.ofNullable(clazz.cast(configArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configId", CONFIG_ID_FIELD);
        map.put("configType", CONFIG_TYPE_FIELD);
        map.put("configArn", CONFIG_ARN_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigListItem, T> g) {
        return obj -> g.apply((ConfigListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigListItem> {
        /**
         * <p>
         * UUID of a <code>Config</code>.
         * </p>
         * 
         * @param configId
         *        UUID of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(String configType);

        /**
         * <p>
         * Type of a <code>Config</code>.
         * </p>
         * 
         * @param configType
         *        Type of a <code>Config</code>.
         * @see ConfigCapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigCapabilityType
         */
        Builder configType(ConfigCapabilityType configType);

        /**
         * <p>
         * ARN of a <code>Config</code>.
         * </p>
         * 
         * @param configArn
         *        ARN of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configArn(String configArn);

        /**
         * <p>
         * Name of a <code>Config</code>.
         * </p>
         * 
         * @param name
         *        Name of a <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String configId;

        private String configType;

        private String configArn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigListItem model) {
            configId(model.configId);
            configType(model.configType);
            configArn(model.configArn);
            name(model.name);
        }

        public final String getConfigId() {
            return configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getConfigType() {
            return configType;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final String getConfigArn() {
            return configArn;
        }

        public final void setConfigArn(String configArn) {
            this.configArn = configArn;
        }

        @Override
        public final Builder configArn(String configArn) {
            this.configArn = configArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ConfigListItem build() {
            return new ConfigListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
